//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Tenant attributes representing a single tenant within weaviate
//
// swagger:model Tenant
type Tenant struct {

	// activity status of the tenant's shard. Optional for creating tenant (implicit `ACTIVE`) and required for updating tenant. For creation, allowed values are `ACTIVE` - tenant is fully active and `INACTIVE` - tenant is inactive; no actions can be performed on tenant, tenant's files are stored locally. For updating, `ACTIVE`, `INACTIVE` and also `OFFLOADED` - as INACTIVE, but files are stored on cloud storage. The following values are read-only and are set by the server for internal use: `OFFLOADING` - tenant is transitioning from ACTIVE/INACTIVE to OFFLOADED, `ONLOADING` - tenant is transitioning from OFFLOADED to ACTIVE/INACTIVE. We still accept deprecated names `HOT` (now `ACTIVE`), `COLD` (now `INACTIVE`), `FROZEN` (now `OFFLOADED`), `FREEZING` (now `OFFLOADING`), `UNFREEZING` (now `ONLOADING`).
	// Enum: [ACTIVE INACTIVE OFFLOADED OFFLOADING ONLOADING HOT COLD FROZEN FREEZING UNFREEZING]
	ActivityStatus string `json:"activityStatus,omitempty"`

	// The name of the tenant (required).
	Name string `json:"name,omitempty"`
}

// Validate validates this tenant
func (m *Tenant) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActivityStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var tenantTypeActivityStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ACTIVE","INACTIVE","OFFLOADED","OFFLOADING","ONLOADING","HOT","COLD","FROZEN","FREEZING","UNFREEZING"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		tenantTypeActivityStatusPropEnum = append(tenantTypeActivityStatusPropEnum, v)
	}
}

const (

	// TenantActivityStatusACTIVE captures enum value "ACTIVE"
	TenantActivityStatusACTIVE string = "ACTIVE"

	// TenantActivityStatusINACTIVE captures enum value "INACTIVE"
	TenantActivityStatusINACTIVE string = "INACTIVE"

	// TenantActivityStatusOFFLOADED captures enum value "OFFLOADED"
	TenantActivityStatusOFFLOADED string = "OFFLOADED"

	// TenantActivityStatusOFFLOADING captures enum value "OFFLOADING"
	TenantActivityStatusOFFLOADING string = "OFFLOADING"

	// TenantActivityStatusONLOADING captures enum value "ONLOADING"
	TenantActivityStatusONLOADING string = "ONLOADING"

	// TenantActivityStatusHOT captures enum value "HOT"
	TenantActivityStatusHOT string = "HOT"

	// TenantActivityStatusCOLD captures enum value "COLD"
	TenantActivityStatusCOLD string = "COLD"

	// TenantActivityStatusFROZEN captures enum value "FROZEN"
	TenantActivityStatusFROZEN string = "FROZEN"

	// TenantActivityStatusFREEZING captures enum value "FREEZING"
	TenantActivityStatusFREEZING string = "FREEZING"

	// TenantActivityStatusUNFREEZING captures enum value "UNFREEZING"
	TenantActivityStatusUNFREEZING string = "UNFREEZING"
)

// prop value enum
func (m *Tenant) validateActivityStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, tenantTypeActivityStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Tenant) validateActivityStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.ActivityStatus) { // not required
		return nil
	}

	// value enum
	if err := m.validateActivityStatusEnum("activityStatus", "body", m.ActivityStatus); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tenant based on context it is used
func (m *Tenant) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *Tenant) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Tenant) UnmarshalBinary(b []byte) error {
	var res Tenant
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
