//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Property property
//
// swagger:model Property
type Property struct {

	// Data type of the property (required). If it starts with a capital (for example Person), may be a reference to another type.
	DataType []string `json:"dataType"`

	// Description of the property.
	Description string `json:"description,omitempty"`

	// Whether to include this property in the filterable, Roaring Bitmap index. If `false`, this property cannot be used in `where` filters. <br/><br/>Note: Unrelated to vectorization behavior.
	IndexFilterable *bool `json:"indexFilterable,omitempty"`

	// (Deprecated). Whether to include this property in the inverted index. If `false`, this property cannot be used in `where` filters, `bm25` or `hybrid` search. <br/><br/>Unrelated to vectorization behavior (deprecated as of v1.19; use indexFilterable or/and indexSearchable instead)
	IndexInverted *bool `json:"indexInverted,omitempty"`

	// Whether to include this property in the filterable, range-based Roaring Bitmap index. Provides better performance for range queries compared to filterable index in large datasets. Applicable only to properties of data type int, number, date.
	IndexRangeFilters *bool `json:"indexRangeFilters,omitempty"`

	// Optional. Should this property be indexed in the inverted index. Defaults to true. Applicable only to properties of data type text and text[]. If you choose false, you will not be able to use this property in bm25 or hybrid search. This property has no affect on vectorization decisions done by modules
	IndexSearchable *bool `json:"indexSearchable,omitempty"`

	// Configuration specific to modules this Weaviate instance has installed
	ModuleConfig interface{} `json:"moduleConfig,omitempty"`

	// The name of the property (required). Multiple words should be concatenated in camelCase, e.g. `nameOfAuthor`.
	Name string `json:"name,omitempty"`

	// The properties of the nested object(s). Applies to object and object[] data types.
	NestedProperties []*NestedProperty `json:"nestedProperties,omitempty"`

	// Determines tokenization of the property as separate words or whole field. Optional. Applies to text and text[] data types. Allowed values are `word` (default; splits on any non-alphanumerical, lowercases), `lowercase` (splits on white spaces, lowercases), `whitespace` (splits on white spaces), `field` (trims). Not supported for remaining data types
	// Enum: [word lowercase whitespace field trigram gse kagome_kr kagome_ja]
	Tokenization string `json:"tokenization,omitempty"`
}

// Validate validates this property
func (m *Property) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNestedProperties(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTokenization(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Property) validateNestedProperties(formats strfmt.Registry) error {
	if swag.IsZero(m.NestedProperties) { // not required
		return nil
	}

	for i := 0; i < len(m.NestedProperties); i++ {
		if swag.IsZero(m.NestedProperties[i]) { // not required
			continue
		}

		if m.NestedProperties[i] != nil {
			if err := m.NestedProperties[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nestedProperties" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("nestedProperties" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var propertyTypeTokenizationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["word","lowercase","whitespace","field","trigram","gse","kagome_kr","kagome_ja"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		propertyTypeTokenizationPropEnum = append(propertyTypeTokenizationPropEnum, v)
	}
}

const (

	// PropertyTokenizationWord captures enum value "word"
	PropertyTokenizationWord string = "word"

	// PropertyTokenizationLowercase captures enum value "lowercase"
	PropertyTokenizationLowercase string = "lowercase"

	// PropertyTokenizationWhitespace captures enum value "whitespace"
	PropertyTokenizationWhitespace string = "whitespace"

	// PropertyTokenizationField captures enum value "field"
	PropertyTokenizationField string = "field"

	// PropertyTokenizationTrigram captures enum value "trigram"
	PropertyTokenizationTrigram string = "trigram"

	// PropertyTokenizationGse captures enum value "gse"
	PropertyTokenizationGse string = "gse"

	// PropertyTokenizationKagomeKr captures enum value "kagome_kr"
	PropertyTokenizationKagomeKr string = "kagome_kr"

	// PropertyTokenizationKagomeJa captures enum value "kagome_ja"
	PropertyTokenizationKagomeJa string = "kagome_ja"
)

// prop value enum
func (m *Property) validateTokenizationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, propertyTypeTokenizationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Property) validateTokenization(formats strfmt.Registry) error {
	if swag.IsZero(m.Tokenization) { // not required
		return nil
	}

	// value enum
	if err := m.validateTokenizationEnum("tokenization", "body", m.Tokenization); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this property based on the context it is used
func (m *Property) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNestedProperties(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Property) contextValidateNestedProperties(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NestedProperties); i++ {

		if m.NestedProperties[i] != nil {
			if err := m.NestedProperties[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nestedProperties" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("nestedProperties" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Property) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Property) UnmarshalBinary(b []byte) error {
	var res Property
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
