//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NodeShardStatus The definition of a node shard status response body
//
// swagger:model NodeShardStatus
type NodeShardStatus struct {

	// The name of shard's class.
	Class string `json:"class"`

	// The status of vector compression/quantization.
	Compressed bool `json:"compressed"`

	// The load status of the shard.
	Loaded bool `json:"loaded"`

	// The name of the shard.
	Name string `json:"name"`

	// The number of objects in shard.
	ObjectCount int64 `json:"objectCount"`

	// The status of the vector indexing process.
	VectorIndexingStatus string `json:"vectorIndexingStatus"`

	// The length of the vector indexing queue.
	VectorQueueLength int64 `json:"vectorQueueLength"`
}

// Validate validates this node shard status
func (m *NodeShardStatus) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this node shard status based on context it is used
func (m *NodeShardStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeShardStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeShardStatus) UnmarshalBinary(b []byte) error {
	var res NodeShardStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
