//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// BackupCreateStatusResponse The definition of a backup create metadata
//
// swagger:model BackupCreateStatusResponse
type BackupCreateStatusResponse struct {

	// Backup backend name e.g. filesystem, gcs, s3.
	Backend string `json:"backend,omitempty"`

	// error message if creation failed
	Error string `json:"error,omitempty"`

	// The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.
	ID string `json:"id,omitempty"`

	// destination path of backup files proper to selected backend
	Path string `json:"path,omitempty"`

	// phase of backup creation process
	// Enum: [STARTED TRANSFERRING TRANSFERRED SUCCESS FAILED CANCELED]
	Status *string `json:"status,omitempty"`
}

// Validate validates this backup create status response
func (m *BackupCreateStatusResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var backupCreateStatusResponseTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["STARTED","TRANSFERRING","TRANSFERRED","SUCCESS","FAILED","CANCELED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		backupCreateStatusResponseTypeStatusPropEnum = append(backupCreateStatusResponseTypeStatusPropEnum, v)
	}
}

const (

	// BackupCreateStatusResponseStatusSTARTED captures enum value "STARTED"
	BackupCreateStatusResponseStatusSTARTED string = "STARTED"

	// BackupCreateStatusResponseStatusTRANSFERRING captures enum value "TRANSFERRING"
	BackupCreateStatusResponseStatusTRANSFERRING string = "TRANSFERRING"

	// BackupCreateStatusResponseStatusTRANSFERRED captures enum value "TRANSFERRED"
	BackupCreateStatusResponseStatusTRANSFERRED string = "TRANSFERRED"

	// BackupCreateStatusResponseStatusSUCCESS captures enum value "SUCCESS"
	BackupCreateStatusResponseStatusSUCCESS string = "SUCCESS"

	// BackupCreateStatusResponseStatusFAILED captures enum value "FAILED"
	BackupCreateStatusResponseStatusFAILED string = "FAILED"

	// BackupCreateStatusResponseStatusCANCELED captures enum value "CANCELED"
	BackupCreateStatusResponseStatusCANCELED string = "CANCELED"
)

// prop value enum
func (m *BackupCreateStatusResponse) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, backupCreateStatusResponseTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *BackupCreateStatusResponse) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this backup create status response based on context it is used
func (m *BackupCreateStatusResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *BackupCreateStatusResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BackupCreateStatusResponse) UnmarshalBinary(b []byte) error {
	var res BackupCreateStatusResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
