//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewTenantsGetOneParams creates a new TenantsGetOneParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewTenantsGetOneParams() *TenantsGetOneParams {
	return &TenantsGetOneParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewTenantsGetOneParamsWithTimeout creates a new TenantsGetOneParams object
// with the ability to set a timeout on a request.
func NewTenantsGetOneParamsWithTimeout(timeout time.Duration) *TenantsGetOneParams {
	return &TenantsGetOneParams{
		timeout: timeout,
	}
}

// NewTenantsGetOneParamsWithContext creates a new TenantsGetOneParams object
// with the ability to set a context for a request.
func NewTenantsGetOneParamsWithContext(ctx context.Context) *TenantsGetOneParams {
	return &TenantsGetOneParams{
		Context: ctx,
	}
}

// NewTenantsGetOneParamsWithHTTPClient creates a new TenantsGetOneParams object
// with the ability to set a custom HTTPClient for a request.
func NewTenantsGetOneParamsWithHTTPClient(client *http.Client) *TenantsGetOneParams {
	return &TenantsGetOneParams{
		HTTPClient: client,
	}
}

/*
TenantsGetOneParams contains all the parameters to send to the API endpoint

	for the tenants get one operation.

	Typically these are written to a http.Request.
*/
type TenantsGetOneParams struct {

	// ClassName.
	ClassName string

	/* Consistency.

	   If consistency is true, the request will be proxied to the leader to ensure strong schema consistency

	   Default: true
	*/
	Consistency *bool

	// TenantName.
	TenantName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the tenants get one params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TenantsGetOneParams) WithDefaults() *TenantsGetOneParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the tenants get one params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *TenantsGetOneParams) SetDefaults() {
	var (
		consistencyDefault = bool(true)
	)

	val := TenantsGetOneParams{
		Consistency: &consistencyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the tenants get one params
func (o *TenantsGetOneParams) WithTimeout(timeout time.Duration) *TenantsGetOneParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the tenants get one params
func (o *TenantsGetOneParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the tenants get one params
func (o *TenantsGetOneParams) WithContext(ctx context.Context) *TenantsGetOneParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the tenants get one params
func (o *TenantsGetOneParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the tenants get one params
func (o *TenantsGetOneParams) WithHTTPClient(client *http.Client) *TenantsGetOneParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the tenants get one params
func (o *TenantsGetOneParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClassName adds the className to the tenants get one params
func (o *TenantsGetOneParams) WithClassName(className string) *TenantsGetOneParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the tenants get one params
func (o *TenantsGetOneParams) SetClassName(className string) {
	o.ClassName = className
}

// WithConsistency adds the consistency to the tenants get one params
func (o *TenantsGetOneParams) WithConsistency(consistency *bool) *TenantsGetOneParams {
	o.SetConsistency(consistency)
	return o
}

// SetConsistency adds the consistency to the tenants get one params
func (o *TenantsGetOneParams) SetConsistency(consistency *bool) {
	o.Consistency = consistency
}

// WithTenantName adds the tenantName to the tenants get one params
func (o *TenantsGetOneParams) WithTenantName(tenantName string) *TenantsGetOneParams {
	o.SetTenantName(tenantName)
	return o
}

// SetTenantName adds the tenantName to the tenants get one params
func (o *TenantsGetOneParams) SetTenantName(tenantName string) {
	o.TenantName = tenantName
}

// WriteToRequest writes these params to a swagger request
func (o *TenantsGetOneParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.Consistency != nil {

		// header param consistency
		if err := r.SetHeaderParam("consistency", swag.FormatBool(*o.Consistency)); err != nil {
			return err
		}
	}

	// path param tenantName
	if err := r.SetPathParam("tenantName", o.TenantName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
