//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsPatchReader is a Reader for the ObjectsPatch structure.
type ObjectsPatchReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsPatchReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewObjectsPatchNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewObjectsPatchBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewObjectsPatchUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsPatchForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsPatchNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsPatchUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsPatchInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsPatchNoContent creates a ObjectsPatchNoContent with default headers values
func NewObjectsPatchNoContent() *ObjectsPatchNoContent {
	return &ObjectsPatchNoContent{}
}

/*
ObjectsPatchNoContent describes a response with status code 204, with default header values.

Successfully applied. No content provided.
*/
type ObjectsPatchNoContent struct {
}

// IsSuccess returns true when this objects patch no content response has a 2xx status code
func (o *ObjectsPatchNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects patch no content response has a 3xx status code
func (o *ObjectsPatchNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch no content response has a 4xx status code
func (o *ObjectsPatchNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects patch no content response has a 5xx status code
func (o *ObjectsPatchNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch no content response a status code equal to that given
func (o *ObjectsPatchNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the objects patch no content response
func (o *ObjectsPatchNoContent) Code() int {
	return 204
}

func (o *ObjectsPatchNoContent) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchNoContent ", 204)
}

func (o *ObjectsPatchNoContent) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchNoContent ", 204)
}

func (o *ObjectsPatchNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsPatchBadRequest creates a ObjectsPatchBadRequest with default headers values
func NewObjectsPatchBadRequest() *ObjectsPatchBadRequest {
	return &ObjectsPatchBadRequest{}
}

/*
ObjectsPatchBadRequest describes a response with status code 400, with default header values.

The patch-JSON is malformed.
*/
type ObjectsPatchBadRequest struct {
}

// IsSuccess returns true when this objects patch bad request response has a 2xx status code
func (o *ObjectsPatchBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch bad request response has a 3xx status code
func (o *ObjectsPatchBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch bad request response has a 4xx status code
func (o *ObjectsPatchBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects patch bad request response has a 5xx status code
func (o *ObjectsPatchBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch bad request response a status code equal to that given
func (o *ObjectsPatchBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the objects patch bad request response
func (o *ObjectsPatchBadRequest) Code() int {
	return 400
}

func (o *ObjectsPatchBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchBadRequest ", 400)
}

func (o *ObjectsPatchBadRequest) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchBadRequest ", 400)
}

func (o *ObjectsPatchBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsPatchUnauthorized creates a ObjectsPatchUnauthorized with default headers values
func NewObjectsPatchUnauthorized() *ObjectsPatchUnauthorized {
	return &ObjectsPatchUnauthorized{}
}

/*
ObjectsPatchUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsPatchUnauthorized struct {
}

// IsSuccess returns true when this objects patch unauthorized response has a 2xx status code
func (o *ObjectsPatchUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch unauthorized response has a 3xx status code
func (o *ObjectsPatchUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch unauthorized response has a 4xx status code
func (o *ObjectsPatchUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects patch unauthorized response has a 5xx status code
func (o *ObjectsPatchUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch unauthorized response a status code equal to that given
func (o *ObjectsPatchUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects patch unauthorized response
func (o *ObjectsPatchUnauthorized) Code() int {
	return 401
}

func (o *ObjectsPatchUnauthorized) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchUnauthorized ", 401)
}

func (o *ObjectsPatchUnauthorized) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchUnauthorized ", 401)
}

func (o *ObjectsPatchUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsPatchForbidden creates a ObjectsPatchForbidden with default headers values
func NewObjectsPatchForbidden() *ObjectsPatchForbidden {
	return &ObjectsPatchForbidden{}
}

/*
ObjectsPatchForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsPatchForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects patch forbidden response has a 2xx status code
func (o *ObjectsPatchForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch forbidden response has a 3xx status code
func (o *ObjectsPatchForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch forbidden response has a 4xx status code
func (o *ObjectsPatchForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects patch forbidden response has a 5xx status code
func (o *ObjectsPatchForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch forbidden response a status code equal to that given
func (o *ObjectsPatchForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects patch forbidden response
func (o *ObjectsPatchForbidden) Code() int {
	return 403
}

func (o *ObjectsPatchForbidden) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsPatchForbidden) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsPatchForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsPatchForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsPatchNotFound creates a ObjectsPatchNotFound with default headers values
func NewObjectsPatchNotFound() *ObjectsPatchNotFound {
	return &ObjectsPatchNotFound{}
}

/*
ObjectsPatchNotFound describes a response with status code 404, with default header values.

Successful query result but no resource was found.
*/
type ObjectsPatchNotFound struct {
}

// IsSuccess returns true when this objects patch not found response has a 2xx status code
func (o *ObjectsPatchNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch not found response has a 3xx status code
func (o *ObjectsPatchNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch not found response has a 4xx status code
func (o *ObjectsPatchNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects patch not found response has a 5xx status code
func (o *ObjectsPatchNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch not found response a status code equal to that given
func (o *ObjectsPatchNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects patch not found response
func (o *ObjectsPatchNotFound) Code() int {
	return 404
}

func (o *ObjectsPatchNotFound) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchNotFound ", 404)
}

func (o *ObjectsPatchNotFound) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchNotFound ", 404)
}

func (o *ObjectsPatchNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsPatchUnprocessableEntity creates a ObjectsPatchUnprocessableEntity with default headers values
func NewObjectsPatchUnprocessableEntity() *ObjectsPatchUnprocessableEntity {
	return &ObjectsPatchUnprocessableEntity{}
}

/*
ObjectsPatchUnprocessableEntity describes a response with status code 422, with default header values.

The patch-JSON is valid but unprocessable.
*/
type ObjectsPatchUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects patch unprocessable entity response has a 2xx status code
func (o *ObjectsPatchUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch unprocessable entity response has a 3xx status code
func (o *ObjectsPatchUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch unprocessable entity response has a 4xx status code
func (o *ObjectsPatchUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects patch unprocessable entity response has a 5xx status code
func (o *ObjectsPatchUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects patch unprocessable entity response a status code equal to that given
func (o *ObjectsPatchUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects patch unprocessable entity response
func (o *ObjectsPatchUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsPatchUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsPatchUnprocessableEntity) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsPatchUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsPatchUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsPatchInternalServerError creates a ObjectsPatchInternalServerError with default headers values
func NewObjectsPatchInternalServerError() *ObjectsPatchInternalServerError {
	return &ObjectsPatchInternalServerError{}
}

/*
ObjectsPatchInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ObjectsPatchInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects patch internal server error response has a 2xx status code
func (o *ObjectsPatchInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects patch internal server error response has a 3xx status code
func (o *ObjectsPatchInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects patch internal server error response has a 4xx status code
func (o *ObjectsPatchInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects patch internal server error response has a 5xx status code
func (o *ObjectsPatchInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects patch internal server error response a status code equal to that given
func (o *ObjectsPatchInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects patch internal server error response
func (o *ObjectsPatchInternalServerError) Code() int {
	return 500
}

func (o *ObjectsPatchInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsPatchInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /objects/{id}][%d] objectsPatchInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsPatchInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsPatchInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
