//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsDeleteReader is a Reader for the ObjectsDelete structure.
type ObjectsDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewObjectsDeleteNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewObjectsDeleteUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsDeleteForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsDeleteNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsDeleteNoContent creates a ObjectsDeleteNoContent with default headers values
func NewObjectsDeleteNoContent() *ObjectsDeleteNoContent {
	return &ObjectsDeleteNoContent{}
}

/*
ObjectsDeleteNoContent describes a response with status code 204, with default header values.

Successfully deleted.
*/
type ObjectsDeleteNoContent struct {
}

// IsSuccess returns true when this objects delete no content response has a 2xx status code
func (o *ObjectsDeleteNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects delete no content response has a 3xx status code
func (o *ObjectsDeleteNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects delete no content response has a 4xx status code
func (o *ObjectsDeleteNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects delete no content response has a 5xx status code
func (o *ObjectsDeleteNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this objects delete no content response a status code equal to that given
func (o *ObjectsDeleteNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the objects delete no content response
func (o *ObjectsDeleteNoContent) Code() int {
	return 204
}

func (o *ObjectsDeleteNoContent) Error() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteNoContent ", 204)
}

func (o *ObjectsDeleteNoContent) String() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteNoContent ", 204)
}

func (o *ObjectsDeleteNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsDeleteUnauthorized creates a ObjectsDeleteUnauthorized with default headers values
func NewObjectsDeleteUnauthorized() *ObjectsDeleteUnauthorized {
	return &ObjectsDeleteUnauthorized{}
}

/*
ObjectsDeleteUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsDeleteUnauthorized struct {
}

// IsSuccess returns true when this objects delete unauthorized response has a 2xx status code
func (o *ObjectsDeleteUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects delete unauthorized response has a 3xx status code
func (o *ObjectsDeleteUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects delete unauthorized response has a 4xx status code
func (o *ObjectsDeleteUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects delete unauthorized response has a 5xx status code
func (o *ObjectsDeleteUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects delete unauthorized response a status code equal to that given
func (o *ObjectsDeleteUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects delete unauthorized response
func (o *ObjectsDeleteUnauthorized) Code() int {
	return 401
}

func (o *ObjectsDeleteUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteUnauthorized ", 401)
}

func (o *ObjectsDeleteUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteUnauthorized ", 401)
}

func (o *ObjectsDeleteUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsDeleteForbidden creates a ObjectsDeleteForbidden with default headers values
func NewObjectsDeleteForbidden() *ObjectsDeleteForbidden {
	return &ObjectsDeleteForbidden{}
}

/*
ObjectsDeleteForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsDeleteForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects delete forbidden response has a 2xx status code
func (o *ObjectsDeleteForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects delete forbidden response has a 3xx status code
func (o *ObjectsDeleteForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects delete forbidden response has a 4xx status code
func (o *ObjectsDeleteForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects delete forbidden response has a 5xx status code
func (o *ObjectsDeleteForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects delete forbidden response a status code equal to that given
func (o *ObjectsDeleteForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects delete forbidden response
func (o *ObjectsDeleteForbidden) Code() int {
	return 403
}

func (o *ObjectsDeleteForbidden) Error() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsDeleteForbidden) String() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsDeleteForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsDeleteForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsDeleteNotFound creates a ObjectsDeleteNotFound with default headers values
func NewObjectsDeleteNotFound() *ObjectsDeleteNotFound {
	return &ObjectsDeleteNotFound{}
}

/*
ObjectsDeleteNotFound describes a response with status code 404, with default header values.

Successful query result but no resource was found.
*/
type ObjectsDeleteNotFound struct {
}

// IsSuccess returns true when this objects delete not found response has a 2xx status code
func (o *ObjectsDeleteNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects delete not found response has a 3xx status code
func (o *ObjectsDeleteNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects delete not found response has a 4xx status code
func (o *ObjectsDeleteNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects delete not found response has a 5xx status code
func (o *ObjectsDeleteNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects delete not found response a status code equal to that given
func (o *ObjectsDeleteNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects delete not found response
func (o *ObjectsDeleteNotFound) Code() int {
	return 404
}

func (o *ObjectsDeleteNotFound) Error() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteNotFound ", 404)
}

func (o *ObjectsDeleteNotFound) String() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteNotFound ", 404)
}

func (o *ObjectsDeleteNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsDeleteInternalServerError creates a ObjectsDeleteInternalServerError with default headers values
func NewObjectsDeleteInternalServerError() *ObjectsDeleteInternalServerError {
	return &ObjectsDeleteInternalServerError{}
}

/*
ObjectsDeleteInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ObjectsDeleteInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects delete internal server error response has a 2xx status code
func (o *ObjectsDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects delete internal server error response has a 3xx status code
func (o *ObjectsDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects delete internal server error response has a 4xx status code
func (o *ObjectsDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects delete internal server error response has a 5xx status code
func (o *ObjectsDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects delete internal server error response a status code equal to that given
func (o *ObjectsDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects delete internal server error response
func (o *ObjectsDeleteInternalServerError) Code() int {
	return 500
}

func (o *ObjectsDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /objects/{id}][%d] objectsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsDeleteInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
