//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewObjectsClassHeadParams creates a new ObjectsClassHeadParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewObjectsClassHeadParams() *ObjectsClassHeadParams {
	return &ObjectsClassHeadParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewObjectsClassHeadParamsWithTimeout creates a new ObjectsClassHeadParams object
// with the ability to set a timeout on a request.
func NewObjectsClassHeadParamsWithTimeout(timeout time.Duration) *ObjectsClassHeadParams {
	return &ObjectsClassHeadParams{
		timeout: timeout,
	}
}

// NewObjectsClassHeadParamsWithContext creates a new ObjectsClassHeadParams object
// with the ability to set a context for a request.
func NewObjectsClassHeadParamsWithContext(ctx context.Context) *ObjectsClassHeadParams {
	return &ObjectsClassHeadParams{
		Context: ctx,
	}
}

// NewObjectsClassHeadParamsWithHTTPClient creates a new ObjectsClassHeadParams object
// with the ability to set a custom HTTPClient for a request.
func NewObjectsClassHeadParamsWithHTTPClient(client *http.Client) *ObjectsClassHeadParams {
	return &ObjectsClassHeadParams{
		HTTPClient: client,
	}
}

/*
ObjectsClassHeadParams contains all the parameters to send to the API endpoint

	for the objects class head operation.

	Typically these are written to a http.Request.
*/
type ObjectsClassHeadParams struct {

	/* ClassName.

	   The class name as defined in the schema
	*/
	ClassName string

	/* ConsistencyLevel.

	   Determines how many replicas must acknowledge a request before it is considered successful
	*/
	ConsistencyLevel *string

	/* ID.

	   The uuid of the data object

	   Format: uuid
	*/
	ID strfmt.UUID

	/* Tenant.

	   Specifies the tenant in a request targeting a multi-tenant class
	*/
	Tenant *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the objects class head params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassHeadParams) WithDefaults() *ObjectsClassHeadParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the objects class head params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassHeadParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the objects class head params
func (o *ObjectsClassHeadParams) WithTimeout(timeout time.Duration) *ObjectsClassHeadParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the objects class head params
func (o *ObjectsClassHeadParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the objects class head params
func (o *ObjectsClassHeadParams) WithContext(ctx context.Context) *ObjectsClassHeadParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the objects class head params
func (o *ObjectsClassHeadParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the objects class head params
func (o *ObjectsClassHeadParams) WithHTTPClient(client *http.Client) *ObjectsClassHeadParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the objects class head params
func (o *ObjectsClassHeadParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClassName adds the className to the objects class head params
func (o *ObjectsClassHeadParams) WithClassName(className string) *ObjectsClassHeadParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the objects class head params
func (o *ObjectsClassHeadParams) SetClassName(className string) {
	o.ClassName = className
}

// WithConsistencyLevel adds the consistencyLevel to the objects class head params
func (o *ObjectsClassHeadParams) WithConsistencyLevel(consistencyLevel *string) *ObjectsClassHeadParams {
	o.SetConsistencyLevel(consistencyLevel)
	return o
}

// SetConsistencyLevel adds the consistencyLevel to the objects class head params
func (o *ObjectsClassHeadParams) SetConsistencyLevel(consistencyLevel *string) {
	o.ConsistencyLevel = consistencyLevel
}

// WithID adds the id to the objects class head params
func (o *ObjectsClassHeadParams) WithID(id strfmt.UUID) *ObjectsClassHeadParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the objects class head params
func (o *ObjectsClassHeadParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WithTenant adds the tenant to the objects class head params
func (o *ObjectsClassHeadParams) WithTenant(tenant *string) *ObjectsClassHeadParams {
	o.SetTenant(tenant)
	return o
}

// SetTenant adds the tenant to the objects class head params
func (o *ObjectsClassHeadParams) SetTenant(tenant *string) {
	o.Tenant = tenant
}

// WriteToRequest writes these params to a swagger request
func (o *ObjectsClassHeadParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.ConsistencyLevel != nil {

		// query param consistency_level
		var qrConsistencyLevel string

		if o.ConsistencyLevel != nil {
			qrConsistencyLevel = *o.ConsistencyLevel
		}
		qConsistencyLevel := qrConsistencyLevel
		if qConsistencyLevel != "" {

			if err := r.SetQueryParam("consistency_level", qConsistencyLevel); err != nil {
				return err
			}
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if o.Tenant != nil {

		// query param tenant
		var qrTenant string

		if o.Tenant != nil {
			qrTenant = *o.Tenant
		}
		qTenant := qrTenant
		if qTenant != "" {

			if err := r.SetQueryParam("tenant", qTenant); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
