//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsClassGetReader is a Reader for the ObjectsClassGet structure.
type ObjectsClassGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsClassGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewObjectsClassGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewObjectsClassGetBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewObjectsClassGetUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsClassGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsClassGetNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsClassGetUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsClassGetInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsClassGetOK creates a ObjectsClassGetOK with default headers values
func NewObjectsClassGetOK() *ObjectsClassGetOK {
	return &ObjectsClassGetOK{}
}

/*
ObjectsClassGetOK describes a response with status code 200, with default header values.

Successful response.
*/
type ObjectsClassGetOK struct {
	Payload *models.Object
}

// IsSuccess returns true when this objects class get o k response has a 2xx status code
func (o *ObjectsClassGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects class get o k response has a 3xx status code
func (o *ObjectsClassGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get o k response has a 4xx status code
func (o *ObjectsClassGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class get o k response has a 5xx status code
func (o *ObjectsClassGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get o k response a status code equal to that given
func (o *ObjectsClassGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the objects class get o k response
func (o *ObjectsClassGetOK) Code() int {
	return 200
}

func (o *ObjectsClassGetOK) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetOK  %+v", 200, o.Payload)
}

func (o *ObjectsClassGetOK) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetOK  %+v", 200, o.Payload)
}

func (o *ObjectsClassGetOK) GetPayload() *models.Object {
	return o.Payload
}

func (o *ObjectsClassGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Object)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassGetBadRequest creates a ObjectsClassGetBadRequest with default headers values
func NewObjectsClassGetBadRequest() *ObjectsClassGetBadRequest {
	return &ObjectsClassGetBadRequest{}
}

/*
ObjectsClassGetBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type ObjectsClassGetBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class get bad request response has a 2xx status code
func (o *ObjectsClassGetBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get bad request response has a 3xx status code
func (o *ObjectsClassGetBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get bad request response has a 4xx status code
func (o *ObjectsClassGetBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class get bad request response has a 5xx status code
func (o *ObjectsClassGetBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get bad request response a status code equal to that given
func (o *ObjectsClassGetBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the objects class get bad request response
func (o *ObjectsClassGetBadRequest) Code() int {
	return 400
}

func (o *ObjectsClassGetBadRequest) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassGetBadRequest) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetBadRequest  %+v", 400, o.Payload)
}

func (o *ObjectsClassGetBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassGetBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassGetUnauthorized creates a ObjectsClassGetUnauthorized with default headers values
func NewObjectsClassGetUnauthorized() *ObjectsClassGetUnauthorized {
	return &ObjectsClassGetUnauthorized{}
}

/*
ObjectsClassGetUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsClassGetUnauthorized struct {
}

// IsSuccess returns true when this objects class get unauthorized response has a 2xx status code
func (o *ObjectsClassGetUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get unauthorized response has a 3xx status code
func (o *ObjectsClassGetUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get unauthorized response has a 4xx status code
func (o *ObjectsClassGetUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class get unauthorized response has a 5xx status code
func (o *ObjectsClassGetUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get unauthorized response a status code equal to that given
func (o *ObjectsClassGetUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects class get unauthorized response
func (o *ObjectsClassGetUnauthorized) Code() int {
	return 401
}

func (o *ObjectsClassGetUnauthorized) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetUnauthorized ", 401)
}

func (o *ObjectsClassGetUnauthorized) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetUnauthorized ", 401)
}

func (o *ObjectsClassGetUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassGetForbidden creates a ObjectsClassGetForbidden with default headers values
func NewObjectsClassGetForbidden() *ObjectsClassGetForbidden {
	return &ObjectsClassGetForbidden{}
}

/*
ObjectsClassGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsClassGetForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class get forbidden response has a 2xx status code
func (o *ObjectsClassGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get forbidden response has a 3xx status code
func (o *ObjectsClassGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get forbidden response has a 4xx status code
func (o *ObjectsClassGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class get forbidden response has a 5xx status code
func (o *ObjectsClassGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get forbidden response a status code equal to that given
func (o *ObjectsClassGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects class get forbidden response
func (o *ObjectsClassGetForbidden) Code() int {
	return 403
}

func (o *ObjectsClassGetForbidden) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassGetForbidden) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsClassGetForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassGetNotFound creates a ObjectsClassGetNotFound with default headers values
func NewObjectsClassGetNotFound() *ObjectsClassGetNotFound {
	return &ObjectsClassGetNotFound{}
}

/*
ObjectsClassGetNotFound describes a response with status code 404, with default header values.

Successful query result but no resource was found.
*/
type ObjectsClassGetNotFound struct {
}

// IsSuccess returns true when this objects class get not found response has a 2xx status code
func (o *ObjectsClassGetNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get not found response has a 3xx status code
func (o *ObjectsClassGetNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get not found response has a 4xx status code
func (o *ObjectsClassGetNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class get not found response has a 5xx status code
func (o *ObjectsClassGetNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get not found response a status code equal to that given
func (o *ObjectsClassGetNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects class get not found response
func (o *ObjectsClassGetNotFound) Code() int {
	return 404
}

func (o *ObjectsClassGetNotFound) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetNotFound ", 404)
}

func (o *ObjectsClassGetNotFound) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetNotFound ", 404)
}

func (o *ObjectsClassGetNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsClassGetUnprocessableEntity creates a ObjectsClassGetUnprocessableEntity with default headers values
func NewObjectsClassGetUnprocessableEntity() *ObjectsClassGetUnprocessableEntity {
	return &ObjectsClassGetUnprocessableEntity{}
}

/*
ObjectsClassGetUnprocessableEntity describes a response with status code 422, with default header values.

Request is well-formed (i.e., syntactically correct), but erroneous.
*/
type ObjectsClassGetUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class get unprocessable entity response has a 2xx status code
func (o *ObjectsClassGetUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get unprocessable entity response has a 3xx status code
func (o *ObjectsClassGetUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get unprocessable entity response has a 4xx status code
func (o *ObjectsClassGetUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects class get unprocessable entity response has a 5xx status code
func (o *ObjectsClassGetUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects class get unprocessable entity response a status code equal to that given
func (o *ObjectsClassGetUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects class get unprocessable entity response
func (o *ObjectsClassGetUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsClassGetUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassGetUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsClassGetUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassGetUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsClassGetInternalServerError creates a ObjectsClassGetInternalServerError with default headers values
func NewObjectsClassGetInternalServerError() *ObjectsClassGetInternalServerError {
	return &ObjectsClassGetInternalServerError{}
}

/*
ObjectsClassGetInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ObjectsClassGetInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects class get internal server error response has a 2xx status code
func (o *ObjectsClassGetInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects class get internal server error response has a 3xx status code
func (o *ObjectsClassGetInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects class get internal server error response has a 4xx status code
func (o *ObjectsClassGetInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects class get internal server error response has a 5xx status code
func (o *ObjectsClassGetInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects class get internal server error response a status code equal to that given
func (o *ObjectsClassGetInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects class get internal server error response
func (o *ObjectsClassGetInternalServerError) Code() int {
	return 500
}

func (o *ObjectsClassGetInternalServerError) Error() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassGetInternalServerError) String() string {
	return fmt.Sprintf("[GET /objects/{className}/{id}][%d] objectsClassGetInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsClassGetInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsClassGetInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
