//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NodesGetClassReader is a Reader for the NodesGetClass structure.
type NodesGetClassReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NodesGetClassReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNodesGetClassOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewNodesGetClassUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewNodesGetClassForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewNodesGetClassNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewNodesGetClassUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNodesGetClassInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNodesGetClassOK creates a NodesGetClassOK with default headers values
func NewNodesGetClassOK() *NodesGetClassOK {
	return &NodesGetClassOK{}
}

/*
NodesGetClassOK describes a response with status code 200, with default header values.

Nodes status successfully returned
*/
type NodesGetClassOK struct {
	Payload *models.NodesStatusResponse
}

// IsSuccess returns true when this nodes get class o k response has a 2xx status code
func (o *NodesGetClassOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this nodes get class o k response has a 3xx status code
func (o *NodesGetClassOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class o k response has a 4xx status code
func (o *NodesGetClassOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this nodes get class o k response has a 5xx status code
func (o *NodesGetClassOK) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get class o k response a status code equal to that given
func (o *NodesGetClassOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the nodes get class o k response
func (o *NodesGetClassOK) Code() int {
	return 200
}

func (o *NodesGetClassOK) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassOK  %+v", 200, o.Payload)
}

func (o *NodesGetClassOK) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassOK  %+v", 200, o.Payload)
}

func (o *NodesGetClassOK) GetPayload() *models.NodesStatusResponse {
	return o.Payload
}

func (o *NodesGetClassOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NodesStatusResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodesGetClassUnauthorized creates a NodesGetClassUnauthorized with default headers values
func NewNodesGetClassUnauthorized() *NodesGetClassUnauthorized {
	return &NodesGetClassUnauthorized{}
}

/*
NodesGetClassUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type NodesGetClassUnauthorized struct {
}

// IsSuccess returns true when this nodes get class unauthorized response has a 2xx status code
func (o *NodesGetClassUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this nodes get class unauthorized response has a 3xx status code
func (o *NodesGetClassUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class unauthorized response has a 4xx status code
func (o *NodesGetClassUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this nodes get class unauthorized response has a 5xx status code
func (o *NodesGetClassUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get class unauthorized response a status code equal to that given
func (o *NodesGetClassUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the nodes get class unauthorized response
func (o *NodesGetClassUnauthorized) Code() int {
	return 401
}

func (o *NodesGetClassUnauthorized) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassUnauthorized ", 401)
}

func (o *NodesGetClassUnauthorized) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassUnauthorized ", 401)
}

func (o *NodesGetClassUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNodesGetClassForbidden creates a NodesGetClassForbidden with default headers values
func NewNodesGetClassForbidden() *NodesGetClassForbidden {
	return &NodesGetClassForbidden{}
}

/*
NodesGetClassForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type NodesGetClassForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nodes get class forbidden response has a 2xx status code
func (o *NodesGetClassForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this nodes get class forbidden response has a 3xx status code
func (o *NodesGetClassForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class forbidden response has a 4xx status code
func (o *NodesGetClassForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this nodes get class forbidden response has a 5xx status code
func (o *NodesGetClassForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get class forbidden response a status code equal to that given
func (o *NodesGetClassForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the nodes get class forbidden response
func (o *NodesGetClassForbidden) Code() int {
	return 403
}

func (o *NodesGetClassForbidden) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassForbidden  %+v", 403, o.Payload)
}

func (o *NodesGetClassForbidden) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassForbidden  %+v", 403, o.Payload)
}

func (o *NodesGetClassForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodesGetClassForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodesGetClassNotFound creates a NodesGetClassNotFound with default headers values
func NewNodesGetClassNotFound() *NodesGetClassNotFound {
	return &NodesGetClassNotFound{}
}

/*
NodesGetClassNotFound describes a response with status code 404, with default header values.

Not Found - Backup does not exist
*/
type NodesGetClassNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nodes get class not found response has a 2xx status code
func (o *NodesGetClassNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this nodes get class not found response has a 3xx status code
func (o *NodesGetClassNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class not found response has a 4xx status code
func (o *NodesGetClassNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this nodes get class not found response has a 5xx status code
func (o *NodesGetClassNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get class not found response a status code equal to that given
func (o *NodesGetClassNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the nodes get class not found response
func (o *NodesGetClassNotFound) Code() int {
	return 404
}

func (o *NodesGetClassNotFound) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassNotFound  %+v", 404, o.Payload)
}

func (o *NodesGetClassNotFound) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassNotFound  %+v", 404, o.Payload)
}

func (o *NodesGetClassNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodesGetClassNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodesGetClassUnprocessableEntity creates a NodesGetClassUnprocessableEntity with default headers values
func NewNodesGetClassUnprocessableEntity() *NodesGetClassUnprocessableEntity {
	return &NodesGetClassUnprocessableEntity{}
}

/*
NodesGetClassUnprocessableEntity describes a response with status code 422, with default header values.

Invalid backup restoration status attempt.
*/
type NodesGetClassUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nodes get class unprocessable entity response has a 2xx status code
func (o *NodesGetClassUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this nodes get class unprocessable entity response has a 3xx status code
func (o *NodesGetClassUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class unprocessable entity response has a 4xx status code
func (o *NodesGetClassUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this nodes get class unprocessable entity response has a 5xx status code
func (o *NodesGetClassUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this nodes get class unprocessable entity response a status code equal to that given
func (o *NodesGetClassUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the nodes get class unprocessable entity response
func (o *NodesGetClassUnprocessableEntity) Code() int {
	return 422
}

func (o *NodesGetClassUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *NodesGetClassUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *NodesGetClassUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodesGetClassUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNodesGetClassInternalServerError creates a NodesGetClassInternalServerError with default headers values
func NewNodesGetClassInternalServerError() *NodesGetClassInternalServerError {
	return &NodesGetClassInternalServerError{}
}

/*
NodesGetClassInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type NodesGetClassInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this nodes get class internal server error response has a 2xx status code
func (o *NodesGetClassInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this nodes get class internal server error response has a 3xx status code
func (o *NodesGetClassInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this nodes get class internal server error response has a 4xx status code
func (o *NodesGetClassInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this nodes get class internal server error response has a 5xx status code
func (o *NodesGetClassInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this nodes get class internal server error response a status code equal to that given
func (o *NodesGetClassInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the nodes get class internal server error response
func (o *NodesGetClassInternalServerError) Code() int {
	return 500
}

func (o *NodesGetClassInternalServerError) Error() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassInternalServerError  %+v", 500, o.Payload)
}

func (o *NodesGetClassInternalServerError) String() string {
	return fmt.Sprintf("[GET /nodes/{className}][%d] nodesGetClassInternalServerError  %+v", 500, o.Payload)
}

func (o *NodesGetClassInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NodesGetClassInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
