//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewNodesGetClassParams creates a new NodesGetClassParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNodesGetClassParams() *NodesGetClassParams {
	return &NodesGetClassParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNodesGetClassParamsWithTimeout creates a new NodesGetClassParams object
// with the ability to set a timeout on a request.
func NewNodesGetClassParamsWithTimeout(timeout time.Duration) *NodesGetClassParams {
	return &NodesGetClassParams{
		timeout: timeout,
	}
}

// NewNodesGetClassParamsWithContext creates a new NodesGetClassParams object
// with the ability to set a context for a request.
func NewNodesGetClassParamsWithContext(ctx context.Context) *NodesGetClassParams {
	return &NodesGetClassParams{
		Context: ctx,
	}
}

// NewNodesGetClassParamsWithHTTPClient creates a new NodesGetClassParams object
// with the ability to set a custom HTTPClient for a request.
func NewNodesGetClassParamsWithHTTPClient(client *http.Client) *NodesGetClassParams {
	return &NodesGetClassParams{
		HTTPClient: client,
	}
}

/*
NodesGetClassParams contains all the parameters to send to the API endpoint

	for the nodes get class operation.

	Typically these are written to a http.Request.
*/
type NodesGetClassParams struct {

	// ClassName.
	ClassName string

	/* Output.

	   Controls the verbosity of the output, possible values are: "minimal", "verbose". Defaults to "minimal".

	   Default: "minimal"
	*/
	Output *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the nodes get class params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetClassParams) WithDefaults() *NodesGetClassParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the nodes get class params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NodesGetClassParams) SetDefaults() {
	var (
		outputDefault = string("minimal")
	)

	val := NodesGetClassParams{
		Output: &outputDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the nodes get class params
func (o *NodesGetClassParams) WithTimeout(timeout time.Duration) *NodesGetClassParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the nodes get class params
func (o *NodesGetClassParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the nodes get class params
func (o *NodesGetClassParams) WithContext(ctx context.Context) *NodesGetClassParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the nodes get class params
func (o *NodesGetClassParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the nodes get class params
func (o *NodesGetClassParams) WithHTTPClient(client *http.Client) *NodesGetClassParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the nodes get class params
func (o *NodesGetClassParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClassName adds the className to the nodes get class params
func (o *NodesGetClassParams) WithClassName(className string) *NodesGetClassParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the nodes get class params
func (o *NodesGetClassParams) SetClassName(className string) {
	o.ClassName = className
}

// WithOutput adds the output to the nodes get class params
func (o *NodesGetClassParams) WithOutput(output *string) *NodesGetClassParams {
	o.SetOutput(output)
	return o
}

// SetOutput adds the output to the nodes get class params
func (o *NodesGetClassParams) SetOutput(output *string) {
	o.Output = output
}

// WriteToRequest writes these params to a swagger request
func (o *NodesGetClassParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.Output != nil {

		// query param output
		var qrOutput string

		if o.Output != nil {
			qrOutput = *o.Output
		}
		qOutput := qrOutput
		if qOutput != "" {

			if err := r.SetQueryParam("output", qOutput); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
