//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ClusterGetStatisticsReader is a Reader for the ClusterGetStatistics structure.
type ClusterGetStatisticsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterGetStatisticsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterGetStatisticsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewClusterGetStatisticsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewClusterGetStatisticsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewClusterGetStatisticsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewClusterGetStatisticsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewClusterGetStatisticsOK creates a ClusterGetStatisticsOK with default headers values
func NewClusterGetStatisticsOK() *ClusterGetStatisticsOK {
	return &ClusterGetStatisticsOK{}
}

/*
ClusterGetStatisticsOK describes a response with status code 200, with default header values.

Cluster statistics successfully returned
*/
type ClusterGetStatisticsOK struct {
	Payload *models.ClusterStatisticsResponse
}

// IsSuccess returns true when this cluster get statistics o k response has a 2xx status code
func (o *ClusterGetStatisticsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster get statistics o k response has a 3xx status code
func (o *ClusterGetStatisticsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster get statistics o k response has a 4xx status code
func (o *ClusterGetStatisticsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster get statistics o k response has a 5xx status code
func (o *ClusterGetStatisticsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster get statistics o k response a status code equal to that given
func (o *ClusterGetStatisticsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster get statistics o k response
func (o *ClusterGetStatisticsOK) Code() int {
	return 200
}

func (o *ClusterGetStatisticsOK) Error() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsOK  %+v", 200, o.Payload)
}

func (o *ClusterGetStatisticsOK) String() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsOK  %+v", 200, o.Payload)
}

func (o *ClusterGetStatisticsOK) GetPayload() *models.ClusterStatisticsResponse {
	return o.Payload
}

func (o *ClusterGetStatisticsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClusterStatisticsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterGetStatisticsUnauthorized creates a ClusterGetStatisticsUnauthorized with default headers values
func NewClusterGetStatisticsUnauthorized() *ClusterGetStatisticsUnauthorized {
	return &ClusterGetStatisticsUnauthorized{}
}

/*
ClusterGetStatisticsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ClusterGetStatisticsUnauthorized struct {
}

// IsSuccess returns true when this cluster get statistics unauthorized response has a 2xx status code
func (o *ClusterGetStatisticsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cluster get statistics unauthorized response has a 3xx status code
func (o *ClusterGetStatisticsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster get statistics unauthorized response has a 4xx status code
func (o *ClusterGetStatisticsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this cluster get statistics unauthorized response has a 5xx status code
func (o *ClusterGetStatisticsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster get statistics unauthorized response a status code equal to that given
func (o *ClusterGetStatisticsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the cluster get statistics unauthorized response
func (o *ClusterGetStatisticsUnauthorized) Code() int {
	return 401
}

func (o *ClusterGetStatisticsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsUnauthorized ", 401)
}

func (o *ClusterGetStatisticsUnauthorized) String() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsUnauthorized ", 401)
}

func (o *ClusterGetStatisticsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewClusterGetStatisticsForbidden creates a ClusterGetStatisticsForbidden with default headers values
func NewClusterGetStatisticsForbidden() *ClusterGetStatisticsForbidden {
	return &ClusterGetStatisticsForbidden{}
}

/*
ClusterGetStatisticsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ClusterGetStatisticsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster get statistics forbidden response has a 2xx status code
func (o *ClusterGetStatisticsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cluster get statistics forbidden response has a 3xx status code
func (o *ClusterGetStatisticsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster get statistics forbidden response has a 4xx status code
func (o *ClusterGetStatisticsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this cluster get statistics forbidden response has a 5xx status code
func (o *ClusterGetStatisticsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster get statistics forbidden response a status code equal to that given
func (o *ClusterGetStatisticsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the cluster get statistics forbidden response
func (o *ClusterGetStatisticsForbidden) Code() int {
	return 403
}

func (o *ClusterGetStatisticsForbidden) Error() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsForbidden  %+v", 403, o.Payload)
}

func (o *ClusterGetStatisticsForbidden) String() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsForbidden  %+v", 403, o.Payload)
}

func (o *ClusterGetStatisticsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterGetStatisticsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterGetStatisticsUnprocessableEntity creates a ClusterGetStatisticsUnprocessableEntity with default headers values
func NewClusterGetStatisticsUnprocessableEntity() *ClusterGetStatisticsUnprocessableEntity {
	return &ClusterGetStatisticsUnprocessableEntity{}
}

/*
ClusterGetStatisticsUnprocessableEntity describes a response with status code 422, with default header values.

Invalid backup restoration status attempt.
*/
type ClusterGetStatisticsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster get statistics unprocessable entity response has a 2xx status code
func (o *ClusterGetStatisticsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cluster get statistics unprocessable entity response has a 3xx status code
func (o *ClusterGetStatisticsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster get statistics unprocessable entity response has a 4xx status code
func (o *ClusterGetStatisticsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this cluster get statistics unprocessable entity response has a 5xx status code
func (o *ClusterGetStatisticsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster get statistics unprocessable entity response a status code equal to that given
func (o *ClusterGetStatisticsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the cluster get statistics unprocessable entity response
func (o *ClusterGetStatisticsUnprocessableEntity) Code() int {
	return 422
}

func (o *ClusterGetStatisticsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ClusterGetStatisticsUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ClusterGetStatisticsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterGetStatisticsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterGetStatisticsInternalServerError creates a ClusterGetStatisticsInternalServerError with default headers values
func NewClusterGetStatisticsInternalServerError() *ClusterGetStatisticsInternalServerError {
	return &ClusterGetStatisticsInternalServerError{}
}

/*
ClusterGetStatisticsInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ClusterGetStatisticsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster get statistics internal server error response has a 2xx status code
func (o *ClusterGetStatisticsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this cluster get statistics internal server error response has a 3xx status code
func (o *ClusterGetStatisticsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster get statistics internal server error response has a 4xx status code
func (o *ClusterGetStatisticsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster get statistics internal server error response has a 5xx status code
func (o *ClusterGetStatisticsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this cluster get statistics internal server error response a status code equal to that given
func (o *ClusterGetStatisticsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the cluster get statistics internal server error response
func (o *ClusterGetStatisticsInternalServerError) Code() int {
	return 500
}

func (o *ClusterGetStatisticsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsInternalServerError  %+v", 500, o.Payload)
}

func (o *ClusterGetStatisticsInternalServerError) String() string {
	return fmt.Sprintf("[GET /cluster/statistics][%d] clusterGetStatisticsInternalServerError  %+v", 500, o.Payload)
}

func (o *ClusterGetStatisticsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterGetStatisticsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
