//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package batch

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewBatchReferencesCreateParams creates a new BatchReferencesCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBatchReferencesCreateParams() *BatchReferencesCreateParams {
	return &BatchReferencesCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBatchReferencesCreateParamsWithTimeout creates a new BatchReferencesCreateParams object
// with the ability to set a timeout on a request.
func NewBatchReferencesCreateParamsWithTimeout(timeout time.Duration) *BatchReferencesCreateParams {
	return &BatchReferencesCreateParams{
		timeout: timeout,
	}
}

// NewBatchReferencesCreateParamsWithContext creates a new BatchReferencesCreateParams object
// with the ability to set a context for a request.
func NewBatchReferencesCreateParamsWithContext(ctx context.Context) *BatchReferencesCreateParams {
	return &BatchReferencesCreateParams{
		Context: ctx,
	}
}

// NewBatchReferencesCreateParamsWithHTTPClient creates a new BatchReferencesCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewBatchReferencesCreateParamsWithHTTPClient(client *http.Client) *BatchReferencesCreateParams {
	return &BatchReferencesCreateParams{
		HTTPClient: client,
	}
}

/*
BatchReferencesCreateParams contains all the parameters to send to the API endpoint

	for the batch references create operation.

	Typically these are written to a http.Request.
*/
type BatchReferencesCreateParams struct {

	/* Body.

	   A list of references to be batched. The ideal size depends on the used database connector. Please see the documentation of the used connector for help
	*/
	Body []*models.BatchReference

	/* ConsistencyLevel.

	   Determines how many replicas must acknowledge a request before it is considered successful
	*/
	ConsistencyLevel *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the batch references create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BatchReferencesCreateParams) WithDefaults() *BatchReferencesCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the batch references create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BatchReferencesCreateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the batch references create params
func (o *BatchReferencesCreateParams) WithTimeout(timeout time.Duration) *BatchReferencesCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the batch references create params
func (o *BatchReferencesCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the batch references create params
func (o *BatchReferencesCreateParams) WithContext(ctx context.Context) *BatchReferencesCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the batch references create params
func (o *BatchReferencesCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the batch references create params
func (o *BatchReferencesCreateParams) WithHTTPClient(client *http.Client) *BatchReferencesCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the batch references create params
func (o *BatchReferencesCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the batch references create params
func (o *BatchReferencesCreateParams) WithBody(body []*models.BatchReference) *BatchReferencesCreateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the batch references create params
func (o *BatchReferencesCreateParams) SetBody(body []*models.BatchReference) {
	o.Body = body
}

// WithConsistencyLevel adds the consistencyLevel to the batch references create params
func (o *BatchReferencesCreateParams) WithConsistencyLevel(consistencyLevel *string) *BatchReferencesCreateParams {
	o.SetConsistencyLevel(consistencyLevel)
	return o
}

// SetConsistencyLevel adds the consistencyLevel to the batch references create params
func (o *BatchReferencesCreateParams) SetConsistencyLevel(consistencyLevel *string) {
	o.ConsistencyLevel = consistencyLevel
}

// WriteToRequest writes these params to a swagger request
func (o *BatchReferencesCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.ConsistencyLevel != nil {

		// query param consistency_level
		var qrConsistencyLevel string

		if o.ConsistencyLevel != nil {
			qrConsistencyLevel = *o.ConsistencyLevel
		}
		qConsistencyLevel := qrConsistencyLevel
		if qConsistencyLevel != "" {

			if err := r.SetQueryParam("consistency_level", qConsistencyLevel); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
