//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// RevokeRoleReader is a Reader for the RevokeRole structure.
type RevokeRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RevokeRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRevokeRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRevokeRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewRevokeRoleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRevokeRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRevokeRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewRevokeRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewRevokeRoleOK creates a RevokeRoleOK with default headers values
func NewRevokeRoleOK() *RevokeRoleOK {
	return &RevokeRoleOK{}
}

/*
RevokeRoleOK describes a response with status code 200, with default header values.

Role revoked successfully
*/
type RevokeRoleOK struct {
}

// IsSuccess returns true when this revoke role o k response has a 2xx status code
func (o *RevokeRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this revoke role o k response has a 3xx status code
func (o *RevokeRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role o k response has a 4xx status code
func (o *RevokeRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role o k response has a 5xx status code
func (o *RevokeRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role o k response a status code equal to that given
func (o *RevokeRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the revoke role o k response
func (o *RevokeRoleOK) Code() int {
	return 200
}

func (o *RevokeRoleOK) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleOK ", 200)
}

func (o *RevokeRoleOK) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleOK ", 200)
}

func (o *RevokeRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleBadRequest creates a RevokeRoleBadRequest with default headers values
func NewRevokeRoleBadRequest() *RevokeRoleBadRequest {
	return &RevokeRoleBadRequest{}
}

/*
RevokeRoleBadRequest describes a response with status code 400, with default header values.

Bad request
*/
type RevokeRoleBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role bad request response has a 2xx status code
func (o *RevokeRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role bad request response has a 3xx status code
func (o *RevokeRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role bad request response has a 4xx status code
func (o *RevokeRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role bad request response has a 5xx status code
func (o *RevokeRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role bad request response a status code equal to that given
func (o *RevokeRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the revoke role bad request response
func (o *RevokeRoleBadRequest) Code() int {
	return 400
}

func (o *RevokeRoleBadRequest) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleBadRequest) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleBadRequest  %+v", 400, o.Payload)
}

func (o *RevokeRoleBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleUnauthorized creates a RevokeRoleUnauthorized with default headers values
func NewRevokeRoleUnauthorized() *RevokeRoleUnauthorized {
	return &RevokeRoleUnauthorized{}
}

/*
RevokeRoleUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type RevokeRoleUnauthorized struct {
}

// IsSuccess returns true when this revoke role unauthorized response has a 2xx status code
func (o *RevokeRoleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role unauthorized response has a 3xx status code
func (o *RevokeRoleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role unauthorized response has a 4xx status code
func (o *RevokeRoleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role unauthorized response has a 5xx status code
func (o *RevokeRoleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role unauthorized response a status code equal to that given
func (o *RevokeRoleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the revoke role unauthorized response
func (o *RevokeRoleUnauthorized) Code() int {
	return 401
}

func (o *RevokeRoleUnauthorized) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleUnauthorized ", 401)
}

func (o *RevokeRoleUnauthorized) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleUnauthorized ", 401)
}

func (o *RevokeRoleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleForbidden creates a RevokeRoleForbidden with default headers values
func NewRevokeRoleForbidden() *RevokeRoleForbidden {
	return &RevokeRoleForbidden{}
}

/*
RevokeRoleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RevokeRoleForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role forbidden response has a 2xx status code
func (o *RevokeRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role forbidden response has a 3xx status code
func (o *RevokeRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role forbidden response has a 4xx status code
func (o *RevokeRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role forbidden response has a 5xx status code
func (o *RevokeRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role forbidden response a status code equal to that given
func (o *RevokeRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the revoke role forbidden response
func (o *RevokeRoleForbidden) Code() int {
	return 403
}

func (o *RevokeRoleForbidden) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleForbidden) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleForbidden  %+v", 403, o.Payload)
}

func (o *RevokeRoleForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeRoleNotFound creates a RevokeRoleNotFound with default headers values
func NewRevokeRoleNotFound() *RevokeRoleNotFound {
	return &RevokeRoleNotFound{}
}

/*
RevokeRoleNotFound describes a response with status code 404, with default header values.

role or user is not found.
*/
type RevokeRoleNotFound struct {
}

// IsSuccess returns true when this revoke role not found response has a 2xx status code
func (o *RevokeRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role not found response has a 3xx status code
func (o *RevokeRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role not found response has a 4xx status code
func (o *RevokeRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this revoke role not found response has a 5xx status code
func (o *RevokeRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke role not found response a status code equal to that given
func (o *RevokeRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the revoke role not found response
func (o *RevokeRoleNotFound) Code() int {
	return 404
}

func (o *RevokeRoleNotFound) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleNotFound ", 404)
}

func (o *RevokeRoleNotFound) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleNotFound ", 404)
}

func (o *RevokeRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRevokeRoleInternalServerError creates a RevokeRoleInternalServerError with default headers values
func NewRevokeRoleInternalServerError() *RevokeRoleInternalServerError {
	return &RevokeRoleInternalServerError{}
}

/*
RevokeRoleInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type RevokeRoleInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this revoke role internal server error response has a 2xx status code
func (o *RevokeRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this revoke role internal server error response has a 3xx status code
func (o *RevokeRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke role internal server error response has a 4xx status code
func (o *RevokeRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke role internal server error response has a 5xx status code
func (o *RevokeRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this revoke role internal server error response a status code equal to that given
func (o *RevokeRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the revoke role internal server error response
func (o *RevokeRoleInternalServerError) Code() int {
	return 500
}

func (o *RevokeRoleInternalServerError) Error() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleInternalServerError) String() string {
	return fmt.Sprintf("[POST /authz/users/{id}/revoke][%d] revokeRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *RevokeRoleInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RevokeRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RevokeRoleBody revoke role body
swagger:model RevokeRoleBody
*/
type RevokeRoleBody struct {

	// the roles that revoked from the key or user
	Roles []string `json:"roles"`
}

// Validate validates this revoke role body
func (o *RevokeRoleBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this revoke role body based on context it is used
func (o *RevokeRoleBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *RevokeRoleBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RevokeRoleBody) UnmarshalBinary(b []byte) error {
	var res RevokeRoleBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
