//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRevokeRoleParams creates a new RevokeRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRevokeRoleParams() *RevokeRoleParams {
	return &RevokeRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRevokeRoleParamsWithTimeout creates a new RevokeRoleParams object
// with the ability to set a timeout on a request.
func NewRevokeRoleParamsWithTimeout(timeout time.Duration) *RevokeRoleParams {
	return &RevokeRoleParams{
		timeout: timeout,
	}
}

// NewRevokeRoleParamsWithContext creates a new RevokeRoleParams object
// with the ability to set a context for a request.
func NewRevokeRoleParamsWithContext(ctx context.Context) *RevokeRoleParams {
	return &RevokeRoleParams{
		Context: ctx,
	}
}

// NewRevokeRoleParamsWithHTTPClient creates a new RevokeRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewRevokeRoleParamsWithHTTPClient(client *http.Client) *RevokeRoleParams {
	return &RevokeRoleParams{
		HTTPClient: client,
	}
}

/*
RevokeRoleParams contains all the parameters to send to the API endpoint

	for the revoke role operation.

	Typically these are written to a http.Request.
*/
type RevokeRoleParams struct {

	// Body.
	Body RevokeRoleBody

	/* ID.

	   user name
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the revoke role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleParams) WithDefaults() *RevokeRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the revoke role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the revoke role params
func (o *RevokeRoleParams) WithTimeout(timeout time.Duration) *RevokeRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the revoke role params
func (o *RevokeRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the revoke role params
func (o *RevokeRoleParams) WithContext(ctx context.Context) *RevokeRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the revoke role params
func (o *RevokeRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the revoke role params
func (o *RevokeRoleParams) WithHTTPClient(client *http.Client) *RevokeRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the revoke role params
func (o *RevokeRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the revoke role params
func (o *RevokeRoleParams) WithBody(body RevokeRoleBody) *RevokeRoleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the revoke role params
func (o *RevokeRoleParams) SetBody(body RevokeRoleBody) {
	o.Body = body
}

// WithID adds the id to the revoke role params
func (o *RevokeRoleParams) WithID(id string) *RevokeRoleParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the revoke role params
func (o *RevokeRoleParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *RevokeRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
