//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetRolesForOwnUserReader is a Reader for the GetRolesForOwnUser structure.
type GetRolesForOwnUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRolesForOwnUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRolesForOwnUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetRolesForOwnUserUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetRolesForOwnUserInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetRolesForOwnUserOK creates a GetRolesForOwnUserOK with default headers values
func NewGetRolesForOwnUserOK() *GetRolesForOwnUserOK {
	return &GetRolesForOwnUserOK{}
}

/*
GetRolesForOwnUserOK describes a response with status code 200, with default header values.

Role assigned to own users
*/
type GetRolesForOwnUserOK struct {
	Payload models.RolesListResponse
}

// IsSuccess returns true when this get roles for own user o k response has a 2xx status code
func (o *GetRolesForOwnUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get roles for own user o k response has a 3xx status code
func (o *GetRolesForOwnUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for own user o k response has a 4xx status code
func (o *GetRolesForOwnUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get roles for own user o k response has a 5xx status code
func (o *GetRolesForOwnUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for own user o k response a status code equal to that given
func (o *GetRolesForOwnUserOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get roles for own user o k response
func (o *GetRolesForOwnUserOK) Code() int {
	return 200
}

func (o *GetRolesForOwnUserOK) Error() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserOK  %+v", 200, o.Payload)
}

func (o *GetRolesForOwnUserOK) String() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserOK  %+v", 200, o.Payload)
}

func (o *GetRolesForOwnUserOK) GetPayload() models.RolesListResponse {
	return o.Payload
}

func (o *GetRolesForOwnUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRolesForOwnUserUnauthorized creates a GetRolesForOwnUserUnauthorized with default headers values
func NewGetRolesForOwnUserUnauthorized() *GetRolesForOwnUserUnauthorized {
	return &GetRolesForOwnUserUnauthorized{}
}

/*
GetRolesForOwnUserUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetRolesForOwnUserUnauthorized struct {
}

// IsSuccess returns true when this get roles for own user unauthorized response has a 2xx status code
func (o *GetRolesForOwnUserUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for own user unauthorized response has a 3xx status code
func (o *GetRolesForOwnUserUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for own user unauthorized response has a 4xx status code
func (o *GetRolesForOwnUserUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get roles for own user unauthorized response has a 5xx status code
func (o *GetRolesForOwnUserUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get roles for own user unauthorized response a status code equal to that given
func (o *GetRolesForOwnUserUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get roles for own user unauthorized response
func (o *GetRolesForOwnUserUnauthorized) Code() int {
	return 401
}

func (o *GetRolesForOwnUserUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserUnauthorized ", 401)
}

func (o *GetRolesForOwnUserUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserUnauthorized ", 401)
}

func (o *GetRolesForOwnUserUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetRolesForOwnUserInternalServerError creates a GetRolesForOwnUserInternalServerError with default headers values
func NewGetRolesForOwnUserInternalServerError() *GetRolesForOwnUserInternalServerError {
	return &GetRolesForOwnUserInternalServerError{}
}

/*
GetRolesForOwnUserInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetRolesForOwnUserInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get roles for own user internal server error response has a 2xx status code
func (o *GetRolesForOwnUserInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get roles for own user internal server error response has a 3xx status code
func (o *GetRolesForOwnUserInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get roles for own user internal server error response has a 4xx status code
func (o *GetRolesForOwnUserInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get roles for own user internal server error response has a 5xx status code
func (o *GetRolesForOwnUserInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get roles for own user internal server error response a status code equal to that given
func (o *GetRolesForOwnUserInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get roles for own user internal server error response
func (o *GetRolesForOwnUserInternalServerError) Code() int {
	return 500
}

func (o *GetRolesForOwnUserInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRolesForOwnUserInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/users/own-roles][%d] getRolesForOwnUserInternalServerError  %+v", 500, o.Payload)
}

func (o *GetRolesForOwnUserInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetRolesForOwnUserInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
