//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/weaviate/weaviate/entities/models"
)

// AddPermissionsReader is a Reader for the AddPermissions structure.
type AddPermissionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddPermissionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddPermissionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAddPermissionsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewAddPermissionsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAddPermissionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAddPermissionsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAddPermissionsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAddPermissionsOK creates a AddPermissionsOK with default headers values
func NewAddPermissionsOK() *AddPermissionsOK {
	return &AddPermissionsOK{}
}

/*
AddPermissionsOK describes a response with status code 200, with default header values.

Permissions added successfully
*/
type AddPermissionsOK struct {
}

// IsSuccess returns true when this add permissions o k response has a 2xx status code
func (o *AddPermissionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add permissions o k response has a 3xx status code
func (o *AddPermissionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions o k response has a 4xx status code
func (o *AddPermissionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add permissions o k response has a 5xx status code
func (o *AddPermissionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add permissions o k response a status code equal to that given
func (o *AddPermissionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add permissions o k response
func (o *AddPermissionsOK) Code() int {
	return 200
}

func (o *AddPermissionsOK) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsOK ", 200)
}

func (o *AddPermissionsOK) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsOK ", 200)
}

func (o *AddPermissionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAddPermissionsBadRequest creates a AddPermissionsBadRequest with default headers values
func NewAddPermissionsBadRequest() *AddPermissionsBadRequest {
	return &AddPermissionsBadRequest{}
}

/*
AddPermissionsBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type AddPermissionsBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this add permissions bad request response has a 2xx status code
func (o *AddPermissionsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permissions bad request response has a 3xx status code
func (o *AddPermissionsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions bad request response has a 4xx status code
func (o *AddPermissionsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permissions bad request response has a 5xx status code
func (o *AddPermissionsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this add permissions bad request response a status code equal to that given
func (o *AddPermissionsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the add permissions bad request response
func (o *AddPermissionsBadRequest) Code() int {
	return 400
}

func (o *AddPermissionsBadRequest) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsBadRequest  %+v", 400, o.Payload)
}

func (o *AddPermissionsBadRequest) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsBadRequest  %+v", 400, o.Payload)
}

func (o *AddPermissionsBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AddPermissionsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionsUnauthorized creates a AddPermissionsUnauthorized with default headers values
func NewAddPermissionsUnauthorized() *AddPermissionsUnauthorized {
	return &AddPermissionsUnauthorized{}
}

/*
AddPermissionsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AddPermissionsUnauthorized struct {
}

// IsSuccess returns true when this add permissions unauthorized response has a 2xx status code
func (o *AddPermissionsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permissions unauthorized response has a 3xx status code
func (o *AddPermissionsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions unauthorized response has a 4xx status code
func (o *AddPermissionsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permissions unauthorized response has a 5xx status code
func (o *AddPermissionsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this add permissions unauthorized response a status code equal to that given
func (o *AddPermissionsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the add permissions unauthorized response
func (o *AddPermissionsUnauthorized) Code() int {
	return 401
}

func (o *AddPermissionsUnauthorized) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsUnauthorized ", 401)
}

func (o *AddPermissionsUnauthorized) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsUnauthorized ", 401)
}

func (o *AddPermissionsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAddPermissionsForbidden creates a AddPermissionsForbidden with default headers values
func NewAddPermissionsForbidden() *AddPermissionsForbidden {
	return &AddPermissionsForbidden{}
}

/*
AddPermissionsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AddPermissionsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this add permissions forbidden response has a 2xx status code
func (o *AddPermissionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permissions forbidden response has a 3xx status code
func (o *AddPermissionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions forbidden response has a 4xx status code
func (o *AddPermissionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permissions forbidden response has a 5xx status code
func (o *AddPermissionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this add permissions forbidden response a status code equal to that given
func (o *AddPermissionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the add permissions forbidden response
func (o *AddPermissionsForbidden) Code() int {
	return 403
}

func (o *AddPermissionsForbidden) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsForbidden  %+v", 403, o.Payload)
}

func (o *AddPermissionsForbidden) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsForbidden  %+v", 403, o.Payload)
}

func (o *AddPermissionsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AddPermissionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionsUnprocessableEntity creates a AddPermissionsUnprocessableEntity with default headers values
func NewAddPermissionsUnprocessableEntity() *AddPermissionsUnprocessableEntity {
	return &AddPermissionsUnprocessableEntity{}
}

/*
AddPermissionsUnprocessableEntity describes a response with status code 422, with default header values.

Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?
*/
type AddPermissionsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this add permissions unprocessable entity response has a 2xx status code
func (o *AddPermissionsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permissions unprocessable entity response has a 3xx status code
func (o *AddPermissionsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions unprocessable entity response has a 4xx status code
func (o *AddPermissionsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this add permissions unprocessable entity response has a 5xx status code
func (o *AddPermissionsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this add permissions unprocessable entity response a status code equal to that given
func (o *AddPermissionsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the add permissions unprocessable entity response
func (o *AddPermissionsUnprocessableEntity) Code() int {
	return 422
}

func (o *AddPermissionsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AddPermissionsUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AddPermissionsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AddPermissionsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddPermissionsInternalServerError creates a AddPermissionsInternalServerError with default headers values
func NewAddPermissionsInternalServerError() *AddPermissionsInternalServerError {
	return &AddPermissionsInternalServerError{}
}

/*
AddPermissionsInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AddPermissionsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this add permissions internal server error response has a 2xx status code
func (o *AddPermissionsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add permissions internal server error response has a 3xx status code
func (o *AddPermissionsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add permissions internal server error response has a 4xx status code
func (o *AddPermissionsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this add permissions internal server error response has a 5xx status code
func (o *AddPermissionsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this add permissions internal server error response a status code equal to that given
func (o *AddPermissionsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the add permissions internal server error response
func (o *AddPermissionsInternalServerError) Code() int {
	return 500
}

func (o *AddPermissionsInternalServerError) Error() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsInternalServerError  %+v", 500, o.Payload)
}

func (o *AddPermissionsInternalServerError) String() string {
	return fmt.Sprintf("[POST /authz/roles/add-permissions][%d] addPermissionsInternalServerError  %+v", 500, o.Payload)
}

func (o *AddPermissionsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AddPermissionsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AddPermissionsBody add permissions body
swagger:model AddPermissionsBody
*/
type AddPermissionsBody struct {

	// role name
	// Required: true
	Name *string `json:"name"`

	// permissions to be added to the role
	// Required: true
	Permissions []*models.Permission `json:"permissions"`
}

// Validate validates this add permissions body
func (o *AddPermissionsBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePermissions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AddPermissionsBody) validateName(formats strfmt.Registry) error {

	if err := validate.Required("body"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *AddPermissionsBody) validatePermissions(formats strfmt.Registry) error {

	if err := validate.Required("body"+"."+"permissions", "body", o.Permissions); err != nil {
		return err
	}

	for i := 0; i < len(o.Permissions); i++ {
		if swag.IsZero(o.Permissions[i]) { // not required
			continue
		}

		if o.Permissions[i] != nil {
			if err := o.Permissions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "permissions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this add permissions body based on the context it is used
func (o *AddPermissionsBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AddPermissionsBody) contextValidatePermissions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Permissions); i++ {

		if o.Permissions[i] != nil {
			if err := o.Permissions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("body" + "." + "permissions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("body" + "." + "permissions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AddPermissionsBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AddPermissionsBody) UnmarshalBinary(b []byte) error {
	var res AddPermissionsBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
