//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAddPermissionsParams creates a new AddPermissionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddPermissionsParams() *AddPermissionsParams {
	return &AddPermissionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddPermissionsParamsWithTimeout creates a new AddPermissionsParams object
// with the ability to set a timeout on a request.
func NewAddPermissionsParamsWithTimeout(timeout time.Duration) *AddPermissionsParams {
	return &AddPermissionsParams{
		timeout: timeout,
	}
}

// NewAddPermissionsParamsWithContext creates a new AddPermissionsParams object
// with the ability to set a context for a request.
func NewAddPermissionsParamsWithContext(ctx context.Context) *AddPermissionsParams {
	return &AddPermissionsParams{
		Context: ctx,
	}
}

// NewAddPermissionsParamsWithHTTPClient creates a new AddPermissionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddPermissionsParamsWithHTTPClient(client *http.Client) *AddPermissionsParams {
	return &AddPermissionsParams{
		HTTPClient: client,
	}
}

/*
AddPermissionsParams contains all the parameters to send to the API endpoint

	for the add permissions operation.

	Typically these are written to a http.Request.
*/
type AddPermissionsParams struct {

	// Body.
	Body AddPermissionsBody

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPermissionsParams) WithDefaults() *AddPermissionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add permissions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddPermissionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add permissions params
func (o *AddPermissionsParams) WithTimeout(timeout time.Duration) *AddPermissionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add permissions params
func (o *AddPermissionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add permissions params
func (o *AddPermissionsParams) WithContext(ctx context.Context) *AddPermissionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add permissions params
func (o *AddPermissionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add permissions params
func (o *AddPermissionsParams) WithHTTPClient(client *http.Client) *AddPermissionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add permissions params
func (o *AddPermissionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the add permissions params
func (o *AddPermissionsParams) WithBody(body AddPermissionsBody) *AddPermissionsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the add permissions params
func (o *AddPermissionsParams) SetBody(body AddPermissionsBody) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *AddPermissionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
