//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsGetOKCode is the HTTP code returned for type TenantsGetOK
const TenantsGetOKCode int = 200

/*
TenantsGetOK tenants from specified class.

swagger:response tenantsGetOK
*/
type TenantsGetOK struct {

	/*
	  In: Body
	*/
	Payload []*models.Tenant `json:"body,omitempty"`
}

// NewTenantsGetOK creates TenantsGetOK with default headers values
func NewTenantsGetOK() *TenantsGetOK {

	return &TenantsGetOK{}
}

// WithPayload adds the payload to the tenants get o k response
func (o *TenantsGetOK) WithPayload(payload []*models.Tenant) *TenantsGetOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get o k response
func (o *TenantsGetOK) SetPayload(payload []*models.Tenant) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = make([]*models.Tenant, 0, 50)
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// TenantsGetUnauthorizedCode is the HTTP code returned for type TenantsGetUnauthorized
const TenantsGetUnauthorizedCode int = 401

/*
TenantsGetUnauthorized Unauthorized or invalid credentials.

swagger:response tenantsGetUnauthorized
*/
type TenantsGetUnauthorized struct {
}

// NewTenantsGetUnauthorized creates TenantsGetUnauthorized with default headers values
func NewTenantsGetUnauthorized() *TenantsGetUnauthorized {

	return &TenantsGetUnauthorized{}
}

// WriteResponse to the client
func (o *TenantsGetUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// TenantsGetForbiddenCode is the HTTP code returned for type TenantsGetForbidden
const TenantsGetForbiddenCode int = 403

/*
TenantsGetForbidden Forbidden

swagger:response tenantsGetForbidden
*/
type TenantsGetForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetForbidden creates TenantsGetForbidden with default headers values
func NewTenantsGetForbidden() *TenantsGetForbidden {

	return &TenantsGetForbidden{}
}

// WithPayload adds the payload to the tenants get forbidden response
func (o *TenantsGetForbidden) WithPayload(payload *models.ErrorResponse) *TenantsGetForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get forbidden response
func (o *TenantsGetForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsGetUnprocessableEntityCode is the HTTP code returned for type TenantsGetUnprocessableEntity
const TenantsGetUnprocessableEntityCode int = 422

/*
TenantsGetUnprocessableEntity Invalid Tenant class

swagger:response tenantsGetUnprocessableEntity
*/
type TenantsGetUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetUnprocessableEntity creates TenantsGetUnprocessableEntity with default headers values
func NewTenantsGetUnprocessableEntity() *TenantsGetUnprocessableEntity {

	return &TenantsGetUnprocessableEntity{}
}

// WithPayload adds the payload to the tenants get unprocessable entity response
func (o *TenantsGetUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *TenantsGetUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get unprocessable entity response
func (o *TenantsGetUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsGetInternalServerErrorCode is the HTTP code returned for type TenantsGetInternalServerError
const TenantsGetInternalServerErrorCode int = 500

/*
TenantsGetInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response tenantsGetInternalServerError
*/
type TenantsGetInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetInternalServerError creates TenantsGetInternalServerError with default headers values
func NewTenantsGetInternalServerError() *TenantsGetInternalServerError {

	return &TenantsGetInternalServerError{}
}

// WithPayload adds the payload to the tenants get internal server error response
func (o *TenantsGetInternalServerError) WithPayload(payload *models.ErrorResponse) *TenantsGetInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get internal server error response
func (o *TenantsGetInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
