//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsGetOneOKCode is the HTTP code returned for type TenantsGetOneOK
const TenantsGetOneOKCode int = 200

/*
TenantsGetOneOK load the tenant given the specified class

swagger:response tenantsGetOneOK
*/
type TenantsGetOneOK struct {

	/*
	  In: Body
	*/
	Payload *models.TenantResponse `json:"body,omitempty"`
}

// NewTenantsGetOneOK creates TenantsGetOneOK with default headers values
func NewTenantsGetOneOK() *TenantsGetOneOK {

	return &TenantsGetOneOK{}
}

// WithPayload adds the payload to the tenants get one o k response
func (o *TenantsGetOneOK) WithPayload(payload *models.TenantResponse) *TenantsGetOneOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get one o k response
func (o *TenantsGetOneOK) SetPayload(payload *models.TenantResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetOneOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsGetOneUnauthorizedCode is the HTTP code returned for type TenantsGetOneUnauthorized
const TenantsGetOneUnauthorizedCode int = 401

/*
TenantsGetOneUnauthorized Unauthorized or invalid credentials.

swagger:response tenantsGetOneUnauthorized
*/
type TenantsGetOneUnauthorized struct {
}

// NewTenantsGetOneUnauthorized creates TenantsGetOneUnauthorized with default headers values
func NewTenantsGetOneUnauthorized() *TenantsGetOneUnauthorized {

	return &TenantsGetOneUnauthorized{}
}

// WriteResponse to the client
func (o *TenantsGetOneUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// TenantsGetOneForbiddenCode is the HTTP code returned for type TenantsGetOneForbidden
const TenantsGetOneForbiddenCode int = 403

/*
TenantsGetOneForbidden Forbidden

swagger:response tenantsGetOneForbidden
*/
type TenantsGetOneForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetOneForbidden creates TenantsGetOneForbidden with default headers values
func NewTenantsGetOneForbidden() *TenantsGetOneForbidden {

	return &TenantsGetOneForbidden{}
}

// WithPayload adds the payload to the tenants get one forbidden response
func (o *TenantsGetOneForbidden) WithPayload(payload *models.ErrorResponse) *TenantsGetOneForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get one forbidden response
func (o *TenantsGetOneForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetOneForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsGetOneNotFoundCode is the HTTP code returned for type TenantsGetOneNotFound
const TenantsGetOneNotFoundCode int = 404

/*
TenantsGetOneNotFound Tenant not found

swagger:response tenantsGetOneNotFound
*/
type TenantsGetOneNotFound struct {
}

// NewTenantsGetOneNotFound creates TenantsGetOneNotFound with default headers values
func NewTenantsGetOneNotFound() *TenantsGetOneNotFound {

	return &TenantsGetOneNotFound{}
}

// WriteResponse to the client
func (o *TenantsGetOneNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// TenantsGetOneUnprocessableEntityCode is the HTTP code returned for type TenantsGetOneUnprocessableEntity
const TenantsGetOneUnprocessableEntityCode int = 422

/*
TenantsGetOneUnprocessableEntity Invalid tenant or class

swagger:response tenantsGetOneUnprocessableEntity
*/
type TenantsGetOneUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetOneUnprocessableEntity creates TenantsGetOneUnprocessableEntity with default headers values
func NewTenantsGetOneUnprocessableEntity() *TenantsGetOneUnprocessableEntity {

	return &TenantsGetOneUnprocessableEntity{}
}

// WithPayload adds the payload to the tenants get one unprocessable entity response
func (o *TenantsGetOneUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *TenantsGetOneUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get one unprocessable entity response
func (o *TenantsGetOneUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetOneUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsGetOneInternalServerErrorCode is the HTTP code returned for type TenantsGetOneInternalServerError
const TenantsGetOneInternalServerErrorCode int = 500

/*
TenantsGetOneInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response tenantsGetOneInternalServerError
*/
type TenantsGetOneInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsGetOneInternalServerError creates TenantsGetOneInternalServerError with default headers values
func NewTenantsGetOneInternalServerError() *TenantsGetOneInternalServerError {

	return &TenantsGetOneInternalServerError{}
}

// WithPayload adds the payload to the tenants get one internal server error response
func (o *TenantsGetOneInternalServerError) WithPayload(payload *models.ErrorResponse) *TenantsGetOneInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants get one internal server error response
func (o *TenantsGetOneInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsGetOneInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
