//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsDeleteOKCode is the HTTP code returned for type TenantsDeleteOK
const TenantsDeleteOKCode int = 200

/*
TenantsDeleteOK Deleted tenants from specified class.

swagger:response tenantsDeleteOK
*/
type TenantsDeleteOK struct {
}

// NewTenantsDeleteOK creates TenantsDeleteOK with default headers values
func NewTenantsDeleteOK() *TenantsDeleteOK {

	return &TenantsDeleteOK{}
}

// WriteResponse to the client
func (o *TenantsDeleteOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// TenantsDeleteUnauthorizedCode is the HTTP code returned for type TenantsDeleteUnauthorized
const TenantsDeleteUnauthorizedCode int = 401

/*
TenantsDeleteUnauthorized Unauthorized or invalid credentials.

swagger:response tenantsDeleteUnauthorized
*/
type TenantsDeleteUnauthorized struct {
}

// NewTenantsDeleteUnauthorized creates TenantsDeleteUnauthorized with default headers values
func NewTenantsDeleteUnauthorized() *TenantsDeleteUnauthorized {

	return &TenantsDeleteUnauthorized{}
}

// WriteResponse to the client
func (o *TenantsDeleteUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// TenantsDeleteForbiddenCode is the HTTP code returned for type TenantsDeleteForbidden
const TenantsDeleteForbiddenCode int = 403

/*
TenantsDeleteForbidden Forbidden

swagger:response tenantsDeleteForbidden
*/
type TenantsDeleteForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsDeleteForbidden creates TenantsDeleteForbidden with default headers values
func NewTenantsDeleteForbidden() *TenantsDeleteForbidden {

	return &TenantsDeleteForbidden{}
}

// WithPayload adds the payload to the tenants delete forbidden response
func (o *TenantsDeleteForbidden) WithPayload(payload *models.ErrorResponse) *TenantsDeleteForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants delete forbidden response
func (o *TenantsDeleteForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsDeleteForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsDeleteUnprocessableEntityCode is the HTTP code returned for type TenantsDeleteUnprocessableEntity
const TenantsDeleteUnprocessableEntityCode int = 422

/*
TenantsDeleteUnprocessableEntity Invalid Tenant class

swagger:response tenantsDeleteUnprocessableEntity
*/
type TenantsDeleteUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsDeleteUnprocessableEntity creates TenantsDeleteUnprocessableEntity with default headers values
func NewTenantsDeleteUnprocessableEntity() *TenantsDeleteUnprocessableEntity {

	return &TenantsDeleteUnprocessableEntity{}
}

// WithPayload adds the payload to the tenants delete unprocessable entity response
func (o *TenantsDeleteUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *TenantsDeleteUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants delete unprocessable entity response
func (o *TenantsDeleteUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsDeleteUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// TenantsDeleteInternalServerErrorCode is the HTTP code returned for type TenantsDeleteInternalServerError
const TenantsDeleteInternalServerErrorCode int = 500

/*
TenantsDeleteInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response tenantsDeleteInternalServerError
*/
type TenantsDeleteInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewTenantsDeleteInternalServerError creates TenantsDeleteInternalServerError with default headers values
func NewTenantsDeleteInternalServerError() *TenantsDeleteInternalServerError {

	return &TenantsDeleteInternalServerError{}
}

// WithPayload adds the payload to the tenants delete internal server error response
func (o *TenantsDeleteInternalServerError) WithPayload(payload *models.ErrorResponse) *TenantsDeleteInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the tenants delete internal server error response
func (o *TenantsDeleteInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *TenantsDeleteInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
