//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// SchemaObjectsGetOKCode is the HTTP code returned for type SchemaObjectsGetOK
const SchemaObjectsGetOKCode int = 200

/*
SchemaObjectsGetOK Found the Class, returned as body

swagger:response schemaObjectsGetOK
*/
type SchemaObjectsGetOK struct {

	/*
	  In: Body
	*/
	Payload *models.Class `json:"body,omitempty"`
}

// NewSchemaObjectsGetOK creates SchemaObjectsGetOK with default headers values
func NewSchemaObjectsGetOK() *SchemaObjectsGetOK {

	return &SchemaObjectsGetOK{}
}

// WithPayload adds the payload to the schema objects get o k response
func (o *SchemaObjectsGetOK) WithPayload(payload *models.Class) *SchemaObjectsGetOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects get o k response
func (o *SchemaObjectsGetOK) SetPayload(payload *models.Class) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsGetOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// SchemaObjectsGetUnauthorizedCode is the HTTP code returned for type SchemaObjectsGetUnauthorized
const SchemaObjectsGetUnauthorizedCode int = 401

/*
SchemaObjectsGetUnauthorized Unauthorized or invalid credentials.

swagger:response schemaObjectsGetUnauthorized
*/
type SchemaObjectsGetUnauthorized struct {
}

// NewSchemaObjectsGetUnauthorized creates SchemaObjectsGetUnauthorized with default headers values
func NewSchemaObjectsGetUnauthorized() *SchemaObjectsGetUnauthorized {

	return &SchemaObjectsGetUnauthorized{}
}

// WriteResponse to the client
func (o *SchemaObjectsGetUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// SchemaObjectsGetForbiddenCode is the HTTP code returned for type SchemaObjectsGetForbidden
const SchemaObjectsGetForbiddenCode int = 403

/*
SchemaObjectsGetForbidden Forbidden

swagger:response schemaObjectsGetForbidden
*/
type SchemaObjectsGetForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewSchemaObjectsGetForbidden creates SchemaObjectsGetForbidden with default headers values
func NewSchemaObjectsGetForbidden() *SchemaObjectsGetForbidden {

	return &SchemaObjectsGetForbidden{}
}

// WithPayload adds the payload to the schema objects get forbidden response
func (o *SchemaObjectsGetForbidden) WithPayload(payload *models.ErrorResponse) *SchemaObjectsGetForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects get forbidden response
func (o *SchemaObjectsGetForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsGetForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// SchemaObjectsGetNotFoundCode is the HTTP code returned for type SchemaObjectsGetNotFound
const SchemaObjectsGetNotFoundCode int = 404

/*
SchemaObjectsGetNotFound This class does not exist

swagger:response schemaObjectsGetNotFound
*/
type SchemaObjectsGetNotFound struct {
}

// NewSchemaObjectsGetNotFound creates SchemaObjectsGetNotFound with default headers values
func NewSchemaObjectsGetNotFound() *SchemaObjectsGetNotFound {

	return &SchemaObjectsGetNotFound{}
}

// WriteResponse to the client
func (o *SchemaObjectsGetNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// SchemaObjectsGetInternalServerErrorCode is the HTTP code returned for type SchemaObjectsGetInternalServerError
const SchemaObjectsGetInternalServerErrorCode int = 500

/*
SchemaObjectsGetInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response schemaObjectsGetInternalServerError
*/
type SchemaObjectsGetInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewSchemaObjectsGetInternalServerError creates SchemaObjectsGetInternalServerError with default headers values
func NewSchemaObjectsGetInternalServerError() *SchemaObjectsGetInternalServerError {

	return &SchemaObjectsGetInternalServerError{}
}

// WithPayload adds the payload to the schema objects get internal server error response
func (o *SchemaObjectsGetInternalServerError) WithPayload(payload *models.ErrorResponse) *SchemaObjectsGetInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects get internal server error response
func (o *SchemaObjectsGetInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsGetInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
