//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// SchemaObjectsDeleteOKCode is the HTTP code returned for type SchemaObjectsDeleteOK
const SchemaObjectsDeleteOKCode int = 200

/*
SchemaObjectsDeleteOK Removed the Object class from the schema.

swagger:response schemaObjectsDeleteOK
*/
type SchemaObjectsDeleteOK struct {
}

// NewSchemaObjectsDeleteOK creates SchemaObjectsDeleteOK with default headers values
func NewSchemaObjectsDeleteOK() *SchemaObjectsDeleteOK {

	return &SchemaObjectsDeleteOK{}
}

// WriteResponse to the client
func (o *SchemaObjectsDeleteOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// SchemaObjectsDeleteBadRequestCode is the HTTP code returned for type SchemaObjectsDeleteBadRequest
const SchemaObjectsDeleteBadRequestCode int = 400

/*
SchemaObjectsDeleteBadRequest Could not delete the Object class.

swagger:response schemaObjectsDeleteBadRequest
*/
type SchemaObjectsDeleteBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewSchemaObjectsDeleteBadRequest creates SchemaObjectsDeleteBadRequest with default headers values
func NewSchemaObjectsDeleteBadRequest() *SchemaObjectsDeleteBadRequest {

	return &SchemaObjectsDeleteBadRequest{}
}

// WithPayload adds the payload to the schema objects delete bad request response
func (o *SchemaObjectsDeleteBadRequest) WithPayload(payload *models.ErrorResponse) *SchemaObjectsDeleteBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects delete bad request response
func (o *SchemaObjectsDeleteBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsDeleteBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// SchemaObjectsDeleteUnauthorizedCode is the HTTP code returned for type SchemaObjectsDeleteUnauthorized
const SchemaObjectsDeleteUnauthorizedCode int = 401

/*
SchemaObjectsDeleteUnauthorized Unauthorized or invalid credentials.

swagger:response schemaObjectsDeleteUnauthorized
*/
type SchemaObjectsDeleteUnauthorized struct {
}

// NewSchemaObjectsDeleteUnauthorized creates SchemaObjectsDeleteUnauthorized with default headers values
func NewSchemaObjectsDeleteUnauthorized() *SchemaObjectsDeleteUnauthorized {

	return &SchemaObjectsDeleteUnauthorized{}
}

// WriteResponse to the client
func (o *SchemaObjectsDeleteUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// SchemaObjectsDeleteForbiddenCode is the HTTP code returned for type SchemaObjectsDeleteForbidden
const SchemaObjectsDeleteForbiddenCode int = 403

/*
SchemaObjectsDeleteForbidden Forbidden

swagger:response schemaObjectsDeleteForbidden
*/
type SchemaObjectsDeleteForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewSchemaObjectsDeleteForbidden creates SchemaObjectsDeleteForbidden with default headers values
func NewSchemaObjectsDeleteForbidden() *SchemaObjectsDeleteForbidden {

	return &SchemaObjectsDeleteForbidden{}
}

// WithPayload adds the payload to the schema objects delete forbidden response
func (o *SchemaObjectsDeleteForbidden) WithPayload(payload *models.ErrorResponse) *SchemaObjectsDeleteForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects delete forbidden response
func (o *SchemaObjectsDeleteForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsDeleteForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// SchemaObjectsDeleteInternalServerErrorCode is the HTTP code returned for type SchemaObjectsDeleteInternalServerError
const SchemaObjectsDeleteInternalServerErrorCode int = 500

/*
SchemaObjectsDeleteInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response schemaObjectsDeleteInternalServerError
*/
type SchemaObjectsDeleteInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewSchemaObjectsDeleteInternalServerError creates SchemaObjectsDeleteInternalServerError with default headers values
func NewSchemaObjectsDeleteInternalServerError() *SchemaObjectsDeleteInternalServerError {

	return &SchemaObjectsDeleteInternalServerError{}
}

// WithPayload adds the payload to the schema objects delete internal server error response
func (o *SchemaObjectsDeleteInternalServerError) WithPayload(payload *models.ErrorResponse) *SchemaObjectsDeleteInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the schema objects delete internal server error response
func (o *SchemaObjectsDeleteInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *SchemaObjectsDeleteInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
