//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsReferencesCreateHandlerFunc turns a function with the right signature into a objects references create handler
type ObjectsReferencesCreateHandlerFunc func(ObjectsReferencesCreateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ObjectsReferencesCreateHandlerFunc) Handle(params ObjectsReferencesCreateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ObjectsReferencesCreateHandler interface for that can handle valid objects references create params
type ObjectsReferencesCreateHandler interface {
	Handle(ObjectsReferencesCreateParams, *models.Principal) middleware.Responder
}

// NewObjectsReferencesCreate creates a new http.Handler for the objects references create operation
func NewObjectsReferencesCreate(ctx *middleware.Context, handler ObjectsReferencesCreateHandler) *ObjectsReferencesCreate {
	return &ObjectsReferencesCreate{Context: ctx, Handler: handler}
}

/*
	ObjectsReferencesCreate swagger:route POST /objects/{id}/references/{propertyName} objects objectsReferencesCreate

Add a single reference to a class-property.

Add a cross-reference.
*/
type ObjectsReferencesCreate struct {
	Context *middleware.Context
	Handler ObjectsReferencesCreateHandler
}

func (o *ObjectsReferencesCreate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewObjectsReferencesCreateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
