//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsHeadHandlerFunc turns a function with the right signature into a objects head handler
type ObjectsHeadHandlerFunc func(ObjectsHeadParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn ObjectsHeadHandlerFunc) Handle(params ObjectsHeadParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// ObjectsHeadHandler interface for that can handle valid objects head params
type ObjectsHeadHandler interface {
	Handle(ObjectsHeadParams, *models.Principal) middleware.Responder
}

// NewObjectsHead creates a new http.Handler for the objects head operation
func NewObjectsHead(ctx *middleware.Context, handler ObjectsHeadHandler) *ObjectsHead {
	return &ObjectsHead{Context: ctx, Handler: handler}
}

/*
	ObjectsHead swagger:route HEAD /objects/{id} objects objectsHead

Checks Object's existence based on its UUID.

Checks if an object exists in the system based on its UUID.
*/
type ObjectsHead struct {
	Context *middleware.Context
	Handler ObjectsHeadHandler
}

func (o *ObjectsHead) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewObjectsHeadParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
