//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// NodesGetClassOKCode is the HTTP code returned for type NodesGetClassOK
const NodesGetClassOKCode int = 200

/*
NodesGetClassOK Nodes status successfully returned

swagger:response nodesGetClassOK
*/
type NodesGetClassOK struct {

	/*
	  In: Body
	*/
	Payload *models.NodesStatusResponse `json:"body,omitempty"`
}

// NewNodesGetClassOK creates NodesGetClassOK with default headers values
func NewNodesGetClassOK() *NodesGetClassOK {

	return &NodesGetClassOK{}
}

// WithPayload adds the payload to the nodes get class o k response
func (o *NodesGetClassOK) WithPayload(payload *models.NodesStatusResponse) *NodesGetClassOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the nodes get class o k response
func (o *NodesGetClassOK) SetPayload(payload *models.NodesStatusResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *NodesGetClassOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// NodesGetClassUnauthorizedCode is the HTTP code returned for type NodesGetClassUnauthorized
const NodesGetClassUnauthorizedCode int = 401

/*
NodesGetClassUnauthorized Unauthorized or invalid credentials.

swagger:response nodesGetClassUnauthorized
*/
type NodesGetClassUnauthorized struct {
}

// NewNodesGetClassUnauthorized creates NodesGetClassUnauthorized with default headers values
func NewNodesGetClassUnauthorized() *NodesGetClassUnauthorized {

	return &NodesGetClassUnauthorized{}
}

// WriteResponse to the client
func (o *NodesGetClassUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// NodesGetClassForbiddenCode is the HTTP code returned for type NodesGetClassForbidden
const NodesGetClassForbiddenCode int = 403

/*
NodesGetClassForbidden Forbidden

swagger:response nodesGetClassForbidden
*/
type NodesGetClassForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewNodesGetClassForbidden creates NodesGetClassForbidden with default headers values
func NewNodesGetClassForbidden() *NodesGetClassForbidden {

	return &NodesGetClassForbidden{}
}

// WithPayload adds the payload to the nodes get class forbidden response
func (o *NodesGetClassForbidden) WithPayload(payload *models.ErrorResponse) *NodesGetClassForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the nodes get class forbidden response
func (o *NodesGetClassForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *NodesGetClassForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// NodesGetClassNotFoundCode is the HTTP code returned for type NodesGetClassNotFound
const NodesGetClassNotFoundCode int = 404

/*
NodesGetClassNotFound Not Found - Backup does not exist

swagger:response nodesGetClassNotFound
*/
type NodesGetClassNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewNodesGetClassNotFound creates NodesGetClassNotFound with default headers values
func NewNodesGetClassNotFound() *NodesGetClassNotFound {

	return &NodesGetClassNotFound{}
}

// WithPayload adds the payload to the nodes get class not found response
func (o *NodesGetClassNotFound) WithPayload(payload *models.ErrorResponse) *NodesGetClassNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the nodes get class not found response
func (o *NodesGetClassNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *NodesGetClassNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// NodesGetClassUnprocessableEntityCode is the HTTP code returned for type NodesGetClassUnprocessableEntity
const NodesGetClassUnprocessableEntityCode int = 422

/*
NodesGetClassUnprocessableEntity Invalid backup restoration status attempt.

swagger:response nodesGetClassUnprocessableEntity
*/
type NodesGetClassUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewNodesGetClassUnprocessableEntity creates NodesGetClassUnprocessableEntity with default headers values
func NewNodesGetClassUnprocessableEntity() *NodesGetClassUnprocessableEntity {

	return &NodesGetClassUnprocessableEntity{}
}

// WithPayload adds the payload to the nodes get class unprocessable entity response
func (o *NodesGetClassUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *NodesGetClassUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the nodes get class unprocessable entity response
func (o *NodesGetClassUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *NodesGetClassUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// NodesGetClassInternalServerErrorCode is the HTTP code returned for type NodesGetClassInternalServerError
const NodesGetClassInternalServerErrorCode int = 500

/*
NodesGetClassInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response nodesGetClassInternalServerError
*/
type NodesGetClassInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewNodesGetClassInternalServerError creates NodesGetClassInternalServerError with default headers values
func NewNodesGetClassInternalServerError() *NodesGetClassInternalServerError {

	return &NodesGetClassInternalServerError{}
}

// WithPayload adds the payload to the nodes get class internal server error response
func (o *NodesGetClassInternalServerError) WithPayload(payload *models.ErrorResponse) *NodesGetClassInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the nodes get class internal server error response
func (o *NodesGetClassInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *NodesGetClassInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
