//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// NodesGetClassHandlerFunc turns a function with the right signature into a nodes get class handler
type NodesGetClassHandlerFunc func(NodesGetClassParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn NodesGetClassHandlerFunc) Handle(params NodesGetClassParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// NodesGetClassHandler interface for that can handle valid nodes get class params
type NodesGetClassHandler interface {
	Handle(NodesGetClassParams, *models.Principal) middleware.Responder
}

// NewNodesGetClass creates a new http.Handler for the nodes get class operation
func NewNodesGetClass(ctx *middleware.Context, handler NodesGetClassHandler) *NodesGetClass {
	return &NodesGetClass{Context: ctx, Handler: handler}
}

/*
	NodesGetClass swagger:route GET /nodes/{className} nodes nodesGetClass

Node information for a collection.

Returns node information for the nodes relevant to the collection.
*/
type NodesGetClass struct {
	Context *middleware.Context
	Handler NodesGetClassHandler
}

func (o *NodesGetClass) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewNodesGetClassParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
