//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package cluster

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// ClusterGetStatisticsOKCode is the HTTP code returned for type ClusterGetStatisticsOK
const ClusterGetStatisticsOKCode int = 200

/*
ClusterGetStatisticsOK Cluster statistics successfully returned

swagger:response clusterGetStatisticsOK
*/
type ClusterGetStatisticsOK struct {

	/*
	  In: Body
	*/
	Payload *models.ClusterStatisticsResponse `json:"body,omitempty"`
}

// NewClusterGetStatisticsOK creates ClusterGetStatisticsOK with default headers values
func NewClusterGetStatisticsOK() *ClusterGetStatisticsOK {

	return &ClusterGetStatisticsOK{}
}

// WithPayload adds the payload to the cluster get statistics o k response
func (o *ClusterGetStatisticsOK) WithPayload(payload *models.ClusterStatisticsResponse) *ClusterGetStatisticsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cluster get statistics o k response
func (o *ClusterGetStatisticsOK) SetPayload(payload *models.ClusterStatisticsResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClusterGetStatisticsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ClusterGetStatisticsUnauthorizedCode is the HTTP code returned for type ClusterGetStatisticsUnauthorized
const ClusterGetStatisticsUnauthorizedCode int = 401

/*
ClusterGetStatisticsUnauthorized Unauthorized or invalid credentials.

swagger:response clusterGetStatisticsUnauthorized
*/
type ClusterGetStatisticsUnauthorized struct {
}

// NewClusterGetStatisticsUnauthorized creates ClusterGetStatisticsUnauthorized with default headers values
func NewClusterGetStatisticsUnauthorized() *ClusterGetStatisticsUnauthorized {

	return &ClusterGetStatisticsUnauthorized{}
}

// WriteResponse to the client
func (o *ClusterGetStatisticsUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// ClusterGetStatisticsForbiddenCode is the HTTP code returned for type ClusterGetStatisticsForbidden
const ClusterGetStatisticsForbiddenCode int = 403

/*
ClusterGetStatisticsForbidden Forbidden

swagger:response clusterGetStatisticsForbidden
*/
type ClusterGetStatisticsForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewClusterGetStatisticsForbidden creates ClusterGetStatisticsForbidden with default headers values
func NewClusterGetStatisticsForbidden() *ClusterGetStatisticsForbidden {

	return &ClusterGetStatisticsForbidden{}
}

// WithPayload adds the payload to the cluster get statistics forbidden response
func (o *ClusterGetStatisticsForbidden) WithPayload(payload *models.ErrorResponse) *ClusterGetStatisticsForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cluster get statistics forbidden response
func (o *ClusterGetStatisticsForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClusterGetStatisticsForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ClusterGetStatisticsUnprocessableEntityCode is the HTTP code returned for type ClusterGetStatisticsUnprocessableEntity
const ClusterGetStatisticsUnprocessableEntityCode int = 422

/*
ClusterGetStatisticsUnprocessableEntity Invalid backup restoration status attempt.

swagger:response clusterGetStatisticsUnprocessableEntity
*/
type ClusterGetStatisticsUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewClusterGetStatisticsUnprocessableEntity creates ClusterGetStatisticsUnprocessableEntity with default headers values
func NewClusterGetStatisticsUnprocessableEntity() *ClusterGetStatisticsUnprocessableEntity {

	return &ClusterGetStatisticsUnprocessableEntity{}
}

// WithPayload adds the payload to the cluster get statistics unprocessable entity response
func (o *ClusterGetStatisticsUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *ClusterGetStatisticsUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cluster get statistics unprocessable entity response
func (o *ClusterGetStatisticsUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClusterGetStatisticsUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ClusterGetStatisticsInternalServerErrorCode is the HTTP code returned for type ClusterGetStatisticsInternalServerError
const ClusterGetStatisticsInternalServerErrorCode int = 500

/*
ClusterGetStatisticsInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response clusterGetStatisticsInternalServerError
*/
type ClusterGetStatisticsInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewClusterGetStatisticsInternalServerError creates ClusterGetStatisticsInternalServerError with default headers values
func NewClusterGetStatisticsInternalServerError() *ClusterGetStatisticsInternalServerError {

	return &ClusterGetStatisticsInternalServerError{}
}

// WithPayload adds the payload to the cluster get statistics internal server error response
func (o *ClusterGetStatisticsInternalServerError) WithPayload(payload *models.ErrorResponse) *ClusterGetStatisticsInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the cluster get statistics internal server error response
func (o *ClusterGetStatisticsInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ClusterGetStatisticsInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
