//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package batch

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// BatchReferencesCreateHandlerFunc turns a function with the right signature into a batch references create handler
type BatchReferencesCreateHandlerFunc func(BatchReferencesCreateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn BatchReferencesCreateHandlerFunc) Handle(params BatchReferencesCreateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// BatchReferencesCreateHandler interface for that can handle valid batch references create params
type BatchReferencesCreateHandler interface {
	Handle(BatchReferencesCreateParams, *models.Principal) middleware.Responder
}

// NewBatchReferencesCreate creates a new http.Handler for the batch references create operation
func NewBatchReferencesCreate(ctx *middleware.Context, handler BatchReferencesCreateHandler) *BatchReferencesCreate {
	return &BatchReferencesCreate{Context: ctx, Handler: handler}
}

/*
	BatchReferencesCreate swagger:route POST /batch/references batch references batchReferencesCreate

Creates new Cross-References between arbitrary classes in bulk.

Batch create cross-references between collections items (objects or objects) in bulk.
*/
type BatchReferencesCreate struct {
	Context *middleware.Context
	Handler BatchReferencesCreateHandler
}

func (o *BatchReferencesCreate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewBatchReferencesCreateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
