//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// BackupsListOKCode is the HTTP code returned for type BackupsListOK
const BackupsListOKCode int = 200

/*
BackupsListOK Existed backups

swagger:response backupsListOK
*/
type BackupsListOK struct {

	/*
	  In: Body
	*/
	Payload models.BackupListResponse `json:"body,omitempty"`
}

// NewBackupsListOK creates BackupsListOK with default headers values
func NewBackupsListOK() *BackupsListOK {

	return &BackupsListOK{}
}

// WithPayload adds the payload to the backups list o k response
func (o *BackupsListOK) WithPayload(payload models.BackupListResponse) *BackupsListOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups list o k response
func (o *BackupsListOK) SetPayload(payload models.BackupListResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsListOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.BackupListResponse{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// BackupsListUnauthorizedCode is the HTTP code returned for type BackupsListUnauthorized
const BackupsListUnauthorizedCode int = 401

/*
BackupsListUnauthorized Unauthorized or invalid credentials.

swagger:response backupsListUnauthorized
*/
type BackupsListUnauthorized struct {
}

// NewBackupsListUnauthorized creates BackupsListUnauthorized with default headers values
func NewBackupsListUnauthorized() *BackupsListUnauthorized {

	return &BackupsListUnauthorized{}
}

// WriteResponse to the client
func (o *BackupsListUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// BackupsListForbiddenCode is the HTTP code returned for type BackupsListForbidden
const BackupsListForbiddenCode int = 403

/*
BackupsListForbidden Forbidden

swagger:response backupsListForbidden
*/
type BackupsListForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsListForbidden creates BackupsListForbidden with default headers values
func NewBackupsListForbidden() *BackupsListForbidden {

	return &BackupsListForbidden{}
}

// WithPayload adds the payload to the backups list forbidden response
func (o *BackupsListForbidden) WithPayload(payload *models.ErrorResponse) *BackupsListForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups list forbidden response
func (o *BackupsListForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsListForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// BackupsListUnprocessableEntityCode is the HTTP code returned for type BackupsListUnprocessableEntity
const BackupsListUnprocessableEntityCode int = 422

/*
BackupsListUnprocessableEntity Invalid backup list.

swagger:response backupsListUnprocessableEntity
*/
type BackupsListUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsListUnprocessableEntity creates BackupsListUnprocessableEntity with default headers values
func NewBackupsListUnprocessableEntity() *BackupsListUnprocessableEntity {

	return &BackupsListUnprocessableEntity{}
}

// WithPayload adds the payload to the backups list unprocessable entity response
func (o *BackupsListUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *BackupsListUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups list unprocessable entity response
func (o *BackupsListUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsListUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// BackupsListInternalServerErrorCode is the HTTP code returned for type BackupsListInternalServerError
const BackupsListInternalServerErrorCode int = 500

/*
BackupsListInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response backupsListInternalServerError
*/
type BackupsListInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewBackupsListInternalServerError creates BackupsListInternalServerError with default headers values
func NewBackupsListInternalServerError() *BackupsListInternalServerError {

	return &BackupsListInternalServerError{}
}

// WithPayload adds the payload to the backups list internal server error response
func (o *BackupsListInternalServerError) WithPayload(payload *models.ErrorResponse) *BackupsListInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the backups list internal server error response
func (o *BackupsListInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BackupsListInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
