//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// RemovePermissionsOKCode is the HTTP code returned for type RemovePermissionsOK
const RemovePermissionsOKCode int = 200

/*
RemovePermissionsOK Permissions removed successfully

swagger:response removePermissionsOK
*/
type RemovePermissionsOK struct {
}

// NewRemovePermissionsOK creates RemovePermissionsOK with default headers values
func NewRemovePermissionsOK() *RemovePermissionsOK {

	return &RemovePermissionsOK{}
}

// WriteResponse to the client
func (o *RemovePermissionsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(200)
}

// RemovePermissionsBadRequestCode is the HTTP code returned for type RemovePermissionsBadRequest
const RemovePermissionsBadRequestCode int = 400

/*
RemovePermissionsBadRequest Malformed request.

swagger:response removePermissionsBadRequest
*/
type RemovePermissionsBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRemovePermissionsBadRequest creates RemovePermissionsBadRequest with default headers values
func NewRemovePermissionsBadRequest() *RemovePermissionsBadRequest {

	return &RemovePermissionsBadRequest{}
}

// WithPayload adds the payload to the remove permissions bad request response
func (o *RemovePermissionsBadRequest) WithPayload(payload *models.ErrorResponse) *RemovePermissionsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the remove permissions bad request response
func (o *RemovePermissionsBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RemovePermissionsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// RemovePermissionsUnauthorizedCode is the HTTP code returned for type RemovePermissionsUnauthorized
const RemovePermissionsUnauthorizedCode int = 401

/*
RemovePermissionsUnauthorized Unauthorized or invalid credentials.

swagger:response removePermissionsUnauthorized
*/
type RemovePermissionsUnauthorized struct {
}

// NewRemovePermissionsUnauthorized creates RemovePermissionsUnauthorized with default headers values
func NewRemovePermissionsUnauthorized() *RemovePermissionsUnauthorized {

	return &RemovePermissionsUnauthorized{}
}

// WriteResponse to the client
func (o *RemovePermissionsUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// RemovePermissionsForbiddenCode is the HTTP code returned for type RemovePermissionsForbidden
const RemovePermissionsForbiddenCode int = 403

/*
RemovePermissionsForbidden Forbidden

swagger:response removePermissionsForbidden
*/
type RemovePermissionsForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRemovePermissionsForbidden creates RemovePermissionsForbidden with default headers values
func NewRemovePermissionsForbidden() *RemovePermissionsForbidden {

	return &RemovePermissionsForbidden{}
}

// WithPayload adds the payload to the remove permissions forbidden response
func (o *RemovePermissionsForbidden) WithPayload(payload *models.ErrorResponse) *RemovePermissionsForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the remove permissions forbidden response
func (o *RemovePermissionsForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RemovePermissionsForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// RemovePermissionsUnprocessableEntityCode is the HTTP code returned for type RemovePermissionsUnprocessableEntity
const RemovePermissionsUnprocessableEntityCode int = 422

/*
RemovePermissionsUnprocessableEntity Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?

swagger:response removePermissionsUnprocessableEntity
*/
type RemovePermissionsUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRemovePermissionsUnprocessableEntity creates RemovePermissionsUnprocessableEntity with default headers values
func NewRemovePermissionsUnprocessableEntity() *RemovePermissionsUnprocessableEntity {

	return &RemovePermissionsUnprocessableEntity{}
}

// WithPayload adds the payload to the remove permissions unprocessable entity response
func (o *RemovePermissionsUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *RemovePermissionsUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the remove permissions unprocessable entity response
func (o *RemovePermissionsUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RemovePermissionsUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// RemovePermissionsInternalServerErrorCode is the HTTP code returned for type RemovePermissionsInternalServerError
const RemovePermissionsInternalServerErrorCode int = 500

/*
RemovePermissionsInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response removePermissionsInternalServerError
*/
type RemovePermissionsInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewRemovePermissionsInternalServerError creates RemovePermissionsInternalServerError with default headers values
func NewRemovePermissionsInternalServerError() *RemovePermissionsInternalServerError {

	return &RemovePermissionsInternalServerError{}
}

// WithPayload adds the payload to the remove permissions internal server error response
func (o *RemovePermissionsInternalServerError) WithPayload(payload *models.ErrorResponse) *RemovePermissionsInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the remove permissions internal server error response
func (o *RemovePermissionsInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *RemovePermissionsInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
