//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// CreateRoleCreatedCode is the HTTP code returned for type CreateRoleCreated
const CreateRoleCreatedCode int = 201

/*
CreateRoleCreated Role created successfully

swagger:response createRoleCreated
*/
type CreateRoleCreated struct {
}

// NewCreateRoleCreated creates CreateRoleCreated with default headers values
func NewCreateRoleCreated() *CreateRoleCreated {

	return &CreateRoleCreated{}
}

// WriteResponse to the client
func (o *CreateRoleCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(201)
}

// CreateRoleBadRequestCode is the HTTP code returned for type CreateRoleBadRequest
const CreateRoleBadRequestCode int = 400

/*
CreateRoleBadRequest Malformed request.

swagger:response createRoleBadRequest
*/
type CreateRoleBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateRoleBadRequest creates CreateRoleBadRequest with default headers values
func NewCreateRoleBadRequest() *CreateRoleBadRequest {

	return &CreateRoleBadRequest{}
}

// WithPayload adds the payload to the create role bad request response
func (o *CreateRoleBadRequest) WithPayload(payload *models.ErrorResponse) *CreateRoleBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create role bad request response
func (o *CreateRoleBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRoleBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRoleUnauthorizedCode is the HTTP code returned for type CreateRoleUnauthorized
const CreateRoleUnauthorizedCode int = 401

/*
CreateRoleUnauthorized Unauthorized or invalid credentials.

swagger:response createRoleUnauthorized
*/
type CreateRoleUnauthorized struct {
}

// NewCreateRoleUnauthorized creates CreateRoleUnauthorized with default headers values
func NewCreateRoleUnauthorized() *CreateRoleUnauthorized {

	return &CreateRoleUnauthorized{}
}

// WriteResponse to the client
func (o *CreateRoleUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// CreateRoleForbiddenCode is the HTTP code returned for type CreateRoleForbidden
const CreateRoleForbiddenCode int = 403

/*
CreateRoleForbidden Forbidden

swagger:response createRoleForbidden
*/
type CreateRoleForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateRoleForbidden creates CreateRoleForbidden with default headers values
func NewCreateRoleForbidden() *CreateRoleForbidden {

	return &CreateRoleForbidden{}
}

// WithPayload adds the payload to the create role forbidden response
func (o *CreateRoleForbidden) WithPayload(payload *models.ErrorResponse) *CreateRoleForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create role forbidden response
func (o *CreateRoleForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRoleForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRoleConflictCode is the HTTP code returned for type CreateRoleConflict
const CreateRoleConflictCode int = 409

/*
CreateRoleConflict Role already exists

swagger:response createRoleConflict
*/
type CreateRoleConflict struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateRoleConflict creates CreateRoleConflict with default headers values
func NewCreateRoleConflict() *CreateRoleConflict {

	return &CreateRoleConflict{}
}

// WithPayload adds the payload to the create role conflict response
func (o *CreateRoleConflict) WithPayload(payload *models.ErrorResponse) *CreateRoleConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create role conflict response
func (o *CreateRoleConflict) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRoleConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRoleUnprocessableEntityCode is the HTTP code returned for type CreateRoleUnprocessableEntity
const CreateRoleUnprocessableEntityCode int = 422

/*
CreateRoleUnprocessableEntity Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?

swagger:response createRoleUnprocessableEntity
*/
type CreateRoleUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateRoleUnprocessableEntity creates CreateRoleUnprocessableEntity with default headers values
func NewCreateRoleUnprocessableEntity() *CreateRoleUnprocessableEntity {

	return &CreateRoleUnprocessableEntity{}
}

// WithPayload adds the payload to the create role unprocessable entity response
func (o *CreateRoleUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *CreateRoleUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create role unprocessable entity response
func (o *CreateRoleUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRoleUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateRoleInternalServerErrorCode is the HTTP code returned for type CreateRoleInternalServerError
const CreateRoleInternalServerErrorCode int = 500

/*
CreateRoleInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response createRoleInternalServerError
*/
type CreateRoleInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateRoleInternalServerError creates CreateRoleInternalServerError with default headers values
func NewCreateRoleInternalServerError() *CreateRoleInternalServerError {

	return &CreateRoleInternalServerError{}
}

// WithPayload adds the payload to the create role internal server error response
func (o *CreateRoleInternalServerError) WithPayload(payload *models.ErrorResponse) *CreateRoleInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create role internal server error response
func (o *CreateRoleInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateRoleInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
