//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2024 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package rest

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/yaml",
    "application/json"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "# Introduction\n Weaviate is an open source, AI-native vector database that helps developers create intuitive and reliable AI-powered applications. \n ### Base Path \nThe base path for the Weaviate server is structured as ` + "`" + `[YOUR-WEAVIATE-HOST]:[PORT]/v1` + "`" + `. As an example, if you wish to access the ` + "`" + `schema` + "`" + ` endpoint on a local instance, you would navigate to ` + "`" + `http://localhost:8080/v1/schema` + "`" + `. Ensure you replace ` + "`" + `[YOUR-WEAVIATE-HOST]` + "`" + ` and ` + "`" + `[PORT]` + "`" + ` with your actual server host and port number respectively. \n ### Questions? \nIf you have any comments or questions, please feel free to reach out to us at the community forum [https://forum.weaviate.io/](https://forum.weaviate.io/). \n### Issues? \nIf you find a bug or want to file a feature request, please open an issue on our GitHub repository for [Weaviate](https://github.com/weaviate/weaviate). \n### Want more documentation? \nFor a quickstart, code examples, concepts and more, please visit our [documentation page](https://weaviate.io/developers/weaviate).",
    "title": "Weaviate",
    "contact": {
      "name": "Weaviate",
      "url": "https://github.com/weaviate",
      "email": "hello@weaviate.io"
    },
    "version": "1.28.0-rc.0"
  },
  "basePath": "/v1",
  "paths": {
    "/": {
      "get": {
        "description": "Get links to other endpoints to help discover the REST API",
        "summary": "List available endpoints",
        "operationId": "weaviate.root",
        "responses": {
          "200": {
            "description": "Weaviate is alive and ready to serve content",
            "schema": {
              "type": "object",
              "properties": {
                "links": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Link"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/.well-known/live": {
      "get": {
        "description": "Determines whether the application is alive. Can be used for kubernetes liveness probe",
        "summary": "Get application liveness.",
        "operationId": "weaviate.wellknown.liveness",
        "responses": {
          "200": {
            "description": "The application is able to respond to HTTP requests"
          }
        }
      }
    },
    "/.well-known/openid-configuration": {
      "get": {
        "description": "OIDC Discovery page, redirects to the token issuer if one is configured",
        "tags": [
          "well-known",
          "oidc",
          "discovery"
        ],
        "summary": "OIDC discovery information if OIDC auth is enabled",
        "responses": {
          "200": {
            "description": "Successful response, inspect body",
            "schema": {
              "type": "object",
              "properties": {
                "clientId": {
                  "description": "OAuth Client ID",
                  "type": "string"
                },
                "href": {
                  "description": "The Location to redirect to",
                  "type": "string"
                },
                "scopes": {
                  "description": "OAuth Scopes",
                  "type": "array",
                  "items": {
                    "type": "string"
                  },
                  "x-omitempty": true
                }
              }
            }
          },
          "404": {
            "description": "Not found, no oidc provider present"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false
      }
    },
    "/.well-known/ready": {
      "get": {
        "description": "Determines whether the application is ready to receive traffic. Can be used for kubernetes readiness probe.",
        "summary": "Get application readiness.",
        "operationId": "weaviate.wellknown.readiness",
        "responses": {
          "200": {
            "description": "The application has completed its start-up routine and is ready to accept traffic."
          },
          "503": {
            "description": "The application is currently not able to serve traffic. If other horizontal replicas of weaviate are available and they are capable of receiving traffic, all traffic should be redirected there instead."
          }
        }
      }
    },
    "/authz/roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "Get all roles",
        "operationId": "getRoles",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles"
        ]
      },
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "create new role",
        "operationId": "createRole",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Role"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Role created successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "Role already exists",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.create.role"
        ]
      }
    },
    "/authz/roles/add-permissions": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Add permission to a role as an upsert. If the role doesn't exist then it will be created.",
        "operationId": "addPermissions",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "name": {
                  "description": "role name",
                  "type": "string"
                },
                "permissions": {
                  "description": "permissions to be added to the role",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions added successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.add.role.permissions"
        ]
      }
    },
    "/authz/roles/remove-permissions": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Remove permissions from a role. If this results in an empty role, the role will be deleted.",
        "operationId": "removePermissions",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "name": {
                  "description": "role name",
                  "type": "string"
                },
                "permissions": {
                  "description": "permissions to remove from the role",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions removed successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.remove.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "Get a role",
        "operationId": "getRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Role"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.role"
        ]
      },
      "delete": {
        "tags": [
          "authz"
        ],
        "summary": "Delete role",
        "operationId": "deleteRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.delete.role"
        ]
      }
    },
    "/authz/roles/{id}/users": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get users or a keys assigned to role",
        "operationId": "getUsersForRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found for user"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/users/own-roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get roles assigned to own user",
        "operationId": "getRolesForOwnUser",
        "responses": {
          "200": {
            "description": "Role assigned to own users",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.own-roles"
        ]
      }
    },
    "/authz/users/{id}/assign": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a user",
        "operationId": "assignRole",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "properties": {
                "roles": {
                  "description": "the roles that assigned to user",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned successfully"
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "role or user is not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role"
        ]
      }
    },
    "/authz/users/{id}/revoke": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a user",
        "operationId": "revokeRole",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "properties": {
                "roles": {
                  "description": "the roles that revoked from the key or user",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role revoked successfully"
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "role or user is not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role"
        ]
      }
    },
    "/authz/users/{id}/roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get roles assigned to user",
        "operationId": "getRolesForUser",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned users",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found for user"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/backups/{backend}": {
      "get": {
        "description": "[Coming soon] List all backups in progress not implemented yet.",
        "tags": [
          "backups"
        ],
        "summary": "List backups in progress",
        "operationId": "backups.list",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Existed backups",
            "schema": {
              "$ref": "#/definitions/BackupListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup list.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Start creating a backup for a set of collections. \u003cbr/\u003e\u003cbr/\u003eNotes: \u003cbr/\u003e- Weaviate uses gzip compression by default. \u003cbr/\u003e- Weaviate stays usable while a backup process is ongoing.",
        "tags": [
          "backups"
        ],
        "summary": "Start a backup process",
        "operationId": "backups.create",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupCreateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup create process successfully started.",
            "schema": {
              "$ref": "#/definitions/BackupCreateResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup creation attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}": {
      "get": {
        "description": "Returns status of backup creation attempt for a set of collections. \u003cbr/\u003e\u003cbr/\u003eAll client implementations have a ` + "`" + `wait for completion` + "`" + ` option which will poll the backup status in the background and only return once the backup has completed (successfully or unsuccessfully). If you set the ` + "`" + `wait for completion` + "`" + ` option to false, you can also check the status yourself using this endpoint.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup process status",
        "operationId": "backups.create.status",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Backup creation status successfully returned",
            "schema": {
              "$ref": "#/definitions/BackupCreateStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "delete": {
        "description": "Cancel created backup with specified ID",
        "tags": [
          "backups"
        ],
        "summary": "Cancel backup",
        "operationId": "backups.cancel",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup cancellation attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}/restore": {
      "get": {
        "description": "Returns status of a backup restoration attempt for a set of classes. \u003cbr/\u003e\u003cbr/\u003eAll client implementations have a ` + "`" + `wait for completion` + "`" + ` option which will poll the backup status in the background and only return once the backup has completed (successfully or unsuccessfully). If you set the ` + "`" + `wait for completion` + "`" + ` option to false, you can also check the status yourself using the this endpoint.",
        "tags": [
          "backups"
        ],
        "summary": "Get restore process status",
        "operationId": "backups.restore.status",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration status successfully returned",
            "schema": {
              "$ref": "#/definitions/BackupRestoreStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Starts a process of restoring a backup for a set of collections. \u003cbr/\u003e\u003cbr/\u003eAny backup can be restored to any machine, as long as the number of nodes between source and target are identical.\u003cbr/\u003e\u003cbr/\u003eRequrements:\u003cbr/\u003e\u003cbr/\u003e- None of the collections to be restored already exist on the target restoration node(s).\u003cbr/\u003e- The node names of the backed-up collections' must match those of the target restoration node(s).",
        "tags": [
          "backups"
        ],
        "summary": "Start a restoration process",
        "operationId": "backups.restore",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupRestoreRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration process successfully started.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/batch/objects": {
      "post": {
        "description": "Create new objects in bulk. \u003cbr/\u003e\u003cbr/\u003eMeta-data and schema values are validated. \u003cbr/\u003e\u003cbr/\u003e**Note: idempotence of ` + "`" + `/batch/objects` + "`" + `**: \u003cbr/\u003e` + "`" + `POST /batch/objects` + "`" + ` is idempotent, and will overwrite any existing object given the same id.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Creates new Objects based on a Object template as a batch.",
        "operationId": "batch.objects.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "fields": {
                  "description": "Define which fields need to be returned. Default value is ALL",
                  "type": "array",
                  "items": {
                    "type": "string",
                    "default": "ALL",
                    "enum": [
                      "ALL",
                      "class",
                      "schema",
                      "id",
                      "creationTimeUnix"
                    ]
                  }
                },
                "objects": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Object"
                  }
                }
              }
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request succeeded, see response body to get detailed information about each batched item.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/ObjectsGetResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      },
      "delete": {
        "description": "Batch delete objects that match a particular filter. \u003cbr/\u003e\u003cbr/\u003eThe request body takes a single ` + "`" + `where` + "`" + ` filter and will delete all objects matched. \u003cbr/\u003e\u003cbr/\u003eNote that there is a limit to the number of objects to be deleted at once using this filter, in order to protect against unexpected memory surges and very-long-running requests. The default limit is 10,000 and may be configured by setting the ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + ` environment variable. \u003cbr/\u003e\u003cbr/\u003eObjects are deleted in the same order that they would be returned in an equivalent Get query. To delete more objects than the limit, run the same query multiple times.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Deletes Objects based on a match filter as a batch.",
        "operationId": "batch.objects.delete",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BatchDelete"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request succeeded, see response body to get detailed information about each batched item.",
            "schema": {
              "$ref": "#/definitions/BatchDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/batch/references": {
      "post": {
        "description": "Batch create cross-references between collections items (objects or objects) in bulk.",
        "tags": [
          "batch",
          "references"
        ],
        "summary": "Creates new Cross-References between arbitrary classes in bulk.",
        "operationId": "batch.references.create",
        "parameters": [
          {
            "description": "A list of references to be batched. The ideal size depends on the used database connector. Please see the documentation of the used connector for help",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReference"
              }
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Request Successful. Warning: A successful request does not guarantee that every batched reference was successfully created. Inspect the response body to see which references succeeded and which failed.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReferenceResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/classifications/": {
      "post": {
        "description": "Trigger a classification based on the specified params. Classifications will run in the background, use GET /classifications/\u003cid\u003e to retrieve the status of your classification.",
        "tags": [
          "classifications"
        ],
        "summary": "Starts a classification.",
        "operationId": "classifications.post",
        "parameters": [
          {
            "description": "parameters to start a classification",
            "name": "params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Successfully started classification.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "400": {
            "description": "Incorrect request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.post"
        ]
      }
    },
    "/classifications/{id}": {
      "get": {
        "description": "Get status, results and metadata of a previously created classification",
        "tags": [
          "classifications"
        ],
        "summary": "View previously created classification",
        "operationId": "classifications.get",
        "parameters": [
          {
            "type": "string",
            "description": "classification id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Found the classification, returned as body",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Classification does not exist"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.get"
        ]
      }
    },
    "/cluster/statistics": {
      "get": {
        "description": "Returns Raft cluster statistics of Weaviate DB.",
        "tags": [
          "cluster"
        ],
        "summary": "See Raft cluster statistics",
        "operationId": "cluster.get.statistics",
        "responses": {
          "200": {
            "description": "Cluster statistics successfully returned",
            "schema": {
              "$ref": "#/definitions/ClusterStatisticsResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.cluster.statistics.get"
        ]
      }
    },
    "/graphql": {
      "post": {
        "description": "Get a response based on a GraphQL query",
        "tags": [
          "graphql"
        ],
        "summary": "Get a response based on GraphQL",
        "operationId": "graphql.post",
        "parameters": [
          {
            "description": "The GraphQL query request parameters.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successful query (with select).",
            "schema": {
              "$ref": "#/definitions/GraphQLResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/graphql/batch": {
      "post": {
        "description": "Perform a batched GraphQL query",
        "tags": [
          "graphql"
        ],
        "summary": "Get a response based on GraphQL.",
        "operationId": "graphql.batch",
        "parameters": [
          {
            "description": "The GraphQL queries.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQueries"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successful query (with select).",
            "schema": {
              "$ref": "#/definitions/GraphQLResponses"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/meta": {
      "get": {
        "description": "Returns meta information about the server. Can be used to provide information to another Weaviate instance that wants to interact with the current instance.",
        "tags": [
          "meta"
        ],
        "summary": "Returns meta information of the current Weaviate instance.",
        "operationId": "meta.get",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Meta"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/nodes": {
      "get": {
        "description": "Returns node information for the entire database.",
        "tags": [
          "nodes"
        ],
        "summary": "Node information for the database.",
        "operationId": "nodes.get",
        "parameters": [
          {
            "$ref": "#/parameters/CommonOutputVerbosityParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Nodes status successfully returned",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get"
        ]
      }
    },
    "/nodes/{className}": {
      "get": {
        "description": "Returns node information for the nodes relevant to the collection.",
        "tags": [
          "nodes"
        ],
        "summary": "Node information for a collection.",
        "operationId": "nodes.get.class",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonOutputVerbosityParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Nodes status successfully returned",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get.class"
        ]
      }
    },
    "/objects": {
      "get": {
        "description": "Lists all Objects in reverse order of creation, owned by the user that belongs to the used token.",
        "tags": [
          "objects"
        ],
        "summary": "Get a list of Objects.",
        "operationId": "objects.list",
        "parameters": [
          {
            "$ref": "#/parameters/CommonAfterParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonOffsetParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonLimitParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonSortParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonOrderParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonClassParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response. \u003cbr/\u003e\u003cbr/\u003eIf ` + "`" + `class` + "`" + ` is not provided, the response will not include any objects.",
            "schema": {
              "$ref": "#/definitions/ObjectsListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "post": {
        "description": "Create a new object. \u003cbr/\u003e\u003cbr/\u003eMeta-data and schema values are validated. \u003cbr/\u003e\u003cbr/\u003e**Note: Use ` + "`" + `/batch` + "`" + ` for importing many objects**: \u003cbr/\u003eIf you plan on importing a large number of objects, it's much more efficient to use the ` + "`" + `/batch` + "`" + ` endpoint. Otherwise, sending multiple single requests sequentially would incur a large performance penalty. \u003cbr/\u003e\u003cbr/\u003e**Note: idempotence of ` + "`" + `/objects` + "`" + `**: \u003cbr/\u003ePOST /objects will fail if an id is provided which already exists in the class. To update an existing object with the objects endpoint, use the PUT or PATCH method.",
        "tags": [
          "objects"
        ],
        "summary": "Create a new object.",
        "operationId": "objects.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Object created.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/objects/validate": {
      "post": {
        "description": "Validate an object's schema and meta-data without creating it. \u003cbr/\u003e\u003cbr/\u003eIf the schema of the object is valid, the request should return nothing with a plain RESTful request. Otherwise, an error object will be returned.",
        "tags": [
          "objects"
        ],
        "summary": "Validate an Object based on a schema.",
        "operationId": "objects.validate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully validated."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/objects/{className}/{id}": {
      "get": {
        "description": "Get a data object based on its collection and UUID. Also available as Websocket bus.",
        "tags": [
          "objects"
        ],
        "summary": "Get a specific Object based on its class and UUID. Also available as Websocket bus.",
        "operationId": "objects.class.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonNodeNameParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Update an object based on its uuid and collection. This (` + "`" + `put` + "`" + `) method replaces the object with the provided object.",
        "tags": [
          "objects"
        ],
        "summary": "Update a class object based on its uuid",
        "operationId": "objects.class.put",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object to update.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully received.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete an object based on its collection and UUID. \u003cbr/\u003e\u003cbr/\u003eNote: For backward compatibility, beacons also support an older, deprecated format without the collection name. As a result, when deleting a reference, the beacon specified has to match the beacon to be deleted exactly. In other words, if a beacon is present using the old format (without collection name) you also need to specify it the same way. \u003cbr/\u003e\u003cbr/\u003eIn the beacon format, you need to always use ` + "`" + `localhost` + "`" + ` as the host, rather than the actual hostname. ` + "`" + `localhost` + "`" + ` here refers to the fact that the beacon's target is on the same Weaviate instance, as opposed to a foreign instance.",
        "tags": [
          "objects"
        ],
        "summary": "Delete object based on its class and UUID.",
        "operationId": "objects.class.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if a data object exists based on its collection and uuid without retrieving it. \u003cbr/\u003e\u003cbr/\u003eInternally it skips reading the object from disk other than checking if it is present. Thus it does not use resources on marshalling, parsing, etc., and is faster. Note the resulting HTTP request has no body; the existence of an object is indicated solely by the status code.",
        "tags": [
          "objects"
        ],
        "summary": "Checks object's existence based on its class and uuid.",
        "operationId": "objects.class.head",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object doesn't exist."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "patch": {
        "description": "Update an individual data object based on its class and uuid. This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID (using patch semantics).",
        "operationId": "objects.class.patch",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object to update.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style patch, the body contains the object to merge into the existing object.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully applied. No content provided."
          },
          "400": {
            "description": "The patch-JSON is malformed.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "The patch-JSON is valid but unprocessable.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{className}/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace **all** references in cross-reference property of an object.",
        "tags": [
          "objects"
        ],
        "summary": "Replace all references to a class-property.",
        "operationId": "objects.class.references.put",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully replaced all the references."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object doesn't exist."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a single reference to an object. This adds a reference to the array of cross-references of the given property in the source object specified by its collection name and id",
        "tags": [
          "objects"
        ],
        "summary": "Add a single reference to a class-property.",
        "operationId": "objects.class.references.create",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully added the reference."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object doesn't exist."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has.",
        "tags": [
          "objects"
        ],
        "summary": "Delete the single reference that is given in the body from the list of references that this property has.",
        "operationId": "objects.class.references.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}": {
      "get": {
        "description": "Get a specific object based on its UUID. Also available as Websocket bus.",
        "tags": [
          "objects"
        ],
        "summary": "Get a specific Object based on its UUID and a Object UUID. Also available as Websocket bus.",
        "operationId": "objects.get",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonIncludeParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Updates an object based on its UUID. Given meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID.",
        "operationId": "objects.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully received.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Deletes an object from the database based on its UUID.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an Object based on its UUID.",
        "operationId": "objects.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if an object exists in the system based on its UUID.",
        "tags": [
          "objects"
        ],
        "summary": "Checks Object's existence based on its UUID.",
        "operationId": "objects.head",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object doesn't exist."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.objects.check"
        ]
      },
      "patch": {
        "description": "Update an object based on its UUID (using patch semantics). This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID (using patch semantics).",
        "operationId": "objects.patch",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style patch, the body contains the object to merge into the existing object.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "$ref": "#/parameters/CommonConsistencyLevelParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully applied. No content provided."
          },
          "400": {
            "description": "The patch-JSON is malformed."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "The patch-JSON is valid but unprocessable.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace all references in cross-reference property of an object.",
        "tags": [
          "objects"
        ],
        "summary": "Replace all references to a class-property.",
        "operationId": "objects.references.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully replaced all the references."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a cross-reference.",
        "tags": [
          "objects"
        ],
        "summary": "Add a single reference to a class-property.",
        "operationId": "objects.references.create",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully added the reference."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has.",
        "tags": [
          "objects"
        ],
        "summary": "Delete the single reference that is given in the body from the list of references that this property has.",
        "operationId": "objects.references.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "$ref": "#/parameters/CommonTenantParameterQuery"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/schema": {
      "get": {
        "description": "Fetch an array of all collection definitions from the schema.",
        "tags": [
          "schema"
        ],
        "summary": "Dump the current the database schema.",
        "operationId": "schema.dump",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully dumped the database schema.",
            "schema": {
              "$ref": "#/definitions/Schema"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      },
      "post": {
        "description": "Create a new data object collection. \u003cbr/\u003e\u003cbr/\u003eIf AutoSchema is enabled, Weaviate will attempt to infer the schema from the data at import time. However, manual schema definition is recommended for production environments.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new Object class in the schema.",
        "operationId": "schema.objects.create",
        "parameters": [
          {
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added the new Object class to the schema.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Object class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.add.meta"
        ]
      }
    },
    "/schema/{className}": {
      "get": {
        "tags": [
          "schema"
        ],
        "summary": "Get a single class from the schema",
        "operationId": "schema.objects.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Found the Class, returned as body",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "This class does not exist"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      },
      "put": {
        "description": "Add a property to an existing collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update settings of an existing schema class",
        "operationId": "schema.objects.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Class was updated successfully",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Class to be updated does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      },
      "delete": {
        "description": "Remove a collection from the schema. This will also delete all the objects in the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Remove an Object class (and all data in the instances) from the schema.",
        "operationId": "schema.objects.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Removed the Object class from the schema."
          },
          "400": {
            "description": "Could not delete the Object class.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/properties": {
      "post": {
        "tags": [
          "schema"
        ],
        "summary": "Add a property to an Object class.",
        "operationId": "schema.objects.properties.add",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Property"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added the property.",
            "schema": {
              "$ref": "#/definitions/Property"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid property.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/shards": {
      "get": {
        "description": "Get the status of every shard in the cluster.",
        "tags": [
          "schema"
        ],
        "summary": "Get the shards status of an Object class",
        "operationId": "schema.objects.shards.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Found the status of the shards, returned as body",
            "schema": {
              "$ref": "#/definitions/ShardStatusList"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "This class does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      }
    },
    "/schema/{className}/shards/{shardName}": {
      "put": {
        "description": "Update a shard status for a collection. For example, a shard may have been marked as ` + "`" + `READONLY` + "`" + ` because its disk was full. After providing more disk space, use this endpoint to set the shard status to ` + "`" + `READY` + "`" + ` again. There is also a convenience function in each client to set the status of all shards of a collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update a shard status.",
        "operationId": "schema.objects.shards.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "shardName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Shard status was updated successfully",
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard to be updated does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/tenants": {
      "get": {
        "description": "get all tenants from a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Get the list of tenants.",
        "operationId": "tenants.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "tenants from specified class.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Update tenant of a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Update a tenant.",
        "operationId": "tenants.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Updated tenants of the specified class",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Create a new tenant for a collection. Multi-tenancy must be enabled in the collection definition.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new tenant",
        "operationId": "tenants.create",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added new tenants to the specified class",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "delete tenants from a specific class",
        "tags": [
          "schema"
        ],
        "operationId": "tenants.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "tenants",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Deleted tenants from specified class."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/schema/{className}/tenants/{tenantName}": {
      "get": {
        "description": "get a specific tenant for the given class",
        "tags": [
          "schema"
        ],
        "summary": "Get a specific tenant",
        "operationId": "tenants.get.one",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "load the tenant given the specified class",
            "schema": {
              "$ref": "#/definitions/TenantResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant not found"
          },
          "422": {
            "description": "Invalid tenant or class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "head": {
        "description": "Check if a tenant exists for a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Check whether a tenant exists",
        "operationId": "tenant.exists",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "The tenant exists in the specified class"
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The tenant not found"
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "AdditionalProperties": {
      "description": "(Response only) Additional meta information about a single object.",
      "type": "object",
      "additionalProperties": {
        "type": "object"
      }
    },
    "BM25Config": {
      "description": "tuning parameters for the BM25 algorithm",
      "type": "object",
      "properties": {
        "b": {
          "description": "Calibrates term-weight scaling based on the document length (default: 0.75).",
          "type": "number",
          "format": "float"
        },
        "k1": {
          "description": "Calibrates term-weight scaling based on the term frequency within a document (default: 1.2).",
          "type": "number",
          "format": "float"
        }
      }
    },
    "BackupConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "ChunkSize": {
          "description": "Aimed chunk size, with a minimum of 2MB, default of 128MB, and a maximum of 512MB. The actual chunk size may vary.",
          "type": "integer",
          "default": 128,
          "maximum": 512,
          "minimum": 2,
          "x-nullable": false
        },
        "CompressionLevel": {
          "description": "compression level used by compression algorithm",
          "type": "string",
          "default": "DefaultCompression",
          "enum": [
            "DefaultCompression",
            "BestSpeed",
            "BestCompression"
          ],
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path or key within the bucket",
          "type": "string"
        }
      }
    },
    "BackupCreateRequest": {
      "description": "Request body for creating a backup of a set of classes",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup creation process",
          "type": "object",
          "$ref": "#/definitions/BackupConfig"
        },
        "exclude": {
          "description": "List of collections to exclude from the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `include` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the backup (required). Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "include": {
          "description": "List of collections to include in the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `exclude` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "BackupCreateResponse": {
      "description": "The definition of a backup create response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "classes": {
          "description": "The list of classes for which the backup creation process was started",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Path within bucket of backup",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupCreateStatusResponse": {
      "description": "The definition of a backup create metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backend",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupListResponse": {
      "description": "The definition of a backup create response body",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "classes": {
            "description": "The list of classes for which the existed backup process",
            "type": "array",
            "items": {
              "type": "string"
            }
          },
          "id": {
            "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "type": "string"
          },
          "path": {
            "description": "destination path of backup files proper to selected backend",
            "type": "string"
          },
          "status": {
            "description": "status of backup process",
            "type": "string",
            "enum": [
              "STARTED",
              "TRANSFERRING",
              "TRANSFERRED",
              "SUCCESS",
              "FAILED",
              "CANCELED"
            ]
          }
        }
      }
    },
    "BackupRestoreRequest": {
      "description": "Request body for restoring a backup for a set of classes",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup restoration process",
          "type": "object",
          "$ref": "#/definitions/RestoreConfig"
        },
        "exclude": {
          "description": "List of classes to exclude from the backup restoration process",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "include": {
          "description": "List of classes to include in the backup restoration process",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "node_mapping": {
          "description": "Allows overriding the node names stored in the backup with different ones. Useful when restoring backups to a different environment.",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "BackupRestoreResponse": {
      "description": "The definition of a backup restore response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "classes": {
          "description": "The list of classes for which the backup restoration process was started",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if restoration failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backend",
          "type": "string"
        },
        "status": {
          "description": "phase of backup restoration process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreStatusResponse": {
      "description": "The definition of a backup restore metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "error message if restoration failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backup backend, contains bucket and path",
          "type": "string"
        },
        "status": {
          "description": "phase of backup restoration process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BatchDelete": {
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, the call will show which objects would be matched using the specified filter without deleting any objects. \u003cbr/\u003e\u003cbr/\u003eDepending on the configured verbosity, you will either receive a count of affected objects, or a list of IDs.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "Class (name) which objects will be deleted.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
          "type": "string",
          "default": "minimal"
        }
      }
    },
    "BatchDeleteResponse": {
      "description": "Delete Objects response.",
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, objects will not be deleted yet, but merely listed. Defaults to false.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "Class (name) which objects will be deleted.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
          "type": "string",
          "default": "minimal"
        },
        "results": {
          "type": "object",
          "properties": {
            "failed": {
              "description": "How many objects should have been deleted but could not be deleted.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "limit": {
              "description": "The most amount of objects that can be deleted in a single query, equals QUERY_MAXIMUM_RESULTS.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "matches": {
              "description": "How many objects were matched by the filter.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "objects": {
              "description": "With output set to \"minimal\" only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to \"verbose\" will list all of the objets with their respective statuses.",
              "type": "array",
              "items": {
                "description": "Results for this specific Object.",
                "format": "object",
                "properties": {
                  "errors": {
                    "$ref": "#/definitions/ErrorResponse"
                  },
                  "id": {
                    "description": "ID of the Object.",
                    "type": "string",
                    "format": "uuid"
                  },
                  "status": {
                    "type": "string",
                    "default": "SUCCESS",
                    "enum": [
                      "SUCCESS",
                      "DRYRUN",
                      "FAILED"
                    ]
                  }
                }
              }
            },
            "successful": {
              "description": "How many objects were successfully deleted in this round.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            }
          }
        }
      }
    },
    "BatchReference": {
      "properties": {
        "from": {
          "description": "Long-form beacon-style URI to identify the source of the cross-ref including the property name. Should be in the form of weaviate://localhost/\u003ckinds\u003e/\u003cuuid\u003e/\u003cclassName\u003e/\u003cpropertyName\u003e, where \u003ckinds\u003e must be one of 'objects', 'objects' and \u003cclassName\u003e and \u003cpropertyName\u003e must represent the cross-ref property of source class to be used.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/Zoo/a5d09582-4239-4702-81c9-92a6e0122bb4/hasAnimals"
        },
        "tenant": {
          "description": "Name of the reference tenant.",
          "type": "string"
        },
        "to": {
          "description": "Short-form URI to point to the cross-ref. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-ref to an object",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/97525810-a9a5-4eb0-858a-71449aeb007f"
        }
      }
    },
    "BatchReferenceResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/BatchReference"
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific reference.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "BatchStats": {
      "description": "The summary of a nodes batch queue congestion status.",
      "properties": {
        "queueLength": {
          "description": "How many objects are currently in the batch queue.",
          "type": "number",
          "format": "int",
          "x-nullable": true,
          "x-omitempty": true
        },
        "ratePerSecond": {
          "description": "How many objects are approximately processed from the batch queue per second.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "C11yExtension": {
      "description": "A resource describing an extension to the contextinoary, containing both the identifier and the definition of the extension",
      "properties": {
        "concept": {
          "description": "The new concept you want to extend. Must be an all-lowercase single word, or a space delimited compound word. Examples: 'foobarium', 'my custom concept'",
          "type": "string",
          "example": "foobarium"
        },
        "definition": {
          "description": "A list of space-delimited words or a sentence describing what the custom concept is about. Avoid using the custom concept itself. An Example definition for the custom concept 'foobarium': would be 'a naturally occurring element which can only be seen by programmers'",
          "type": "string"
        },
        "weight": {
          "description": "Weight of the definition of the new concept where 1='override existing definition entirely' and 0='ignore custom definition'. Note that if the custom concept is not present in the contextionary yet, the weight cannot be less than 1.",
          "type": "number",
          "format": "float"
        }
      }
    },
    "C11yNearestNeighbors": {
      "description": "C11y function to show the nearest neighbors to a word.",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "distance": {
            "type": "number",
            "format": "float"
          },
          "word": {
            "type": "string"
          }
        }
      }
    },
    "C11yVector": {
      "description": "A vector representation of the object in the Contextionary. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "C11yVectorBasedQuestion": {
      "description": "Receive question based on array of classes, properties and values.",
      "type": "array",
      "items": {
        "type": "object",
        "properties": {
          "classProps": {
            "description": "Vectorized properties.",
            "type": "array",
            "maxItems": 300,
            "minItems": 300,
            "items": {
              "type": "object",
              "properties": {
                "propsVectors": {
                  "type": "array",
                  "items": {
                    "type": "number",
                    "format": "float"
                  }
                },
                "value": {
                  "description": "String with valuename.",
                  "type": "string"
                }
              }
            }
          },
          "classVectors": {
            "description": "Vectorized classname.",
            "type": "array",
            "maxItems": 300,
            "minItems": 300,
            "items": {
              "type": "number",
              "format": "float"
            }
          }
        }
      }
    },
    "C11yWordsResponse": {
      "description": "An array of available words and contexts.",
      "properties": {
        "concatenatedWord": {
          "description": "Weighted results for all words",
          "type": "object",
          "properties": {
            "concatenatedNearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "concatenatedVector": {
              "$ref": "#/definitions/C11yVector"
            },
            "concatenatedWord": {
              "type": "string"
            },
            "singleWords": {
              "type": "array",
              "items": {
                "format": "string"
              }
            }
          }
        },
        "individualWords": {
          "description": "Weighted results for per individual word",
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "info": {
                "type": "object",
                "properties": {
                  "nearestNeighbors": {
                    "$ref": "#/definitions/C11yNearestNeighbors"
                  },
                  "vector": {
                    "$ref": "#/definitions/C11yVector"
                  }
                }
              },
              "present": {
                "type": "boolean"
              },
              "word": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "Class": {
      "type": "object",
      "properties": {
        "class": {
          "description": "Name of the class (a.k.a. 'collection') (required). Multiple words should be concatenated in CamelCase, e.g. ` + "`" + `ArticleAuthor` + "`" + `.",
          "type": "string"
        },
        "description": {
          "description": "Description of the collection for metadata purposes.",
          "type": "string"
        },
        "invertedIndexConfig": {
          "$ref": "#/definitions/InvertedIndexConfig"
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "multiTenancyConfig": {
          "$ref": "#/definitions/MultiTenancyConfig"
        },
        "properties": {
          "description": "Define properties of the collection.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Property"
          }
        },
        "replicationConfig": {
          "$ref": "#/definitions/ReplicationConfig"
        },
        "shardingConfig": {
          "description": "Manage how the index should be sharded and distributed in the cluster",
          "type": "object"
        },
        "vectorConfig": {
          "description": "Configure named vectors. Either use this field or ` + "`" + `vectorizer` + "`" + `, ` + "`" + `vectorIndexType` + "`" + `, and ` + "`" + `vectorIndexConfig` + "`" + ` fields. Available from ` + "`" + `v1.24.0` + "`" + `.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/VectorConfig"
          }
        },
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Specify how the vectors for this class should be determined. The options are either 'none' - this means you have to import a vector with each object yourself - or the name of a module that provides vectorization capabilities, such as 'text2vec-contextionary'. If left empty, it will use the globally configured default which can itself either be 'none' or a specific module.",
          "type": "string"
        }
      }
    },
    "Classification": {
      "description": "Manage classifications, trigger them and view status of past classifications.",
      "type": "object",
      "properties": {
        "basedOnProperties": {
          "description": "base the text-based classification on these fields (of type text)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "description"
          ]
        },
        "class": {
          "description": "class (name) which is used in this classification",
          "type": "string",
          "example": "City"
        },
        "classifyProperties": {
          "description": "which ref-property to set as part of the classification",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCountry"
          ]
        },
        "error": {
          "description": "error message if status == failed",
          "type": "string",
          "default": "",
          "example": "classify xzy: something went wrong"
        },
        "filters": {
          "type": "object",
          "properties": {
            "sourceWhere": {
              "description": "limit the objects to be classified",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "targetWhere": {
              "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "trainingSetWhere": {
              "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "id": {
          "description": "ID to uniquely identify this classification run",
          "type": "string",
          "format": "uuid",
          "example": "ee722219-b8ec-4db1-8f8d-5150bb1a9e0c"
        },
        "meta": {
          "description": "additional meta information about the classification",
          "type": "object",
          "$ref": "#/definitions/ClassificationMeta"
        },
        "settings": {
          "description": "classification-type specific settings",
          "type": "object"
        },
        "status": {
          "description": "status of this classification",
          "type": "string",
          "enum": [
            "running",
            "completed",
            "failed"
          ],
          "example": "running"
        },
        "type": {
          "description": "which algorithm to use for classifications",
          "type": "string"
        }
      }
    },
    "ClassificationMeta": {
      "description": "Additional information to a specific classification",
      "type": "object",
      "properties": {
        "completed": {
          "description": "time when this classification finished",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        },
        "count": {
          "description": "number of objects which were taken into consideration for classification",
          "type": "integer",
          "example": 147
        },
        "countFailed": {
          "description": "number of objects which could not be classified - see error message for details",
          "type": "integer",
          "example": 7
        },
        "countSucceeded": {
          "description": "number of objects successfully classified",
          "type": "integer",
          "example": 140
        },
        "started": {
          "description": "time when this classification was started",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        }
      }
    },
    "ClusterStatisticsResponse": {
      "description": "The cluster statistics of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "statistics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Statistics"
          }
        },
        "synchronized": {
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "Deprecation": {
      "type": "object",
      "properties": {
        "apiType": {
          "description": "Describes which API is effected, usually one of: REST, GraphQL",
          "type": "string"
        },
        "id": {
          "description": "The id that uniquely identifies this particular deprecations (mostly used internally)",
          "type": "string"
        },
        "locations": {
          "description": "The locations within the specified API affected by this deprecation",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mitigation": {
          "description": "User-required object to not be affected by the (planned) removal",
          "type": "string"
        },
        "msg": {
          "description": "What this deprecation is about",
          "type": "string"
        },
        "plannedRemovalVersion": {
          "description": "A best-effort guess of which upcoming version will remove the feature entirely",
          "type": "string"
        },
        "removedIn": {
          "description": "If the feature has already been removed, it was removed in this version",
          "type": "string",
          "x-nullable": true
        },
        "removedTime": {
          "description": "If the feature has already been removed, it was removed at this timestamp",
          "type": "string",
          "format": "date-time",
          "x-nullable": true
        },
        "sinceTime": {
          "description": "The deprecation was introduced in this version",
          "type": "string",
          "format": "date-time"
        },
        "sinceVersion": {
          "description": "The deprecation was introduced in this version",
          "type": "string"
        },
        "status": {
          "description": "Whether the problematic API functionality is deprecated (planned to be removed) or already removed",
          "type": "string"
        }
      }
    },
    "ErrorResponse": {
      "description": "An error response given by Weaviate end-points.",
      "type": "object",
      "properties": {
        "error": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "message": {
                "type": "string"
              }
            }
          }
        }
      }
    },
    "GeoCoordinates": {
      "properties": {
        "latitude": {
          "description": "The latitude of the point on earth in decimal form",
          "type": "number",
          "format": "float",
          "x-nullable": true
        },
        "longitude": {
          "description": "The longitude of the point on earth in decimal form",
          "type": "number",
          "format": "float",
          "x-nullable": true
        }
      }
    },
    "GraphQLError": {
      "description": "An error response caused by a GraphQL query.",
      "properties": {
        "locations": {
          "type": "array",
          "items": {
            "type": "object",
            "properties": {
              "column": {
                "type": "integer",
                "format": "int64"
              },
              "line": {
                "type": "integer",
                "format": "int64"
              }
            }
          }
        },
        "message": {
          "type": "string"
        },
        "path": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "GraphQLQueries": {
      "description": "A list of GraphQL queries.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLQuery"
      }
    },
    "GraphQLQuery": {
      "description": "GraphQL query based on: http://facebook.github.io/graphql/.",
      "type": "object",
      "properties": {
        "operationName": {
          "description": "The name of the operation if multiple exist in the query.",
          "type": "string"
        },
        "query": {
          "description": "Query based on GraphQL syntax.",
          "type": "string"
        },
        "variables": {
          "description": "Additional variables for the query.",
          "type": "object"
        }
      }
    },
    "GraphQLResponse": {
      "description": "GraphQL based response: http://facebook.github.io/graphql/.",
      "properties": {
        "data": {
          "description": "GraphQL data object.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/JsonObject"
          }
        },
        "errors": {
          "description": "Array with errors.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLError"
          },
          "x-omitempty": true
        }
      }
    },
    "GraphQLResponses": {
      "description": "A list of GraphQL responses.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLResponse"
      }
    },
    "InvertedIndexConfig": {
      "description": "Configure the inverted index built into Weaviate (default: 60).",
      "type": "object",
      "properties": {
        "bm25": {
          "$ref": "#/definitions/BM25Config"
        },
        "cleanupIntervalSeconds": {
          "description": "Asynchronous index clean up happens every n seconds",
          "type": "number",
          "format": "int"
        },
        "indexNullState": {
          "description": "Index each object with the null state (default: 'false').",
          "type": "boolean"
        },
        "indexPropertyLength": {
          "description": "Index length of properties (default: 'false').",
          "type": "boolean"
        },
        "indexTimestamps": {
          "description": "Index each object by its internal timestamps (default: 'false').",
          "type": "boolean"
        },
        "stopwords": {
          "$ref": "#/definitions/StopwordConfig"
        }
      }
    },
    "JsonObject": {
      "description": "JSON object value.",
      "type": "object"
    },
    "Link": {
      "type": "object",
      "properties": {
        "documentationHref": {
          "description": "weaviate documentation about this resource group",
          "type": "string"
        },
        "href": {
          "description": "target of the link",
          "type": "string"
        },
        "name": {
          "description": "human readable name of the resource group",
          "type": "string"
        },
        "rel": {
          "description": "relationship if both resources are related, e.g. 'next', 'previous', 'parent', etc.",
          "type": "string"
        }
      }
    },
    "Meta": {
      "description": "Contains meta information of the current Weaviate instance.",
      "type": "object",
      "properties": {
        "grpcMaxMessageSize": {
          "description": "Max message size for GRPC connection in bytes.",
          "type": "integer"
        },
        "hostname": {
          "description": "The url of the host.",
          "type": "string",
          "format": "url"
        },
        "modules": {
          "description": "Module-specific meta information.",
          "type": "object"
        },
        "version": {
          "description": "The Weaviate server version.",
          "type": "string"
        }
      }
    },
    "MultiTenancyConfig": {
      "description": "Configuration related to multi-tenancy within a class",
      "properties": {
        "autoTenantActivation": {
          "description": "Existing tenants should (not) be turned HOT implicitly when they are accessed and in another activity status (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "autoTenantCreation": {
          "description": "Nonexistent tenants should (not) be created implicitly (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not multi-tenancy is enabled for this class (default: false).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "MultipleRef": {
      "description": "Multiple instances of references to other objects.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/SingleRef"
      }
    },
    "NestedProperty": {
      "type": "object",
      "properties": {
        "dataType": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "type": "string"
        },
        "indexFilterable": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "type": "boolean",
          "x-nullable": true
        },
        "name": {
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja"
          ]
        }
      }
    },
    "NodeShardStatus": {
      "description": "The definition of a node shard status response body",
      "properties": {
        "class": {
          "description": "The name of shard's class.",
          "type": "string",
          "x-omitempty": false
        },
        "compressed": {
          "description": "The status of vector compression/quantization.",
          "format": "boolean",
          "x-omitempty": false
        },
        "loaded": {
          "description": "The load status of the shard.",
          "type": "boolean",
          "x-omitempty": false
        },
        "name": {
          "description": "The name of the shard.",
          "type": "string",
          "x-omitempty": false
        },
        "objectCount": {
          "description": "The number of objects in shard.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "vectorIndexingStatus": {
          "description": "The status of the vector indexing process.",
          "format": "string",
          "x-omitempty": false
        },
        "vectorQueueLength": {
          "description": "The length of the vector indexing queue.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "NodeStats": {
      "description": "The summary of Weaviate's statistics.",
      "properties": {
        "objectCount": {
          "description": "The total number of objects in DB.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "shardCount": {
          "description": "The count of Weaviate's shards. To see this value, set ` + "`" + `output` + "`" + ` to ` + "`" + `verbose` + "`" + `.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "NodeStatus": {
      "description": "The definition of a backup node status response body",
      "properties": {
        "batchStats": {
          "description": "Weaviate batch statistics.",
          "type": "object",
          "$ref": "#/definitions/BatchStats"
        },
        "gitHash": {
          "description": "The gitHash of Weaviate.",
          "type": "string"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "shards": {
          "description": "The list of the shards with it's statistics.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeShardStatus"
          }
        },
        "stats": {
          "description": "Weaviate overall statistics.",
          "type": "object",
          "$ref": "#/definitions/NodeStats"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        },
        "version": {
          "description": "The version of Weaviate.",
          "type": "string"
        }
      }
    },
    "NodesStatusResponse": {
      "description": "The status of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "nodes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeStatus"
          }
        }
      }
    },
    "Object": {
      "type": "object",
      "properties": {
        "additional": {
          "$ref": "#/definitions/AdditionalProperties"
        },
        "class": {
          "description": "Class of the Object, defined in the schema.",
          "type": "string"
        },
        "creationTimeUnix": {
          "description": "(Response only) Timestamp of creation of this object in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "id": {
          "description": "ID of the Object.",
          "type": "string",
          "format": "uuid"
        },
        "lastUpdateTimeUnix": {
          "description": "(Response only) Timestamp of the last object update in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "properties": {
          "$ref": "#/definitions/PropertySchema"
        },
        "tenant": {
          "description": "Name of the Objects tenant.",
          "type": "string"
        },
        "vector": {
          "description": "This field returns vectors associated with the Object. C11yVector, Vector or Vectors values are possible.",
          "$ref": "#/definitions/C11yVector"
        },
        "vectorWeights": {
          "$ref": "#/definitions/VectorWeights"
        },
        "vectors": {
          "description": "This field returns vectors associated with the Object.",
          "$ref": "#/definitions/Vectors"
        }
      }
    },
    "ObjectsGetResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Object"
        },
        {
          "properties": {
            "deprecations": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Deprecation"
              }
            }
          }
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific Object.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "ObjectsListResponse": {
      "description": "List of Objects.",
      "type": "object",
      "properties": {
        "deprecations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Deprecation"
          }
        },
        "objects": {
          "description": "The actual list of Objects.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Object"
          }
        },
        "totalResults": {
          "description": "The total number of Objects for the query. The number of items in a response may be smaller due to paging.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "PatchDocumentAction": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PatchDocumentObject": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PeerUpdate": {
      "description": "A single peer in the network.",
      "properties": {
        "id": {
          "description": "The session ID of the peer.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Human readable name.",
          "type": "string"
        },
        "schemaHash": {
          "description": "The latest known hash of the peer's schema.",
          "type": "string"
        },
        "uri": {
          "description": "The location where the peer is exposed to the internet.",
          "type": "string",
          "format": "uri"
        }
      }
    },
    "PeerUpdateList": {
      "description": "List of known peers.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/PeerUpdate"
      }
    },
    "Permission": {
      "description": "permissions attached to a role.",
      "type": "object",
      "required": [
        "action"
      ],
      "properties": {
        "action": {
          "description": "allowed actions in weaviate.",
          "type": "string",
          "enum": [
            "manage_backups",
            "read_cluster",
            "manage_data",
            "create_data",
            "read_data",
            "update_data",
            "delete_data",
            "read_nodes",
            "manage_roles",
            "read_roles",
            "manage_collections",
            "create_collections",
            "read_collections",
            "update_collections",
            "delete_collections"
          ]
        },
        "backups": {
          "description": "resources applicable for backup actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "collections": {
          "description": "resources applicable for collection and/or tenant actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "data": {
          "description": "resources applicable for data actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "object": {
              "description": "string or regex. if a specific object ID, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "nodes": {
          "description": "resources applicable for cluster actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "verbosity": {
              "description": "whether to allow (verbose) returning shards and stats data in the response",
              "type": "string",
              "default": "minimal",
              "enum": [
                "verbose",
                "minimal"
              ]
            }
          }
        },
        "roles": {
          "description": "resources applicable for role actions",
          "type": "object",
          "properties": {
            "role": {
              "description": "string or regex. if a specific role name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        }
      }
    },
    "PhoneNumber": {
      "properties": {
        "countryCode": {
          "description": "Read-only. The numerical country code (e.g. 49)",
          "type": "number",
          "format": "uint64"
        },
        "defaultCountry": {
          "description": "Optional. The ISO 3166-1 alpha-2 country code. This is used to figure out the correct countryCode and international format if only a national number (e.g. 0123 4567) is provided",
          "type": "string"
        },
        "input": {
          "description": "The raw input as the phone number is present in your raw data set. It will be parsed into the standardized formats if valid.",
          "type": "string"
        },
        "internationalFormatted": {
          "description": "Read-only. Parsed result in the international format (e.g. +49 123 ...)",
          "type": "string"
        },
        "national": {
          "description": "Read-only. The numerical representation of the national part",
          "type": "number",
          "format": "uint64"
        },
        "nationalFormatted": {
          "description": "Read-only. Parsed result in the national format (e.g. 0123 456789)",
          "type": "string"
        },
        "valid": {
          "description": "Read-only. Indicates whether the parsed number is a valid phone number",
          "type": "boolean"
        }
      }
    },
    "Principal": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "username": {
          "description": "The username that was extracted either from the authentication information",
          "type": "string"
        }
      }
    },
    "Property": {
      "type": "object",
      "properties": {
        "dataType": {
          "description": "Data type of the property (required). If it starts with a capital (for example Person), may be a reference to another type.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "description": "Description of the property.",
          "type": "string"
        },
        "indexFilterable": {
          "description": "Whether to include this property in the filterable, Roaring Bitmap index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters. \u003cbr/\u003e\u003cbr/\u003eNote: Unrelated to vectorization behavior.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexInverted": {
          "description": "(Deprecated). Whether to include this property in the inverted index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters, ` + "`" + `bm25` + "`" + ` or ` + "`" + `hybrid` + "`" + ` search. \u003cbr/\u003e\u003cbr/\u003eUnrelated to vectorization behavior (deprecated as of v1.19; use indexFilterable or/and indexSearchable instead)",
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "description": "Whether to include this property in the filterable, range-based Roaring Bitmap index. Provides better performance for range queries compared to filterable index in large datasets. Applicable only to properties of data type int, number, date.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "description": "Optional. Should this property be indexed in the inverted index. Defaults to true. Applicable only to properties of data type text and text[]. If you choose false, you will not be able to use this property in bm25 or hybrid search. This property has no affect on vectorization decisions done by modules",
          "type": "boolean",
          "x-nullable": true
        },
        "moduleConfig": {
          "description": "Configuration specific to modules this Weaviate instance has installed",
          "type": "object"
        },
        "name": {
          "description": "The name of the property (required). Multiple words should be concatenated in camelCase, e.g. ` + "`" + `nameOfAuthor` + "`" + `.",
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "description": "Determines tokenization of the property as separate words or whole field. Optional. Applies to text and text[] data types. Allowed values are ` + "`" + `word` + "`" + ` (default; splits on any non-alphanumerical, lowercases), ` + "`" + `lowercase` + "`" + ` (splits on white spaces, lowercases), ` + "`" + `whitespace` + "`" + ` (splits on white spaces), ` + "`" + `field` + "`" + ` (trims). Not supported for remaining data types",
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja"
          ]
        }
      }
    },
    "PropertySchema": {
      "description": "Names and values of an individual property. A returned response may also contain additional metadata, such as from classification or feature projection.",
      "type": "object"
    },
    "RaftStatistics": {
      "description": "The definition of Raft statistics.",
      "properties": {
        "appliedIndex": {
          "type": "string"
        },
        "commitIndex": {
          "type": "string"
        },
        "fsmPending": {
          "type": "string"
        },
        "lastContact": {
          "type": "string"
        },
        "lastLogIndex": {
          "type": "string"
        },
        "lastLogTerm": {
          "type": "string"
        },
        "lastSnapshotIndex": {
          "type": "string"
        },
        "lastSnapshotTerm": {
          "type": "string"
        },
        "latestConfiguration": {
          "description": "Weaviate Raft nodes.",
          "type": "object"
        },
        "latestConfigurationIndex": {
          "type": "string"
        },
        "numPeers": {
          "type": "string"
        },
        "protocolVersion": {
          "type": "string"
        },
        "protocolVersionMax": {
          "type": "string"
        },
        "protocolVersionMin": {
          "type": "string"
        },
        "snapshotVersionMax": {
          "type": "string"
        },
        "snapshotVersionMin": {
          "type": "string"
        },
        "state": {
          "type": "string"
        },
        "term": {
          "type": "string"
        }
      }
    },
    "ReferenceMetaClassification": {
      "description": "This meta field contains additional info about the classified reference property",
      "properties": {
        "closestLosingDistance": {
          "description": "The lowest distance of a neighbor in the losing group. Optional. If k equals the size of the winning group, there is no losing group",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "closestOverallDistance": {
          "description": "The lowest distance of any neighbor, regardless of whether they were in the winning or losing group",
          "type": "number",
          "format": "float32"
        },
        "closestWinningDistance": {
          "description": "Closest distance of a neighbor from the winning group",
          "type": "number",
          "format": "float32"
        },
        "losingCount": {
          "description": "size of the losing group, can be 0 if the winning group size equals k",
          "type": "number",
          "format": "int64"
        },
        "losingDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanLosingDistance": {
          "description": "Mean distance of all neighbors from the losing group. Optional. If k equals the size of the winning group, there is no losing group.",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanWinningDistance": {
          "description": "Mean distance of all neighbors from the winning group",
          "type": "number",
          "format": "float32"
        },
        "overallCount": {
          "description": "overall neighbors checked as part of the classification. In most cases this will equal k, but could be lower than k - for example if not enough data was present",
          "type": "number",
          "format": "int64"
        },
        "winningCount": {
          "description": "size of the winning group, a number between 1..k",
          "type": "number",
          "format": "int64"
        },
        "winningDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32"
        }
      }
    },
    "ReplicationConfig": {
      "description": "Configure how replication is executed in a cluster",
      "type": "object",
      "properties": {
        "asyncEnabled": {
          "description": "Enable asynchronous replication (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "deletionStrategy": {
          "description": "Conflict resolution strategy for deleted objects.",
          "type": "string",
          "enum": [
            "NoAutomatedResolution",
            "DeleteOnConflict",
            "TimeBasedResolution"
          ],
          "x-omitempty": true
        },
        "factor": {
          "description": "Number of times a class is replicated (default: 1).",
          "type": "integer"
        }
      }
    },
    "RestoreConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path within the bucket",
          "type": "string"
        }
      }
    },
    "Role": {
      "type": "object",
      "required": [
        "name",
        "permissions"
      ],
      "properties": {
        "name": {
          "description": "role name",
          "type": "string"
        },
        "permissions": {
          "type": "array",
          "items": {
            "description": "list of permissions (level, action, resource)",
            "type": "object",
            "$ref": "#/definitions/Permission"
          }
        }
      }
    },
    "RolesListResponse": {
      "description": "list of roles",
      "type": "array",
      "items": {
        "$ref": "#/definitions/Role"
      }
    },
    "Schema": {
      "description": "Definitions of semantic schemas (also see: https://github.com/weaviate/weaviate-semantic-schemas).",
      "type": "object",
      "properties": {
        "classes": {
          "description": "Semantic classes that are available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Class"
          }
        },
        "maintainer": {
          "description": "Email of the maintainer.",
          "type": "string",
          "format": "email"
        },
        "name": {
          "description": "Name of the schema.",
          "type": "string"
        }
      }
    },
    "SchemaClusterStatus": {
      "description": "Indicates the health of the schema in a cluster.",
      "type": "object",
      "properties": {
        "error": {
          "description": "Contains the sync check error if one occurred",
          "type": "string",
          "x-omitempty": true
        },
        "healthy": {
          "description": "True if the cluster is in sync, false if there is an issue (see error).",
          "type": "boolean",
          "x-omitempty": false
        },
        "hostname": {
          "description": "Hostname of the coordinating node, i.e. the one that received the cluster. This can be useful information if the error message contains phrases such as 'other nodes agree, but local does not', etc.",
          "type": "string"
        },
        "ignoreSchemaSync": {
          "description": "The cluster check at startup can be ignored (to recover from an out-of-sync situation).",
          "type": "boolean",
          "x-omitempty": false
        },
        "nodeCount": {
          "description": "Number of nodes that participated in the sync check",
          "type": "number",
          "format": "int"
        }
      }
    },
    "SchemaHistory": {
      "description": "This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value OR a SingleRef definition.",
      "type": "object"
    },
    "ShardStatus": {
      "description": "The status of a single shard",
      "properties": {
        "status": {
          "description": "Status of the shard",
          "type": "string"
        }
      }
    },
    "ShardStatusGetResponse": {
      "description": "Response body of shard status get request",
      "properties": {
        "name": {
          "description": "Name of the shard",
          "type": "string"
        },
        "status": {
          "description": "Status of the shard",
          "type": "string"
        },
        "vectorQueueSize": {
          "description": "Size of the vector queue of the shard",
          "type": "integer",
          "x-omitempty": false
        }
      }
    },
    "ShardStatusList": {
      "description": "The status of all the shards of a Class",
      "type": "array",
      "items": {
        "$ref": "#/definitions/ShardStatusGetResponse"
      }
    },
    "SingleRef": {
      "description": "Either set beacon (direct reference) or set class and schema (concept reference)",
      "properties": {
        "beacon": {
          "description": "If using a direct reference, specify the URI to point to the cross-ref here. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-ref to an object",
          "type": "string",
          "format": "uri"
        },
        "class": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired class name here",
          "type": "string",
          "format": "uri"
        },
        "classification": {
          "description": "Additional Meta information about classifications if the item was part of one",
          "$ref": "#/definitions/ReferenceMetaClassification"
        },
        "href": {
          "description": "If using a direct reference, this read-only fields provides a link to the referenced resource. If 'origin' is globally configured, an absolute URI is shown - a relative URI otherwise.",
          "type": "string",
          "format": "uri"
        },
        "schema": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired properties here",
          "$ref": "#/definitions/PropertySchema"
        }
      }
    },
    "Statistics": {
      "description": "The definition of node statistics.",
      "properties": {
        "bootstrapped": {
          "type": "boolean"
        },
        "candidates": {
          "type": "object"
        },
        "dbLoaded": {
          "type": "boolean"
        },
        "initialLastAppliedIndex": {
          "type": "number",
          "format": "uint64"
        },
        "isVoter": {
          "type": "boolean"
        },
        "lastAppliedIndex": {
          "type": "number"
        },
        "leaderAddress": {
          "type": "object"
        },
        "leaderId": {
          "type": "object"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "open": {
          "type": "boolean"
        },
        "raft": {
          "description": "Weaviate Raft statistics.",
          "type": "object",
          "$ref": "#/definitions/RaftStatistics"
        },
        "ready": {
          "type": "boolean"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        }
      }
    },
    "StopwordConfig": {
      "description": "fine-grained control over stopword list usage",
      "type": "object",
      "properties": {
        "additions": {
          "description": "Stopwords to be considered additionally (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "preset": {
          "description": "Pre-existing list of common words by language (default: 'en'). Options: ['en', 'none'].",
          "type": "string"
        },
        "removals": {
          "description": "Stopwords to be removed from consideration (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "Tenant": {
      "description": "attributes representing a single tenant within weaviate",
      "type": "object",
      "properties": {
        "activityStatus": {
          "description": "activity status of the tenant's shard. Optional for creating tenant (implicit ` + "`" + `ACTIVE` + "`" + `) and required for updating tenant. For creation, allowed values are ` + "`" + `ACTIVE` + "`" + ` - tenant is fully active and ` + "`" + `INACTIVE` + "`" + ` - tenant is inactive; no actions can be performed on tenant, tenant's files are stored locally. For updating, ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + ` and also ` + "`" + `OFFLOADED` + "`" + ` - as INACTIVE, but files are stored on cloud storage. The following values are read-only and are set by the server for internal use: ` + "`" + `OFFLOADING` + "`" + ` - tenant is transitioning from ACTIVE/INACTIVE to OFFLOADED, ` + "`" + `ONLOADING` + "`" + ` - tenant is transitioning from OFFLOADED to ACTIVE/INACTIVE. We still accept deprecated names ` + "`" + `HOT` + "`" + ` (now ` + "`" + `ACTIVE` + "`" + `), ` + "`" + `COLD` + "`" + ` (now ` + "`" + `INACTIVE` + "`" + `), ` + "`" + `FROZEN` + "`" + ` (now ` + "`" + `OFFLOADED` + "`" + `), ` + "`" + `FREEZING` + "`" + ` (now ` + "`" + `OFFLOADING` + "`" + `), ` + "`" + `UNFREEZING` + "`" + ` (now ` + "`" + `ONLOADING` + "`" + `).",
          "type": "string",
          "enum": [
            "ACTIVE",
            "INACTIVE",
            "OFFLOADED",
            "OFFLOADING",
            "ONLOADING",
            "HOT",
            "COLD",
            "FROZEN",
            "FREEZING",
            "UNFREEZING"
          ]
        },
        "name": {
          "description": "The name of the tenant (required).",
          "type": "string"
        }
      }
    },
    "TenantResponse": {
      "description": "attributes representing a single tenant response within weaviate",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Tenant"
        },
        {
          "properties": {
            "belongsToNodes": {
              "description": "The list of nodes that owns that tenant data.",
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "dataVersion": {
              "description": "Experimental. The data version of the tenant is a monotonically increasing number starting from 0 which is incremented each time a tenant's data is offloaded to cloud storage.",
              "type": "integer",
              "default": 0,
              "x-nullable": true,
              "example": 3
            }
          }
        }
      ]
    },
    "Vector": {
      "description": "A vector representation of the object. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "VectorConfig": {
      "type": "object",
      "properties": {
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Configuration of a specific vectorizer used by this vector",
          "type": "object"
        }
      }
    },
    "VectorWeights": {
      "description": "Allow custom overrides of vector weights as math expressions. E.g. \"pancake\": \"7\" will set the weight for the word pancake to 7 in the vectorization, whereas \"w * 3\" would triple the originally calculated word. This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value (string/string) object.",
      "type": "object"
    },
    "Vectors": {
      "description": "A map of named vectors for multi-vector representations.",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/Vector"
      }
    },
    "WhereFilter": {
      "description": "Filter search results using a where filter",
      "type": "object",
      "properties": {
        "operands": {
          "description": "combine multiple where filters, requires 'And' or 'Or' operator",
          "type": "array",
          "items": {
            "$ref": "#/definitions/WhereFilter"
          }
        },
        "operator": {
          "description": "operator to use",
          "type": "string",
          "enum": [
            "And",
            "Or",
            "Equal",
            "Like",
            "NotEqual",
            "GreaterThan",
            "GreaterThanEqual",
            "LessThan",
            "LessThanEqual",
            "WithinGeoRange",
            "IsNull",
            "ContainsAny",
            "ContainsAll"
          ],
          "example": "GreaterThanEqual"
        },
        "path": {
          "description": "path to the property currently being filtered",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCity",
            "City",
            "name"
          ]
        },
        "valueBoolean": {
          "description": "value as boolean",
          "type": "boolean",
          "x-nullable": true,
          "example": false
        },
        "valueBooleanArray": {
          "description": "value as boolean",
          "type": "array",
          "items": {
            "type": "boolean"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            true,
            false
          ]
        },
        "valueDate": {
          "description": "value as date (as string)",
          "type": "string",
          "x-nullable": true,
          "example": "TODO"
        },
        "valueDateArray": {
          "description": "value as date (as string)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "TODO"
        },
        "valueGeoRange": {
          "description": "value as geo coordinates and distance",
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/WhereFilterGeoRange"
        },
        "valueInt": {
          "description": "value as integer",
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "example": 2000
        },
        "valueIntArray": {
          "description": "value as integer",
          "type": "array",
          "items": {
            "type": "integer",
            "format": "int64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "[100, 200]"
        },
        "valueNumber": {
          "description": "value as number/float",
          "type": "number",
          "format": "float64",
          "x-nullable": true,
          "example": 3.14
        },
        "valueNumberArray": {
          "description": "value as number/float",
          "type": "array",
          "items": {
            "type": "number",
            "format": "float64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            3.14
          ]
        },
        "valueString": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueStringArray": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        },
        "valueText": {
          "description": "value as text",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueTextArray": {
          "description": "value as text",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        }
      }
    },
    "WhereFilterGeoRange": {
      "description": "filter within a distance of a georange",
      "type": "object",
      "properties": {
        "distance": {
          "type": "object",
          "properties": {
            "max": {
              "type": "number",
              "format": "float64"
            }
          }
        },
        "geoCoordinates": {
          "x-nullable": false,
          "$ref": "#/definitions/GeoCoordinates"
        }
      }
    }
  },
  "parameters": {
    "CommonAfterParameterQuery": {
      "type": "string",
      "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with ` + "`" + `class` + "`" + `, typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
      "name": "after",
      "in": "query"
    },
    "CommonClassParameterQuery": {
      "type": "string",
      "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if ` + "`" + `class` + "`" + ` is not provided, the response will not include any objects.",
      "name": "class",
      "in": "query"
    },
    "CommonConsistencyLevelParameterQuery": {
      "type": "string",
      "description": "Determines how many replicas must acknowledge a request before it is considered successful",
      "name": "consistency_level",
      "in": "query"
    },
    "CommonIncludeParameterQuery": {
      "type": "string",
      "description": "Include additional information, such as classification infos. Allowed values include: classification, vector, interpretation",
      "name": "include",
      "in": "query"
    },
    "CommonLimitParameterQuery": {
      "type": "integer",
      "format": "int64",
      "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
      "name": "limit",
      "in": "query"
    },
    "CommonNodeNameParameterQuery": {
      "type": "string",
      "description": "The target node which should fulfill the request",
      "name": "node_name",
      "in": "query"
    },
    "CommonOffsetParameterQuery": {
      "type": "integer",
      "format": "int64",
      "default": 0,
      "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
      "name": "offset",
      "in": "query"
    },
    "CommonOrderParameterQuery": {
      "type": "string",
      "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
      "name": "order",
      "in": "query"
    },
    "CommonOutputVerbosityParameterQuery": {
      "type": "string",
      "default": "minimal",
      "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
      "name": "output",
      "in": "query"
    },
    "CommonSortParameterQuery": {
      "type": "string",
      "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
      "name": "sort",
      "in": "query"
    },
    "CommonTenantParameterQuery": {
      "type": "string",
      "description": "Specifies the tenant in a request targeting a multi-tenant class",
      "name": "tenant",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "oidc": {
      "description": "OIDC (OpenConnect ID - based on OAuth2)",
      "type": "oauth2",
      "flow": "implicit",
      "authorizationUrl": "http://to-be-configured-in-the-application-config"
    }
  },
  "security": [
    {},
    {
      "oidc": []
    }
  ],
  "tags": [
    {
      "name": "objects"
    },
    {
      "description": "These operations allow to execute batch requests for Objects and Objects. Mostly used for importing large datasets.",
      "name": "batch"
    },
    {
      "name": "graphql"
    },
    {
      "name": "meta"
    },
    {
      "name": "P2P"
    },
    {
      "description": "All functions related to the Contextionary.",
      "name": "contextionary-API"
    },
    {
      "description": "These operations enable manipulation of the schema in Weaviate schema.",
      "name": "schema"
    }
  ],
  "externalDocs": {
    "url": "https://github.com/weaviate/weaviate"
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "consumes": [
    "application/json",
    "application/yaml"
  ],
  "produces": [
    "application/json"
  ],
  "schemes": [
    "https"
  ],
  "swagger": "2.0",
  "info": {
    "description": "# Introduction\n Weaviate is an open source, AI-native vector database that helps developers create intuitive and reliable AI-powered applications. \n ### Base Path \nThe base path for the Weaviate server is structured as ` + "`" + `[YOUR-WEAVIATE-HOST]:[PORT]/v1` + "`" + `. As an example, if you wish to access the ` + "`" + `schema` + "`" + ` endpoint on a local instance, you would navigate to ` + "`" + `http://localhost:8080/v1/schema` + "`" + `. Ensure you replace ` + "`" + `[YOUR-WEAVIATE-HOST]` + "`" + ` and ` + "`" + `[PORT]` + "`" + ` with your actual server host and port number respectively. \n ### Questions? \nIf you have any comments or questions, please feel free to reach out to us at the community forum [https://forum.weaviate.io/](https://forum.weaviate.io/). \n### Issues? \nIf you find a bug or want to file a feature request, please open an issue on our GitHub repository for [Weaviate](https://github.com/weaviate/weaviate). \n### Want more documentation? \nFor a quickstart, code examples, concepts and more, please visit our [documentation page](https://weaviate.io/developers/weaviate).",
    "title": "Weaviate",
    "contact": {
      "name": "Weaviate",
      "url": "https://github.com/weaviate",
      "email": "hello@weaviate.io"
    },
    "version": "1.28.0-rc.0"
  },
  "basePath": "/v1",
  "paths": {
    "/": {
      "get": {
        "description": "Get links to other endpoints to help discover the REST API",
        "summary": "List available endpoints",
        "operationId": "weaviate.root",
        "responses": {
          "200": {
            "description": "Weaviate is alive and ready to serve content",
            "schema": {
              "type": "object",
              "properties": {
                "links": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Link"
                  }
                }
              }
            }
          }
        }
      }
    },
    "/.well-known/live": {
      "get": {
        "description": "Determines whether the application is alive. Can be used for kubernetes liveness probe",
        "summary": "Get application liveness.",
        "operationId": "weaviate.wellknown.liveness",
        "responses": {
          "200": {
            "description": "The application is able to respond to HTTP requests"
          }
        }
      }
    },
    "/.well-known/openid-configuration": {
      "get": {
        "description": "OIDC Discovery page, redirects to the token issuer if one is configured",
        "tags": [
          "well-known",
          "oidc",
          "discovery"
        ],
        "summary": "OIDC discovery information if OIDC auth is enabled",
        "responses": {
          "200": {
            "description": "Successful response, inspect body",
            "schema": {
              "type": "object",
              "properties": {
                "clientId": {
                  "description": "OAuth Client ID",
                  "type": "string"
                },
                "href": {
                  "description": "The Location to redirect to",
                  "type": "string"
                },
                "scopes": {
                  "description": "OAuth Scopes",
                  "type": "array",
                  "items": {
                    "type": "string"
                  },
                  "x-omitempty": true
                }
              }
            }
          },
          "404": {
            "description": "Not found, no oidc provider present"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false
      }
    },
    "/.well-known/ready": {
      "get": {
        "description": "Determines whether the application is ready to receive traffic. Can be used for kubernetes readiness probe.",
        "summary": "Get application readiness.",
        "operationId": "weaviate.wellknown.readiness",
        "responses": {
          "200": {
            "description": "The application has completed its start-up routine and is ready to accept traffic."
          },
          "503": {
            "description": "The application is currently not able to serve traffic. If other horizontal replicas of weaviate are available and they are capable of receiving traffic, all traffic should be redirected there instead."
          }
        }
      }
    },
    "/authz/roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "Get all roles",
        "operationId": "getRoles",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles"
        ]
      },
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "create new role",
        "operationId": "createRole",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Role"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Role created successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "409": {
            "description": "Role already exists",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.create.role"
        ]
      }
    },
    "/authz/roles/add-permissions": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Add permission to a role as an upsert. If the role doesn't exist then it will be created.",
        "operationId": "addPermissions",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "name": {
                  "description": "role name",
                  "type": "string"
                },
                "permissions": {
                  "description": "permissions to be added to the role",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions added successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.add.role.permissions"
        ]
      }
    },
    "/authz/roles/remove-permissions": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Remove permissions from a role. If this results in an empty role, the role will be deleted.",
        "operationId": "removePermissions",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "required": [
                "name",
                "permissions"
              ],
              "properties": {
                "name": {
                  "description": "role name",
                  "type": "string"
                },
                "permissions": {
                  "description": "permissions to remove from the role",
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Permission"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Permissions removed successfully"
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.remove.role.permissions"
        ]
      }
    },
    "/authz/roles/{id}": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "Get a role",
        "operationId": "getRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Role"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.role"
        ]
      },
      "delete": {
        "tags": [
          "authz"
        ],
        "summary": "Delete role",
        "operationId": "deleteRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.delete.role"
        ]
      }
    },
    "/authz/roles/{id}/users": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get users or a keys assigned to role",
        "operationId": "getUsersForRole",
        "parameters": [
          {
            "type": "string",
            "description": "role ID",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users assigned to this role",
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found for user"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.roles.users"
        ]
      }
    },
    "/authz/users/own-roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get roles assigned to own user",
        "operationId": "getRolesForOwnUser",
        "responses": {
          "200": {
            "description": "Role assigned to own users",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.own-roles"
        ]
      }
    },
    "/authz/users/{id}/assign": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Assign a role to a user",
        "operationId": "assignRole",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "properties": {
                "roles": {
                  "description": "the roles that assigned to user",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned successfully"
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "role or user is not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.assign.role"
        ]
      }
    },
    "/authz/users/{id}/revoke": {
      "post": {
        "tags": [
          "authz"
        ],
        "summary": "Revoke a role from a user",
        "operationId": "revokeRole",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "properties": {
                "roles": {
                  "description": "the roles that revoked from the key or user",
                  "type": "array",
                  "items": {
                    "type": "string"
                  }
                }
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Role revoked successfully"
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "role or user is not found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.revoke.role"
        ]
      }
    },
    "/authz/users/{id}/roles": {
      "get": {
        "tags": [
          "authz"
        ],
        "summary": "get roles assigned to user",
        "operationId": "getRolesForUser",
        "parameters": [
          {
            "type": "string",
            "description": "user name",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Role assigned users",
            "schema": {
              "$ref": "#/definitions/RolesListResponse"
            }
          },
          "400": {
            "description": "Bad request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "no role found for user"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.authz.get.users.roles"
        ]
      }
    },
    "/backups/{backend}": {
      "get": {
        "description": "[Coming soon] List all backups in progress not implemented yet.",
        "tags": [
          "backups"
        ],
        "summary": "List backups in progress",
        "operationId": "backups.list",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Existed backups",
            "schema": {
              "$ref": "#/definitions/BackupListResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup list.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Start creating a backup for a set of collections. \u003cbr/\u003e\u003cbr/\u003eNotes: \u003cbr/\u003e- Weaviate uses gzip compression by default. \u003cbr/\u003e- Weaviate stays usable while a backup process is ongoing.",
        "tags": [
          "backups"
        ],
        "summary": "Start a backup process",
        "operationId": "backups.create",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupCreateRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup create process successfully started.",
            "schema": {
              "$ref": "#/definitions/BackupCreateResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup creation attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}": {
      "get": {
        "description": "Returns status of backup creation attempt for a set of collections. \u003cbr/\u003e\u003cbr/\u003eAll client implementations have a ` + "`" + `wait for completion` + "`" + ` option which will poll the backup status in the background and only return once the backup has completed (successfully or unsuccessfully). If you set the ` + "`" + `wait for completion` + "`" + ` option to false, you can also check the status yourself using this endpoint.",
        "tags": [
          "backups"
        ],
        "summary": "Get backup process status",
        "operationId": "backups.create.status",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Backup creation status successfully returned",
            "schema": {
              "$ref": "#/definitions/BackupCreateStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "delete": {
        "description": "Cancel created backup with specified ID",
        "tags": [
          "backups"
        ],
        "summary": "Cancel backup",
        "operationId": "backups.cancel",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. filesystem, gcs, s3.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup cancellation attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/backups/{backend}/{id}/restore": {
      "get": {
        "description": "Returns status of a backup restoration attempt for a set of classes. \u003cbr/\u003e\u003cbr/\u003eAll client implementations have a ` + "`" + `wait for completion` + "`" + ` option which will poll the backup status in the background and only return once the backup has completed (successfully or unsuccessfully). If you set the ` + "`" + `wait for completion` + "`" + ` option to false, you can also check the status yourself using the this endpoint.",
        "tags": [
          "backups"
        ],
        "summary": "Get restore process status",
        "operationId": "backups.restore.status",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Name of the bucket, container, volume, etc",
            "name": "bucket",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The path within the bucket",
            "name": "path",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration status successfully returned",
            "schema": {
              "$ref": "#/definitions/BackupRestoreStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      },
      "post": {
        "description": "Starts a process of restoring a backup for a set of collections. \u003cbr/\u003e\u003cbr/\u003eAny backup can be restored to any machine, as long as the number of nodes between source and target are identical.\u003cbr/\u003e\u003cbr/\u003eRequrements:\u003cbr/\u003e\u003cbr/\u003e- None of the collections to be restored already exist on the target restoration node(s).\u003cbr/\u003e- The node names of the backed-up collections' must match those of the target restoration node(s).",
        "tags": [
          "backups"
        ],
        "summary": "Start a restoration process",
        "operationId": "backups.restore",
        "parameters": [
          {
            "type": "string",
            "description": "Backup backend name e.g. ` + "`" + `filesystem` + "`" + `, ` + "`" + `gcs` + "`" + `, ` + "`" + `s3` + "`" + `, ` + "`" + `azure` + "`" + `.",
            "name": "backend",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "The ID of a backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BackupRestoreRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Backup restoration process successfully started.",
            "schema": {
              "$ref": "#/definitions/BackupRestoreResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.backup"
        ]
      }
    },
    "/batch/objects": {
      "post": {
        "description": "Create new objects in bulk. \u003cbr/\u003e\u003cbr/\u003eMeta-data and schema values are validated. \u003cbr/\u003e\u003cbr/\u003e**Note: idempotence of ` + "`" + `/batch/objects` + "`" + `**: \u003cbr/\u003e` + "`" + `POST /batch/objects` + "`" + ` is idempotent, and will overwrite any existing object given the same id.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Creates new Objects based on a Object template as a batch.",
        "operationId": "batch.objects.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "object",
              "properties": {
                "fields": {
                  "description": "Define which fields need to be returned. Default value is ALL",
                  "type": "array",
                  "items": {
                    "type": "string",
                    "default": "ALL",
                    "enum": [
                      "ALL",
                      "class",
                      "schema",
                      "id",
                      "creationTimeUnix"
                    ]
                  }
                },
                "objects": {
                  "type": "array",
                  "items": {
                    "$ref": "#/definitions/Object"
                  }
                }
              }
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request succeeded, see response body to get detailed information about each batched item.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/ObjectsGetResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      },
      "delete": {
        "description": "Batch delete objects that match a particular filter. \u003cbr/\u003e\u003cbr/\u003eThe request body takes a single ` + "`" + `where` + "`" + ` filter and will delete all objects matched. \u003cbr/\u003e\u003cbr/\u003eNote that there is a limit to the number of objects to be deleted at once using this filter, in order to protect against unexpected memory surges and very-long-running requests. The default limit is 10,000 and may be configured by setting the ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + ` environment variable. \u003cbr/\u003e\u003cbr/\u003eObjects are deleted in the same order that they would be returned in an equivalent Get query. To delete more objects than the limit, run the same query multiple times.",
        "tags": [
          "batch",
          "objects"
        ],
        "summary": "Deletes Objects based on a match filter as a batch.",
        "operationId": "batch.objects.delete",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/BatchDelete"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request succeeded, see response body to get detailed information about each batched item.",
            "schema": {
              "$ref": "#/definitions/BatchDeleteResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/batch/references": {
      "post": {
        "description": "Batch create cross-references between collections items (objects or objects) in bulk.",
        "tags": [
          "batch",
          "references"
        ],
        "summary": "Creates new Cross-References between arbitrary classes in bulk.",
        "operationId": "batch.references.create",
        "parameters": [
          {
            "description": "A list of references to be batched. The ideal size depends on the used database connector. Please see the documentation of the used connector for help",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReference"
              }
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Request Successful. Warning: A successful request does not guarantee that every batched reference was successfully created. Inspect the response body to see which references succeeded and which failed.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchReferenceResponse"
              }
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/classifications/": {
      "post": {
        "description": "Trigger a classification based on the specified params. Classifications will run in the background, use GET /classifications/\u003cid\u003e to retrieve the status of your classification.",
        "tags": [
          "classifications"
        ],
        "summary": "Starts a classification.",
        "operationId": "classifications.post",
        "parameters": [
          {
            "description": "parameters to start a classification",
            "name": "params",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Successfully started classification.",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "400": {
            "description": "Incorrect request",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.post"
        ]
      }
    },
    "/classifications/{id}": {
      "get": {
        "description": "Get status, results and metadata of a previously created classification",
        "tags": [
          "classifications"
        ],
        "summary": "View previously created classification",
        "operationId": "classifications.get",
        "parameters": [
          {
            "type": "string",
            "description": "classification id",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Found the classification, returned as body",
            "schema": {
              "$ref": "#/definitions/Classification"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Classification does not exist"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.classifications.get"
        ]
      }
    },
    "/cluster/statistics": {
      "get": {
        "description": "Returns Raft cluster statistics of Weaviate DB.",
        "tags": [
          "cluster"
        ],
        "summary": "See Raft cluster statistics",
        "operationId": "cluster.get.statistics",
        "responses": {
          "200": {
            "description": "Cluster statistics successfully returned",
            "schema": {
              "$ref": "#/definitions/ClusterStatisticsResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.cluster.statistics.get"
        ]
      }
    },
    "/graphql": {
      "post": {
        "description": "Get a response based on a GraphQL query",
        "tags": [
          "graphql"
        ],
        "summary": "Get a response based on GraphQL",
        "operationId": "graphql.post",
        "parameters": [
          {
            "description": "The GraphQL query request parameters.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQuery"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successful query (with select).",
            "schema": {
              "$ref": "#/definitions/GraphQLResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/graphql/batch": {
      "post": {
        "description": "Perform a batched GraphQL query",
        "tags": [
          "graphql"
        ],
        "summary": "Get a response based on GraphQL.",
        "operationId": "graphql.batch",
        "parameters": [
          {
            "description": "The GraphQL queries.",
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/GraphQLQueries"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successful query (with select).",
            "schema": {
              "$ref": "#/definitions/GraphQLResponses"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query",
          "weaviate.local.query.meta",
          "weaviate.network.query",
          "weaviate.network.query.meta"
        ]
      }
    },
    "/meta": {
      "get": {
        "description": "Returns meta information about the server. Can be used to provide information to another Weaviate instance that wants to interact with the current instance.",
        "tags": [
          "meta"
        ],
        "summary": "Returns meta information of the current Weaviate instance.",
        "operationId": "meta.get",
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Meta"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/nodes": {
      "get": {
        "description": "Returns node information for the entire database.",
        "tags": [
          "nodes"
        ],
        "summary": "Node information for the database.",
        "operationId": "nodes.get",
        "parameters": [
          {
            "type": "string",
            "default": "minimal",
            "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
            "name": "output",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Nodes status successfully returned",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get"
        ]
      }
    },
    "/nodes/{className}": {
      "get": {
        "description": "Returns node information for the nodes relevant to the collection.",
        "tags": [
          "nodes"
        ],
        "summary": "Node information for a collection.",
        "operationId": "nodes.get.class",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "default": "minimal",
            "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
            "name": "output",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Nodes status successfully returned",
            "schema": {
              "$ref": "#/definitions/NodesStatusResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Not Found - Backup does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid backup restoration status attempt.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.nodes.status.get.class"
        ]
      }
    },
    "/objects": {
      "get": {
        "description": "Lists all Objects in reverse order of creation, owned by the user that belongs to the used token.",
        "tags": [
          "objects"
        ],
        "summary": "Get a list of Objects.",
        "operationId": "objects.list",
        "parameters": [
          {
            "type": "string",
            "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with ` + "`" + `class` + "`" + `, typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
            "name": "after",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "default": 0,
            "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
            "name": "offset",
            "in": "query"
          },
          {
            "type": "integer",
            "format": "int64",
            "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
            "name": "limit",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification infos. Allowed values include: classification, vector, interpretation",
            "name": "include",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
            "name": "sort",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
            "name": "order",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if ` + "`" + `class` + "`" + ` is not provided, the response will not include any objects.",
            "name": "class",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response. \u003cbr/\u003e\u003cbr/\u003eIf ` + "`" + `class` + "`" + ` is not provided, the response will not include any objects.",
            "schema": {
              "$ref": "#/definitions/ObjectsListResponse"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "post": {
        "description": "Create a new object. \u003cbr/\u003e\u003cbr/\u003eMeta-data and schema values are validated. \u003cbr/\u003e\u003cbr/\u003e**Note: Use ` + "`" + `/batch` + "`" + ` for importing many objects**: \u003cbr/\u003eIf you plan on importing a large number of objects, it's much more efficient to use the ` + "`" + `/batch` + "`" + ` endpoint. Otherwise, sending multiple single requests sequentially would incur a large performance penalty. \u003cbr/\u003e\u003cbr/\u003e**Note: idempotence of ` + "`" + `/objects` + "`" + `**: \u003cbr/\u003ePOST /objects will fail if an id is provided which already exists in the class. To update an existing object with the objects endpoint, use the PUT or PATCH method.",
        "tags": [
          "objects"
        ],
        "summary": "Create a new object.",
        "operationId": "objects.create",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Object created.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.add"
        ]
      }
    },
    "/objects/validate": {
      "post": {
        "description": "Validate an object's schema and meta-data without creating it. \u003cbr/\u003e\u003cbr/\u003eIf the schema of the object is valid, the request should return nothing with a plain RESTful request. Otherwise, an error object will be returned.",
        "tags": [
          "objects"
        ],
        "summary": "Validate an Object based on a schema.",
        "operationId": "objects.validate",
        "parameters": [
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully validated."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      }
    },
    "/objects/{className}/{id}": {
      "get": {
        "description": "Get a data object based on its collection and UUID. Also available as Websocket bus.",
        "tags": [
          "objects"
        ],
        "summary": "Get a specific Object based on its class and UUID. Also available as Websocket bus.",
        "operationId": "objects.class.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification infos. Allowed values include: classification, vector, interpretation",
            "name": "include",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "The target node which should fulfill the request",
            "name": "node_name",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Update an object based on its uuid and collection. This (` + "`" + `put` + "`" + `) method replaces the object with the provided object.",
        "tags": [
          "objects"
        ],
        "summary": "Update a class object based on its uuid",
        "operationId": "objects.class.put",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object to update.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully received.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete an object based on its collection and UUID. \u003cbr/\u003e\u003cbr/\u003eNote: For backward compatibility, beacons also support an older, deprecated format without the collection name. As a result, when deleting a reference, the beacon specified has to match the beacon to be deleted exactly. In other words, if a beacon is present using the old format (without collection name) you also need to specify it the same way. \u003cbr/\u003e\u003cbr/\u003eIn the beacon format, you need to always use ` + "`" + `localhost` + "`" + ` as the host, rather than the actual hostname. ` + "`" + `localhost` + "`" + ` here refers to the fact that the beacon's target is on the same Weaviate instance, as opposed to a foreign instance.",
        "tags": [
          "objects"
        ],
        "summary": "Delete object based on its class and UUID.",
        "operationId": "objects.class.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if a data object exists based on its collection and uuid without retrieving it. \u003cbr/\u003e\u003cbr/\u003eInternally it skips reading the object from disk other than checking if it is present. Thus it does not use resources on marshalling, parsing, etc., and is faster. Note the resulting HTTP request has no body; the existence of an object is indicated solely by the status code.",
        "tags": [
          "objects"
        ],
        "summary": "Checks object's existence based on its class and uuid.",
        "operationId": "objects.class.head",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object doesn't exist."
          },
          "422": {
            "description": "Request is well-formed (i.e., syntactically correct), but erroneous.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "patch": {
        "description": "Update an individual data object based on its class and uuid. This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID (using patch semantics).",
        "operationId": "objects.class.patch",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "The uuid of the data object to update.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style patch, the body contains the object to merge into the existing object.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully applied. No content provided."
          },
          "400": {
            "description": "The patch-JSON is malformed.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "The patch-JSON is valid but unprocessable.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{className}/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace **all** references in cross-reference property of an object.",
        "tags": [
          "objects"
        ],
        "summary": "Replace all references to a class-property.",
        "operationId": "objects.class.references.put",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully replaced all the references."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object doesn't exist."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a single reference to an object. This adds a reference to the array of cross-references of the given property in the source object specified by its collection name and id",
        "tags": [
          "objects"
        ],
        "summary": "Add a single reference to a class-property.",
        "operationId": "objects.class.references.create",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully added the reference."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Source object doesn't exist."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has.",
        "tags": [
          "objects"
        ],
        "summary": "Delete the single reference that is given in the body from the list of references that this property has.",
        "operationId": "objects.class.references.delete",
        "parameters": [
          {
            "type": "string",
            "description": "The class name as defined in the schema",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}": {
      "get": {
        "description": "Get a specific object based on its UUID. Also available as Websocket bus.",
        "tags": [
          "objects"
        ],
        "summary": "Get a specific Object based on its UUID and a Object UUID. Also available as Websocket bus.",
        "operationId": "objects.get",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Include additional information, such as classification infos. Allowed values include: classification, vector, interpretation",
            "name": "include",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successful response.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "400": {
            "description": "Malformed request.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.query"
        ]
      },
      "put": {
        "description": "Updates an object based on its UUID. Given meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID.",
        "operationId": "objects.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully received.",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the class is defined in the configuration file?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Deletes an object from the database based on its UUID.",
        "tags": [
          "objects"
        ],
        "summary": "Delete an Object based on its UUID.",
        "operationId": "objects.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "head": {
        "description": "Checks if an object exists in the system based on its UUID.",
        "tags": [
          "objects"
        ],
        "summary": "Checks Object's existence based on its UUID.",
        "operationId": "objects.head",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Object exists."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Object doesn't exist."
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": true,
        "x-available-in-websocket": true,
        "x-serviceIds": [
          "weaviate.objects.check"
        ]
      },
      "patch": {
        "description": "Update an object based on its UUID (using patch semantics). This method supports json-merge style patch semantics (RFC 7396). Provided meta-data and schema values are validated. LastUpdateTime is set to the time this function is called.",
        "tags": [
          "objects"
        ],
        "summary": "Update an Object based on its UUID (using patch semantics).",
        "operationId": "objects.patch",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "description": "RFC 7396-style patch, the body contains the object to merge into the existing object.",
            "name": "body",
            "in": "body",
            "schema": {
              "$ref": "#/definitions/Object"
            }
          },
          {
            "type": "string",
            "description": "Determines how many replicas must acknowledge a request before it is considered successful",
            "name": "consistency_level",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully applied. No content provided."
          },
          "400": {
            "description": "The patch-JSON is malformed."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found."
          },
          "422": {
            "description": "The patch-JSON is valid but unprocessable.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/objects/{id}/references/{propertyName}": {
      "put": {
        "description": "Replace all references in cross-reference property of an object.",
        "tags": [
          "objects"
        ],
        "summary": "Replace all references to a class-property.",
        "operationId": "objects.references.update",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MultipleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully replaced all the references."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "post": {
        "description": "Add a cross-reference.",
        "tags": [
          "objects"
        ],
        "summary": "Add a single reference to a class-property.",
        "operationId": "objects.references.create",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully added the reference."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Request body is well-formed (i.e., syntactically correct), but semantically erroneous. Are you sure the property exists or that it is a class?",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      },
      "delete": {
        "description": "Delete the single reference that is given in the body from the list of references that this property has.",
        "tags": [
          "objects"
        ],
        "summary": "Delete the single reference that is given in the body from the list of references that this property has.",
        "operationId": "objects.references.delete",
        "deprecated": true,
        "parameters": [
          {
            "type": "string",
            "format": "uuid",
            "description": "Unique ID of the Object.",
            "name": "id",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "description": "Unique name of the property related to the Object.",
            "name": "propertyName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/SingleRef"
            }
          },
          {
            "type": "string",
            "description": "Specifies the tenant in a request targeting a multi-tenant class",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "204": {
            "description": "Successfully deleted."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Successful query result but no resource was found.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-available-in-mqtt": false,
        "x-available-in-websocket": false,
        "x-serviceIds": [
          "weaviate.local.manipulate"
        ]
      }
    },
    "/schema": {
      "get": {
        "description": "Fetch an array of all collection definitions from the schema.",
        "tags": [
          "schema"
        ],
        "summary": "Dump the current the database schema.",
        "operationId": "schema.dump",
        "parameters": [
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Successfully dumped the database schema.",
            "schema": {
              "$ref": "#/definitions/Schema"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.query.meta"
        ]
      },
      "post": {
        "description": "Create a new data object collection. \u003cbr/\u003e\u003cbr/\u003eIf AutoSchema is enabled, Weaviate will attempt to infer the schema from the data at import time. However, manual schema definition is recommended for production environments.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new Object class in the schema.",
        "operationId": "schema.objects.create",
        "parameters": [
          {
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added the new Object class to the schema.",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Object class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.add.meta"
        ]
      }
    },
    "/schema/{className}": {
      "get": {
        "tags": [
          "schema"
        ],
        "summary": "Get a single class from the schema",
        "operationId": "schema.objects.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "Found the Class, returned as body",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "This class does not exist"
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      },
      "put": {
        "description": "Add a property to an existing collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update settings of an existing schema class",
        "operationId": "schema.objects.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "objectClass",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Class"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Class was updated successfully",
            "schema": {
              "$ref": "#/definitions/Class"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Class to be updated does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      },
      "delete": {
        "description": "Remove a collection from the schema. This will also delete all the objects in the collection.",
        "tags": [
          "schema"
        ],
        "summary": "Remove an Object class (and all data in the instances) from the schema.",
        "operationId": "schema.objects.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Removed the Object class from the schema."
          },
          "400": {
            "description": "Could not delete the Object class.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/properties": {
      "post": {
        "tags": [
          "schema"
        ],
        "summary": "Add a property to an Object class.",
        "operationId": "schema.objects.properties.add",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/Property"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added the property.",
            "schema": {
              "$ref": "#/definitions/Property"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid property.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/shards": {
      "get": {
        "description": "Get the status of every shard in the cluster.",
        "tags": [
          "schema"
        ],
        "summary": "Get the shards status of an Object class",
        "operationId": "schema.objects.shards.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenant",
            "in": "query"
          }
        ],
        "responses": {
          "200": {
            "description": "Found the status of the shards, returned as body",
            "schema": {
              "$ref": "#/definitions/ShardStatusList"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "This class does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.get.meta"
        ]
      }
    },
    "/schema/{className}/shards/{shardName}": {
      "put": {
        "description": "Update a shard status for a collection. For example, a shard may have been marked as ` + "`" + `READONLY` + "`" + ` because its disk was full. After providing more disk space, use this endpoint to set the shard status to ` + "`" + `READY` + "`" + ` again. There is also a convenience function in each client to set the status of all shards of a collection.",
        "tags": [
          "schema"
        ],
        "summary": "Update a shard status.",
        "operationId": "schema.objects.shards.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "shardName",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Shard status was updated successfully",
            "schema": {
              "$ref": "#/definitions/ShardStatus"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Shard to be updated does not exist",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid update attempt",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        },
        "x-serviceIds": [
          "weaviate.local.manipulate.meta"
        ]
      }
    },
    "/schema/{className}/tenants": {
      "get": {
        "description": "get all tenants from a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Get the list of tenants.",
        "operationId": "tenants.get",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "tenants from specified class.",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "put": {
        "description": "Update tenant of a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Update a tenant.",
        "operationId": "tenants.update",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Updated tenants of the specified class",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "post": {
        "description": "Create a new tenant for a collection. Multi-tenancy must be enabled in the collection definition.",
        "tags": [
          "schema"
        ],
        "summary": "Create a new tenant",
        "operationId": "tenants.create",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "body",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Added new tenants to the specified class",
            "schema": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Tenant"
              }
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "delete": {
        "description": "delete tenants from a specific class",
        "tags": [
          "schema"
        ],
        "operationId": "tenants.delete",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "name": "tenants",
            "in": "body",
            "required": true,
            "schema": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          }
        ],
        "responses": {
          "200": {
            "description": "Deleted tenants from specified class."
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    },
    "/schema/{className}/tenants/{tenantName}": {
      "get": {
        "description": "get a specific tenant for the given class",
        "tags": [
          "schema"
        ],
        "summary": "Get a specific tenant",
        "operationId": "tenants.get.one",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "load the tenant given the specified class",
            "schema": {
              "$ref": "#/definitions/TenantResponse"
            }
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "Tenant not found"
          },
          "422": {
            "description": "Invalid tenant or class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      },
      "head": {
        "description": "Check if a tenant exists for a specific class",
        "tags": [
          "schema"
        ],
        "summary": "Check whether a tenant exists",
        "operationId": "tenant.exists",
        "parameters": [
          {
            "type": "string",
            "name": "className",
            "in": "path",
            "required": true
          },
          {
            "type": "string",
            "name": "tenantName",
            "in": "path",
            "required": true
          },
          {
            "type": "boolean",
            "default": true,
            "description": "If consistency is true, the request will be proxied to the leader to ensure strong schema consistency",
            "name": "consistency",
            "in": "header"
          }
        ],
        "responses": {
          "200": {
            "description": "The tenant exists in the specified class"
          },
          "401": {
            "description": "Unauthorized or invalid credentials."
          },
          "403": {
            "description": "Forbidden",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "404": {
            "description": "The tenant not found"
          },
          "422": {
            "description": "Invalid Tenant class",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          },
          "500": {
            "description": "An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.",
            "schema": {
              "$ref": "#/definitions/ErrorResponse"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "AdditionalProperties": {
      "description": "(Response only) Additional meta information about a single object.",
      "type": "object",
      "additionalProperties": {
        "type": "object"
      }
    },
    "BM25Config": {
      "description": "tuning parameters for the BM25 algorithm",
      "type": "object",
      "properties": {
        "b": {
          "description": "Calibrates term-weight scaling based on the document length (default: 0.75).",
          "type": "number",
          "format": "float"
        },
        "k1": {
          "description": "Calibrates term-weight scaling based on the term frequency within a document (default: 1.2).",
          "type": "number",
          "format": "float"
        }
      }
    },
    "BackupConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "ChunkSize": {
          "description": "Aimed chunk size, with a minimum of 2MB, default of 128MB, and a maximum of 512MB. The actual chunk size may vary.",
          "type": "integer",
          "default": 128,
          "maximum": 512,
          "minimum": 2,
          "x-nullable": false
        },
        "CompressionLevel": {
          "description": "compression level used by compression algorithm",
          "type": "string",
          "default": "DefaultCompression",
          "enum": [
            "DefaultCompression",
            "BestSpeed",
            "BestCompression"
          ],
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path or key within the bucket",
          "type": "string"
        }
      }
    },
    "BackupCreateRequest": {
      "description": "Request body for creating a backup of a set of classes",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup creation process",
          "type": "object",
          "$ref": "#/definitions/BackupConfig"
        },
        "exclude": {
          "description": "List of collections to exclude from the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `include` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the backup (required). Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "include": {
          "description": "List of collections to include in the backup creation process. If not set, all collections are included. Cannot be used together with ` + "`" + `exclude` + "`" + `.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "BackupCreateResponse": {
      "description": "The definition of a backup create response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "classes": {
          "description": "The list of classes for which the backup creation process was started",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "Path within bucket of backup",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupCreateStatusResponse": {
      "description": "The definition of a backup create metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "error message if creation failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backend",
          "type": "string"
        },
        "status": {
          "description": "phase of backup creation process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupListResponse": {
      "description": "The definition of a backup create response body",
      "type": "array",
      "items": {
        "$ref": "#/definitions/BackupListResponseItems0"
      }
    },
    "BackupListResponseItems0": {
      "type": "object",
      "properties": {
        "classes": {
          "description": "The list of classes for which the existed backup process",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backend",
          "type": "string"
        },
        "status": {
          "description": "status of backup process",
          "type": "string",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreRequest": {
      "description": "Request body for restoring a backup for a set of classes",
      "properties": {
        "config": {
          "description": "Custom configuration for the backup restoration process",
          "type": "object",
          "$ref": "#/definitions/RestoreConfig"
        },
        "exclude": {
          "description": "List of classes to exclude from the backup restoration process",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "include": {
          "description": "List of classes to include in the backup restoration process",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "node_mapping": {
          "description": "Allows overriding the node names stored in the backup with different ones. Useful when restoring backups to a different environment.",
          "type": "object",
          "additionalProperties": {
            "type": "string"
          }
        }
      }
    },
    "BackupRestoreResponse": {
      "description": "The definition of a backup restore response body",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "classes": {
          "description": "The list of classes for which the backup restoration process was started",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "error": {
          "description": "error message if restoration failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backend",
          "type": "string"
        },
        "status": {
          "description": "phase of backup restoration process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BackupRestoreStatusResponse": {
      "description": "The definition of a backup restore metadata",
      "properties": {
        "backend": {
          "description": "Backup backend name e.g. filesystem, gcs, s3.",
          "type": "string"
        },
        "error": {
          "description": "error message if restoration failed",
          "type": "string"
        },
        "id": {
          "description": "The ID of the backup. Must be URL-safe and work as a filesystem path, only lowercase, numbers, underscore, minus characters allowed.",
          "type": "string"
        },
        "path": {
          "description": "destination path of backup files proper to selected backup backend, contains bucket and path",
          "type": "string"
        },
        "status": {
          "description": "phase of backup restoration process",
          "type": "string",
          "default": "STARTED",
          "enum": [
            "STARTED",
            "TRANSFERRING",
            "TRANSFERRED",
            "SUCCESS",
            "FAILED",
            "CANCELED"
          ]
        }
      }
    },
    "BatchDelete": {
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, the call will show which objects would be matched using the specified filter without deleting any objects. \u003cbr/\u003e\u003cbr/\u003eDepending on the configured verbosity, you will either receive a count of affected objects, or a list of IDs.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "Class (name) which objects will be deleted.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
          "type": "string",
          "default": "minimal"
        }
      }
    },
    "BatchDeleteMatch": {
      "description": "Outlines how to find the objects to be deleted.",
      "type": "object",
      "properties": {
        "class": {
          "description": "Class (name) which objects will be deleted.",
          "type": "string",
          "example": "City"
        },
        "where": {
          "description": "Filter to limit the objects to be deleted.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "BatchDeleteResponse": {
      "description": "Delete Objects response.",
      "type": "object",
      "properties": {
        "deletionTimeUnixMilli": {
          "description": "Timestamp of deletion in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64",
          "x-nullable": true
        },
        "dryRun": {
          "description": "If true, objects will not be deleted yet, but merely listed. Defaults to false.",
          "type": "boolean",
          "default": false
        },
        "match": {
          "description": "Outlines how to find the objects to be deleted.",
          "type": "object",
          "properties": {
            "class": {
              "description": "Class (name) which objects will be deleted.",
              "type": "string",
              "example": "City"
            },
            "where": {
              "description": "Filter to limit the objects to be deleted.",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "output": {
          "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
          "type": "string",
          "default": "minimal"
        },
        "results": {
          "type": "object",
          "properties": {
            "failed": {
              "description": "How many objects should have been deleted but could not be deleted.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "limit": {
              "description": "The most amount of objects that can be deleted in a single query, equals QUERY_MAXIMUM_RESULTS.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "matches": {
              "description": "How many objects were matched by the filter.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            },
            "objects": {
              "description": "With output set to \"minimal\" only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to \"verbose\" will list all of the objets with their respective statuses.",
              "type": "array",
              "items": {
                "$ref": "#/definitions/BatchDeleteResponseResultsObjectsItems0"
              }
            },
            "successful": {
              "description": "How many objects were successfully deleted in this round.",
              "type": "number",
              "format": "int64",
              "x-omitempty": false
            }
          }
        }
      }
    },
    "BatchDeleteResponseMatch": {
      "description": "Outlines how to find the objects to be deleted.",
      "type": "object",
      "properties": {
        "class": {
          "description": "Class (name) which objects will be deleted.",
          "type": "string",
          "example": "City"
        },
        "where": {
          "description": "Filter to limit the objects to be deleted.",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "BatchDeleteResponseResults": {
      "type": "object",
      "properties": {
        "failed": {
          "description": "How many objects should have been deleted but could not be deleted.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "limit": {
          "description": "The most amount of objects that can be deleted in a single query, equals QUERY_MAXIMUM_RESULTS.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "matches": {
          "description": "How many objects were matched by the filter.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "objects": {
          "description": "With output set to \"minimal\" only objects with error occurred will the be described. Successfully deleted objects would be omitted. Output set to \"verbose\" will list all of the objets with their respective statuses.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/BatchDeleteResponseResultsObjectsItems0"
          }
        },
        "successful": {
          "description": "How many objects were successfully deleted in this round.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "BatchDeleteResponseResultsObjectsItems0": {
      "description": "Results for this specific Object.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "id": {
          "description": "ID of the Object.",
          "type": "string",
          "format": "uuid"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "DRYRUN",
            "FAILED"
          ]
        }
      }
    },
    "BatchReference": {
      "properties": {
        "from": {
          "description": "Long-form beacon-style URI to identify the source of the cross-ref including the property name. Should be in the form of weaviate://localhost/\u003ckinds\u003e/\u003cuuid\u003e/\u003cclassName\u003e/\u003cpropertyName\u003e, where \u003ckinds\u003e must be one of 'objects', 'objects' and \u003cclassName\u003e and \u003cpropertyName\u003e must represent the cross-ref property of source class to be used.",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/Zoo/a5d09582-4239-4702-81c9-92a6e0122bb4/hasAnimals"
        },
        "tenant": {
          "description": "Name of the reference tenant.",
          "type": "string"
        },
        "to": {
          "description": "Short-form URI to point to the cross-ref. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-ref to an object",
          "type": "string",
          "format": "uri",
          "example": "weaviate://localhost/97525810-a9a5-4eb0-858a-71449aeb007f"
        }
      }
    },
    "BatchReferenceResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/BatchReference"
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific reference.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "BatchReferenceResponseAO1Result": {
      "description": "Results for this specific reference.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "FAILED"
          ]
        }
      }
    },
    "BatchStats": {
      "description": "The summary of a nodes batch queue congestion status.",
      "properties": {
        "queueLength": {
          "description": "How many objects are currently in the batch queue.",
          "type": "number",
          "format": "int",
          "x-nullable": true,
          "x-omitempty": true
        },
        "ratePerSecond": {
          "description": "How many objects are approximately processed from the batch queue per second.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "C11yExtension": {
      "description": "A resource describing an extension to the contextinoary, containing both the identifier and the definition of the extension",
      "properties": {
        "concept": {
          "description": "The new concept you want to extend. Must be an all-lowercase single word, or a space delimited compound word. Examples: 'foobarium', 'my custom concept'",
          "type": "string",
          "example": "foobarium"
        },
        "definition": {
          "description": "A list of space-delimited words or a sentence describing what the custom concept is about. Avoid using the custom concept itself. An Example definition for the custom concept 'foobarium': would be 'a naturally occurring element which can only be seen by programmers'",
          "type": "string"
        },
        "weight": {
          "description": "Weight of the definition of the new concept where 1='override existing definition entirely' and 0='ignore custom definition'. Note that if the custom concept is not present in the contextionary yet, the weight cannot be less than 1.",
          "type": "number",
          "format": "float"
        }
      }
    },
    "C11yNearestNeighbors": {
      "description": "C11y function to show the nearest neighbors to a word.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/C11yNearestNeighborsItems0"
      }
    },
    "C11yNearestNeighborsItems0": {
      "type": "object",
      "properties": {
        "distance": {
          "type": "number",
          "format": "float"
        },
        "word": {
          "type": "string"
        }
      }
    },
    "C11yVector": {
      "description": "A vector representation of the object in the Contextionary. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "C11yVectorBasedQuestion": {
      "description": "Receive question based on array of classes, properties and values.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/C11yVectorBasedQuestionItems0"
      }
    },
    "C11yVectorBasedQuestionItems0": {
      "type": "object",
      "properties": {
        "classProps": {
          "description": "Vectorized properties.",
          "type": "array",
          "maxItems": 300,
          "minItems": 300,
          "items": {
            "$ref": "#/definitions/C11yVectorBasedQuestionItems0ClassPropsItems0"
          }
        },
        "classVectors": {
          "description": "Vectorized classname.",
          "type": "array",
          "maxItems": 300,
          "minItems": 300,
          "items": {
            "type": "number",
            "format": "float"
          }
        }
      }
    },
    "C11yVectorBasedQuestionItems0ClassPropsItems0": {
      "type": "object",
      "properties": {
        "propsVectors": {
          "type": "array",
          "items": {
            "type": "number",
            "format": "float"
          }
        },
        "value": {
          "description": "String with valuename.",
          "type": "string"
        }
      }
    },
    "C11yWordsResponse": {
      "description": "An array of available words and contexts.",
      "properties": {
        "concatenatedWord": {
          "description": "Weighted results for all words",
          "type": "object",
          "properties": {
            "concatenatedNearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "concatenatedVector": {
              "$ref": "#/definitions/C11yVector"
            },
            "concatenatedWord": {
              "type": "string"
            },
            "singleWords": {
              "type": "array",
              "items": {
                "format": "string"
              }
            }
          }
        },
        "individualWords": {
          "description": "Weighted results for per individual word",
          "type": "array",
          "items": {
            "$ref": "#/definitions/C11yWordsResponseIndividualWordsItems0"
          }
        }
      }
    },
    "C11yWordsResponseConcatenatedWord": {
      "description": "Weighted results for all words",
      "type": "object",
      "properties": {
        "concatenatedNearestNeighbors": {
          "$ref": "#/definitions/C11yNearestNeighbors"
        },
        "concatenatedVector": {
          "$ref": "#/definitions/C11yVector"
        },
        "concatenatedWord": {
          "type": "string"
        },
        "singleWords": {
          "type": "array",
          "items": {
            "format": "string"
          }
        }
      }
    },
    "C11yWordsResponseIndividualWordsItems0": {
      "type": "object",
      "properties": {
        "info": {
          "type": "object",
          "properties": {
            "nearestNeighbors": {
              "$ref": "#/definitions/C11yNearestNeighbors"
            },
            "vector": {
              "$ref": "#/definitions/C11yVector"
            }
          }
        },
        "present": {
          "type": "boolean"
        },
        "word": {
          "type": "string"
        }
      }
    },
    "C11yWordsResponseIndividualWordsItems0Info": {
      "type": "object",
      "properties": {
        "nearestNeighbors": {
          "$ref": "#/definitions/C11yNearestNeighbors"
        },
        "vector": {
          "$ref": "#/definitions/C11yVector"
        }
      }
    },
    "Class": {
      "type": "object",
      "properties": {
        "class": {
          "description": "Name of the class (a.k.a. 'collection') (required). Multiple words should be concatenated in CamelCase, e.g. ` + "`" + `ArticleAuthor` + "`" + `.",
          "type": "string"
        },
        "description": {
          "description": "Description of the collection for metadata purposes.",
          "type": "string"
        },
        "invertedIndexConfig": {
          "$ref": "#/definitions/InvertedIndexConfig"
        },
        "moduleConfig": {
          "description": "Configuration specific to modules in a collection context.",
          "type": "object"
        },
        "multiTenancyConfig": {
          "$ref": "#/definitions/MultiTenancyConfig"
        },
        "properties": {
          "description": "Define properties of the collection.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Property"
          }
        },
        "replicationConfig": {
          "$ref": "#/definitions/ReplicationConfig"
        },
        "shardingConfig": {
          "description": "Manage how the index should be sharded and distributed in the cluster",
          "type": "object"
        },
        "vectorConfig": {
          "description": "Configure named vectors. Either use this field or ` + "`" + `vectorizer` + "`" + `, ` + "`" + `vectorIndexType` + "`" + `, and ` + "`" + `vectorIndexConfig` + "`" + ` fields. Available from ` + "`" + `v1.24.0` + "`" + `.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/VectorConfig"
          }
        },
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Specify how the vectors for this class should be determined. The options are either 'none' - this means you have to import a vector with each object yourself - or the name of a module that provides vectorization capabilities, such as 'text2vec-contextionary'. If left empty, it will use the globally configured default which can itself either be 'none' or a specific module.",
          "type": "string"
        }
      }
    },
    "Classification": {
      "description": "Manage classifications, trigger them and view status of past classifications.",
      "type": "object",
      "properties": {
        "basedOnProperties": {
          "description": "base the text-based classification on these fields (of type text)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "description"
          ]
        },
        "class": {
          "description": "class (name) which is used in this classification",
          "type": "string",
          "example": "City"
        },
        "classifyProperties": {
          "description": "which ref-property to set as part of the classification",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCountry"
          ]
        },
        "error": {
          "description": "error message if status == failed",
          "type": "string",
          "default": "",
          "example": "classify xzy: something went wrong"
        },
        "filters": {
          "type": "object",
          "properties": {
            "sourceWhere": {
              "description": "limit the objects to be classified",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "targetWhere": {
              "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            },
            "trainingSetWhere": {
              "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'",
              "type": "object",
              "$ref": "#/definitions/WhereFilter"
            }
          }
        },
        "id": {
          "description": "ID to uniquely identify this classification run",
          "type": "string",
          "format": "uuid",
          "example": "ee722219-b8ec-4db1-8f8d-5150bb1a9e0c"
        },
        "meta": {
          "description": "additional meta information about the classification",
          "type": "object",
          "$ref": "#/definitions/ClassificationMeta"
        },
        "settings": {
          "description": "classification-type specific settings",
          "type": "object"
        },
        "status": {
          "description": "status of this classification",
          "type": "string",
          "enum": [
            "running",
            "completed",
            "failed"
          ],
          "example": "running"
        },
        "type": {
          "description": "which algorithm to use for classifications",
          "type": "string"
        }
      }
    },
    "ClassificationFilters": {
      "type": "object",
      "properties": {
        "sourceWhere": {
          "description": "limit the objects to be classified",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        },
        "targetWhere": {
          "description": "Limit the possible sources when using an algorithm which doesn't really on training data, e.g. 'contextual'. When using an algorithm with a training set, such as 'knn', limit the training set instead",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        },
        "trainingSetWhere": {
          "description": "Limit the training objects to be considered during the classification. Can only be used on types with explicit training sets, such as 'knn'",
          "type": "object",
          "$ref": "#/definitions/WhereFilter"
        }
      }
    },
    "ClassificationMeta": {
      "description": "Additional information to a specific classification",
      "type": "object",
      "properties": {
        "completed": {
          "description": "time when this classification finished",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        },
        "count": {
          "description": "number of objects which were taken into consideration for classification",
          "type": "integer",
          "example": 147
        },
        "countFailed": {
          "description": "number of objects which could not be classified - see error message for details",
          "type": "integer",
          "example": 7
        },
        "countSucceeded": {
          "description": "number of objects successfully classified",
          "type": "integer",
          "example": 140
        },
        "started": {
          "description": "time when this classification was started",
          "type": "string",
          "format": "date-time",
          "example": "2017-07-21T17:32:28Z"
        }
      }
    },
    "ClusterStatisticsResponse": {
      "description": "The cluster statistics of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "statistics": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Statistics"
          }
        },
        "synchronized": {
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "Deprecation": {
      "type": "object",
      "properties": {
        "apiType": {
          "description": "Describes which API is effected, usually one of: REST, GraphQL",
          "type": "string"
        },
        "id": {
          "description": "The id that uniquely identifies this particular deprecations (mostly used internally)",
          "type": "string"
        },
        "locations": {
          "description": "The locations within the specified API affected by this deprecation",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "mitigation": {
          "description": "User-required object to not be affected by the (planned) removal",
          "type": "string"
        },
        "msg": {
          "description": "What this deprecation is about",
          "type": "string"
        },
        "plannedRemovalVersion": {
          "description": "A best-effort guess of which upcoming version will remove the feature entirely",
          "type": "string"
        },
        "removedIn": {
          "description": "If the feature has already been removed, it was removed in this version",
          "type": "string",
          "x-nullable": true
        },
        "removedTime": {
          "description": "If the feature has already been removed, it was removed at this timestamp",
          "type": "string",
          "format": "date-time",
          "x-nullable": true
        },
        "sinceTime": {
          "description": "The deprecation was introduced in this version",
          "type": "string",
          "format": "date-time"
        },
        "sinceVersion": {
          "description": "The deprecation was introduced in this version",
          "type": "string"
        },
        "status": {
          "description": "Whether the problematic API functionality is deprecated (planned to be removed) or already removed",
          "type": "string"
        }
      }
    },
    "ErrorResponse": {
      "description": "An error response given by Weaviate end-points.",
      "type": "object",
      "properties": {
        "error": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/ErrorResponseErrorItems0"
          }
        }
      }
    },
    "ErrorResponseErrorItems0": {
      "type": "object",
      "properties": {
        "message": {
          "type": "string"
        }
      }
    },
    "GeoCoordinates": {
      "properties": {
        "latitude": {
          "description": "The latitude of the point on earth in decimal form",
          "type": "number",
          "format": "float",
          "x-nullable": true
        },
        "longitude": {
          "description": "The longitude of the point on earth in decimal form",
          "type": "number",
          "format": "float",
          "x-nullable": true
        }
      }
    },
    "GraphQLError": {
      "description": "An error response caused by a GraphQL query.",
      "properties": {
        "locations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLErrorLocationsItems0"
          }
        },
        "message": {
          "type": "string"
        },
        "path": {
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "GraphQLErrorLocationsItems0": {
      "type": "object",
      "properties": {
        "column": {
          "type": "integer",
          "format": "int64"
        },
        "line": {
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "GraphQLQueries": {
      "description": "A list of GraphQL queries.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLQuery"
      }
    },
    "GraphQLQuery": {
      "description": "GraphQL query based on: http://facebook.github.io/graphql/.",
      "type": "object",
      "properties": {
        "operationName": {
          "description": "The name of the operation if multiple exist in the query.",
          "type": "string"
        },
        "query": {
          "description": "Query based on GraphQL syntax.",
          "type": "string"
        },
        "variables": {
          "description": "Additional variables for the query.",
          "type": "object"
        }
      }
    },
    "GraphQLResponse": {
      "description": "GraphQL based response: http://facebook.github.io/graphql/.",
      "properties": {
        "data": {
          "description": "GraphQL data object.",
          "type": "object",
          "additionalProperties": {
            "$ref": "#/definitions/JsonObject"
          }
        },
        "errors": {
          "description": "Array with errors.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/GraphQLError"
          },
          "x-omitempty": true
        }
      }
    },
    "GraphQLResponses": {
      "description": "A list of GraphQL responses.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/GraphQLResponse"
      }
    },
    "InvertedIndexConfig": {
      "description": "Configure the inverted index built into Weaviate (default: 60).",
      "type": "object",
      "properties": {
        "bm25": {
          "$ref": "#/definitions/BM25Config"
        },
        "cleanupIntervalSeconds": {
          "description": "Asynchronous index clean up happens every n seconds",
          "type": "number",
          "format": "int"
        },
        "indexNullState": {
          "description": "Index each object with the null state (default: 'false').",
          "type": "boolean"
        },
        "indexPropertyLength": {
          "description": "Index length of properties (default: 'false').",
          "type": "boolean"
        },
        "indexTimestamps": {
          "description": "Index each object by its internal timestamps (default: 'false').",
          "type": "boolean"
        },
        "stopwords": {
          "$ref": "#/definitions/StopwordConfig"
        }
      }
    },
    "JsonObject": {
      "description": "JSON object value.",
      "type": "object"
    },
    "Link": {
      "type": "object",
      "properties": {
        "documentationHref": {
          "description": "weaviate documentation about this resource group",
          "type": "string"
        },
        "href": {
          "description": "target of the link",
          "type": "string"
        },
        "name": {
          "description": "human readable name of the resource group",
          "type": "string"
        },
        "rel": {
          "description": "relationship if both resources are related, e.g. 'next', 'previous', 'parent', etc.",
          "type": "string"
        }
      }
    },
    "Meta": {
      "description": "Contains meta information of the current Weaviate instance.",
      "type": "object",
      "properties": {
        "grpcMaxMessageSize": {
          "description": "Max message size for GRPC connection in bytes.",
          "type": "integer"
        },
        "hostname": {
          "description": "The url of the host.",
          "type": "string",
          "format": "url"
        },
        "modules": {
          "description": "Module-specific meta information.",
          "type": "object"
        },
        "version": {
          "description": "The Weaviate server version.",
          "type": "string"
        }
      }
    },
    "MultiTenancyConfig": {
      "description": "Configuration related to multi-tenancy within a class",
      "properties": {
        "autoTenantActivation": {
          "description": "Existing tenants should (not) be turned HOT implicitly when they are accessed and in another activity status (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "autoTenantCreation": {
          "description": "Nonexistent tenants should (not) be created implicitly (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "enabled": {
          "description": "Whether or not multi-tenancy is enabled for this class (default: false).",
          "type": "boolean",
          "x-omitempty": false
        }
      }
    },
    "MultipleRef": {
      "description": "Multiple instances of references to other objects.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/SingleRef"
      }
    },
    "NestedProperty": {
      "type": "object",
      "properties": {
        "dataType": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "type": "string"
        },
        "indexFilterable": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "type": "boolean",
          "x-nullable": true
        },
        "name": {
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja"
          ]
        }
      }
    },
    "NodeShardStatus": {
      "description": "The definition of a node shard status response body",
      "properties": {
        "class": {
          "description": "The name of shard's class.",
          "type": "string",
          "x-omitempty": false
        },
        "compressed": {
          "description": "The status of vector compression/quantization.",
          "format": "boolean",
          "x-omitempty": false
        },
        "loaded": {
          "description": "The load status of the shard.",
          "type": "boolean",
          "x-omitempty": false
        },
        "name": {
          "description": "The name of the shard.",
          "type": "string",
          "x-omitempty": false
        },
        "objectCount": {
          "description": "The number of objects in shard.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "vectorIndexingStatus": {
          "description": "The status of the vector indexing process.",
          "format": "string",
          "x-omitempty": false
        },
        "vectorQueueLength": {
          "description": "The length of the vector indexing queue.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        }
      }
    },
    "NodeStats": {
      "description": "The summary of Weaviate's statistics.",
      "properties": {
        "objectCount": {
          "description": "The total number of objects in DB.",
          "type": "number",
          "format": "int64",
          "x-omitempty": false
        },
        "shardCount": {
          "description": "The count of Weaviate's shards. To see this value, set ` + "`" + `output` + "`" + ` to ` + "`" + `verbose` + "`" + `.",
          "type": "number",
          "format": "int",
          "x-omitempty": false
        }
      }
    },
    "NodeStatus": {
      "description": "The definition of a backup node status response body",
      "properties": {
        "batchStats": {
          "description": "Weaviate batch statistics.",
          "type": "object",
          "$ref": "#/definitions/BatchStats"
        },
        "gitHash": {
          "description": "The gitHash of Weaviate.",
          "type": "string"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "shards": {
          "description": "The list of the shards with it's statistics.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeShardStatus"
          }
        },
        "stats": {
          "description": "Weaviate overall statistics.",
          "type": "object",
          "$ref": "#/definitions/NodeStats"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        },
        "version": {
          "description": "The version of Weaviate.",
          "type": "string"
        }
      }
    },
    "NodesStatusResponse": {
      "description": "The status of all of the Weaviate nodes",
      "type": "object",
      "properties": {
        "nodes": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/NodeStatus"
          }
        }
      }
    },
    "Object": {
      "type": "object",
      "properties": {
        "additional": {
          "$ref": "#/definitions/AdditionalProperties"
        },
        "class": {
          "description": "Class of the Object, defined in the schema.",
          "type": "string"
        },
        "creationTimeUnix": {
          "description": "(Response only) Timestamp of creation of this object in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "id": {
          "description": "ID of the Object.",
          "type": "string",
          "format": "uuid"
        },
        "lastUpdateTimeUnix": {
          "description": "(Response only) Timestamp of the last object update in milliseconds since epoch UTC.",
          "type": "integer",
          "format": "int64"
        },
        "properties": {
          "$ref": "#/definitions/PropertySchema"
        },
        "tenant": {
          "description": "Name of the Objects tenant.",
          "type": "string"
        },
        "vector": {
          "description": "This field returns vectors associated with the Object. C11yVector, Vector or Vectors values are possible.",
          "$ref": "#/definitions/C11yVector"
        },
        "vectorWeights": {
          "$ref": "#/definitions/VectorWeights"
        },
        "vectors": {
          "description": "This field returns vectors associated with the Object.",
          "$ref": "#/definitions/Vectors"
        }
      }
    },
    "ObjectsGetResponse": {
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Object"
        },
        {
          "properties": {
            "deprecations": {
              "type": "array",
              "items": {
                "$ref": "#/definitions/Deprecation"
              }
            }
          }
        },
        {
          "properties": {
            "result": {
              "description": "Results for this specific Object.",
              "format": "object",
              "properties": {
                "errors": {
                  "$ref": "#/definitions/ErrorResponse"
                },
                "status": {
                  "type": "string",
                  "default": "SUCCESS",
                  "enum": [
                    "SUCCESS",
                    "FAILED"
                  ]
                }
              }
            }
          }
        }
      ]
    },
    "ObjectsGetResponseAO2Result": {
      "description": "Results for this specific Object.",
      "format": "object",
      "properties": {
        "errors": {
          "$ref": "#/definitions/ErrorResponse"
        },
        "status": {
          "type": "string",
          "default": "SUCCESS",
          "enum": [
            "SUCCESS",
            "FAILED"
          ]
        }
      }
    },
    "ObjectsListResponse": {
      "description": "List of Objects.",
      "type": "object",
      "properties": {
        "deprecations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Deprecation"
          }
        },
        "objects": {
          "description": "The actual list of Objects.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Object"
          }
        },
        "totalResults": {
          "description": "The total number of Objects for the query. The number of items in a response may be smaller due to paging.",
          "type": "integer",
          "format": "int64"
        }
      }
    },
    "PatchDocumentAction": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PatchDocumentObject": {
      "description": "Either a JSONPatch document as defined by RFC 6902 (from, op, path, value), or a merge document (RFC 7396).",
      "required": [
        "op",
        "path"
      ],
      "properties": {
        "from": {
          "description": "A string containing a JSON Pointer value.",
          "type": "string"
        },
        "merge": {
          "$ref": "#/definitions/Object"
        },
        "op": {
          "description": "The operation to be performed.",
          "type": "string",
          "enum": [
            "add",
            "remove",
            "replace",
            "move",
            "copy",
            "test"
          ]
        },
        "path": {
          "description": "A JSON-Pointer.",
          "type": "string"
        },
        "value": {
          "description": "The value to be used within the operations.",
          "type": "object"
        }
      }
    },
    "PeerUpdate": {
      "description": "A single peer in the network.",
      "properties": {
        "id": {
          "description": "The session ID of the peer.",
          "type": "string",
          "format": "uuid"
        },
        "name": {
          "description": "Human readable name.",
          "type": "string"
        },
        "schemaHash": {
          "description": "The latest known hash of the peer's schema.",
          "type": "string"
        },
        "uri": {
          "description": "The location where the peer is exposed to the internet.",
          "type": "string",
          "format": "uri"
        }
      }
    },
    "PeerUpdateList": {
      "description": "List of known peers.",
      "type": "array",
      "items": {
        "$ref": "#/definitions/PeerUpdate"
      }
    },
    "Permission": {
      "description": "permissions attached to a role.",
      "type": "object",
      "required": [
        "action"
      ],
      "properties": {
        "action": {
          "description": "allowed actions in weaviate.",
          "type": "string",
          "enum": [
            "manage_backups",
            "read_cluster",
            "manage_data",
            "create_data",
            "read_data",
            "update_data",
            "delete_data",
            "read_nodes",
            "manage_roles",
            "read_roles",
            "manage_collections",
            "create_collections",
            "read_collections",
            "update_collections",
            "delete_collections"
          ]
        },
        "backups": {
          "description": "resources applicable for backup actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "collections": {
          "description": "resources applicable for collection and/or tenant actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "data": {
          "description": "resources applicable for data actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "object": {
              "description": "string or regex. if a specific object ID, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "tenant": {
              "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        },
        "nodes": {
          "description": "resources applicable for cluster actions",
          "type": "object",
          "properties": {
            "collection": {
              "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            },
            "verbosity": {
              "description": "whether to allow (verbose) returning shards and stats data in the response",
              "type": "string",
              "default": "minimal",
              "enum": [
                "verbose",
                "minimal"
              ]
            }
          }
        },
        "roles": {
          "description": "resources applicable for role actions",
          "type": "object",
          "properties": {
            "role": {
              "description": "string or regex. if a specific role name, if left empty it will be ALL or *",
              "type": "string",
              "default": "*"
            }
          }
        }
      }
    },
    "PermissionBackups": {
      "description": "resources applicable for backup actions",
      "type": "object",
      "properties": {
        "collection": {
          "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionCollections": {
      "description": "resources applicable for collection and/or tenant actions",
      "type": "object",
      "properties": {
        "collection": {
          "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        },
        "tenant": {
          "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionData": {
      "description": "resources applicable for data actions",
      "type": "object",
      "properties": {
        "collection": {
          "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        },
        "object": {
          "description": "string or regex. if a specific object ID, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        },
        "tenant": {
          "description": "string or regex. if a specific tenant name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PermissionNodes": {
      "description": "resources applicable for cluster actions",
      "type": "object",
      "properties": {
        "collection": {
          "description": "string or regex. if a specific collection name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        },
        "verbosity": {
          "description": "whether to allow (verbose) returning shards and stats data in the response",
          "type": "string",
          "default": "minimal",
          "enum": [
            "verbose",
            "minimal"
          ]
        }
      }
    },
    "PermissionRoles": {
      "description": "resources applicable for role actions",
      "type": "object",
      "properties": {
        "role": {
          "description": "string or regex. if a specific role name, if left empty it will be ALL or *",
          "type": "string",
          "default": "*"
        }
      }
    },
    "PhoneNumber": {
      "properties": {
        "countryCode": {
          "description": "Read-only. The numerical country code (e.g. 49)",
          "type": "number",
          "format": "uint64"
        },
        "defaultCountry": {
          "description": "Optional. The ISO 3166-1 alpha-2 country code. This is used to figure out the correct countryCode and international format if only a national number (e.g. 0123 4567) is provided",
          "type": "string"
        },
        "input": {
          "description": "The raw input as the phone number is present in your raw data set. It will be parsed into the standardized formats if valid.",
          "type": "string"
        },
        "internationalFormatted": {
          "description": "Read-only. Parsed result in the international format (e.g. +49 123 ...)",
          "type": "string"
        },
        "national": {
          "description": "Read-only. The numerical representation of the national part",
          "type": "number",
          "format": "uint64"
        },
        "nationalFormatted": {
          "description": "Read-only. Parsed result in the national format (e.g. 0123 456789)",
          "type": "string"
        },
        "valid": {
          "description": "Read-only. Indicates whether the parsed number is a valid phone number",
          "type": "boolean"
        }
      }
    },
    "Principal": {
      "type": "object",
      "properties": {
        "groups": {
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "username": {
          "description": "The username that was extracted either from the authentication information",
          "type": "string"
        }
      }
    },
    "Property": {
      "type": "object",
      "properties": {
        "dataType": {
          "description": "Data type of the property (required). If it starts with a capital (for example Person), may be a reference to another type.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "description": {
          "description": "Description of the property.",
          "type": "string"
        },
        "indexFilterable": {
          "description": "Whether to include this property in the filterable, Roaring Bitmap index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters. \u003cbr/\u003e\u003cbr/\u003eNote: Unrelated to vectorization behavior.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexInverted": {
          "description": "(Deprecated). Whether to include this property in the inverted index. If ` + "`" + `false` + "`" + `, this property cannot be used in ` + "`" + `where` + "`" + ` filters, ` + "`" + `bm25` + "`" + ` or ` + "`" + `hybrid` + "`" + ` search. \u003cbr/\u003e\u003cbr/\u003eUnrelated to vectorization behavior (deprecated as of v1.19; use indexFilterable or/and indexSearchable instead)",
          "type": "boolean",
          "x-nullable": true
        },
        "indexRangeFilters": {
          "description": "Whether to include this property in the filterable, range-based Roaring Bitmap index. Provides better performance for range queries compared to filterable index in large datasets. Applicable only to properties of data type int, number, date.",
          "type": "boolean",
          "x-nullable": true
        },
        "indexSearchable": {
          "description": "Optional. Should this property be indexed in the inverted index. Defaults to true. Applicable only to properties of data type text and text[]. If you choose false, you will not be able to use this property in bm25 or hybrid search. This property has no affect on vectorization decisions done by modules",
          "type": "boolean",
          "x-nullable": true
        },
        "moduleConfig": {
          "description": "Configuration specific to modules this Weaviate instance has installed",
          "type": "object"
        },
        "name": {
          "description": "The name of the property (required). Multiple words should be concatenated in camelCase, e.g. ` + "`" + `nameOfAuthor` + "`" + `.",
          "type": "string"
        },
        "nestedProperties": {
          "description": "The properties of the nested object(s). Applies to object and object[] data types.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/NestedProperty"
          },
          "x-omitempty": true
        },
        "tokenization": {
          "description": "Determines tokenization of the property as separate words or whole field. Optional. Applies to text and text[] data types. Allowed values are ` + "`" + `word` + "`" + ` (default; splits on any non-alphanumerical, lowercases), ` + "`" + `lowercase` + "`" + ` (splits on white spaces, lowercases), ` + "`" + `whitespace` + "`" + ` (splits on white spaces), ` + "`" + `field` + "`" + ` (trims). Not supported for remaining data types",
          "type": "string",
          "enum": [
            "word",
            "lowercase",
            "whitespace",
            "field",
            "trigram",
            "gse",
            "kagome_kr",
            "kagome_ja"
          ]
        }
      }
    },
    "PropertySchema": {
      "description": "Names and values of an individual property. A returned response may also contain additional metadata, such as from classification or feature projection.",
      "type": "object"
    },
    "RaftStatistics": {
      "description": "The definition of Raft statistics.",
      "properties": {
        "appliedIndex": {
          "type": "string"
        },
        "commitIndex": {
          "type": "string"
        },
        "fsmPending": {
          "type": "string"
        },
        "lastContact": {
          "type": "string"
        },
        "lastLogIndex": {
          "type": "string"
        },
        "lastLogTerm": {
          "type": "string"
        },
        "lastSnapshotIndex": {
          "type": "string"
        },
        "lastSnapshotTerm": {
          "type": "string"
        },
        "latestConfiguration": {
          "description": "Weaviate Raft nodes.",
          "type": "object"
        },
        "latestConfigurationIndex": {
          "type": "string"
        },
        "numPeers": {
          "type": "string"
        },
        "protocolVersion": {
          "type": "string"
        },
        "protocolVersionMax": {
          "type": "string"
        },
        "protocolVersionMin": {
          "type": "string"
        },
        "snapshotVersionMax": {
          "type": "string"
        },
        "snapshotVersionMin": {
          "type": "string"
        },
        "state": {
          "type": "string"
        },
        "term": {
          "type": "string"
        }
      }
    },
    "ReferenceMetaClassification": {
      "description": "This meta field contains additional info about the classified reference property",
      "properties": {
        "closestLosingDistance": {
          "description": "The lowest distance of a neighbor in the losing group. Optional. If k equals the size of the winning group, there is no losing group",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "closestOverallDistance": {
          "description": "The lowest distance of any neighbor, regardless of whether they were in the winning or losing group",
          "type": "number",
          "format": "float32"
        },
        "closestWinningDistance": {
          "description": "Closest distance of a neighbor from the winning group",
          "type": "number",
          "format": "float32"
        },
        "losingCount": {
          "description": "size of the losing group, can be 0 if the winning group size equals k",
          "type": "number",
          "format": "int64"
        },
        "losingDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanLosingDistance": {
          "description": "Mean distance of all neighbors from the losing group. Optional. If k equals the size of the winning group, there is no losing group.",
          "type": "number",
          "format": "float32",
          "x-nullable": true
        },
        "meanWinningDistance": {
          "description": "Mean distance of all neighbors from the winning group",
          "type": "number",
          "format": "float32"
        },
        "overallCount": {
          "description": "overall neighbors checked as part of the classification. In most cases this will equal k, but could be lower than k - for example if not enough data was present",
          "type": "number",
          "format": "int64"
        },
        "winningCount": {
          "description": "size of the winning group, a number between 1..k",
          "type": "number",
          "format": "int64"
        },
        "winningDistance": {
          "description": "deprecated - do not use, to be removed in 0.23.0",
          "type": "number",
          "format": "float32"
        }
      }
    },
    "ReplicationConfig": {
      "description": "Configure how replication is executed in a cluster",
      "type": "object",
      "properties": {
        "asyncEnabled": {
          "description": "Enable asynchronous replication (default: false).",
          "type": "boolean",
          "x-omitempty": false
        },
        "deletionStrategy": {
          "description": "Conflict resolution strategy for deleted objects.",
          "type": "string",
          "enum": [
            "NoAutomatedResolution",
            "DeleteOnConflict",
            "TimeBasedResolution"
          ],
          "x-omitempty": true
        },
        "factor": {
          "description": "Number of times a class is replicated (default: 1).",
          "type": "integer"
        }
      }
    },
    "RestoreConfig": {
      "description": "Backup custom configuration",
      "type": "object",
      "properties": {
        "Bucket": {
          "description": "Name of the bucket, container, volume, etc",
          "type": "string"
        },
        "CPUPercentage": {
          "description": "Desired CPU core utilization ranging from 1%-80%",
          "type": "integer",
          "default": 50,
          "maximum": 80,
          "minimum": 1,
          "x-nullable": false
        },
        "Endpoint": {
          "description": "name of the endpoint, e.g. s3.amazonaws.com",
          "type": "string"
        },
        "Path": {
          "description": "Path within the bucket",
          "type": "string"
        }
      }
    },
    "Role": {
      "type": "object",
      "required": [
        "name",
        "permissions"
      ],
      "properties": {
        "name": {
          "description": "role name",
          "type": "string"
        },
        "permissions": {
          "type": "array",
          "items": {
            "description": "list of permissions (level, action, resource)",
            "type": "object",
            "$ref": "#/definitions/Permission"
          }
        }
      }
    },
    "RolesListResponse": {
      "description": "list of roles",
      "type": "array",
      "items": {
        "$ref": "#/definitions/Role"
      }
    },
    "Schema": {
      "description": "Definitions of semantic schemas (also see: https://github.com/weaviate/weaviate-semantic-schemas).",
      "type": "object",
      "properties": {
        "classes": {
          "description": "Semantic classes that are available.",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Class"
          }
        },
        "maintainer": {
          "description": "Email of the maintainer.",
          "type": "string",
          "format": "email"
        },
        "name": {
          "description": "Name of the schema.",
          "type": "string"
        }
      }
    },
    "SchemaClusterStatus": {
      "description": "Indicates the health of the schema in a cluster.",
      "type": "object",
      "properties": {
        "error": {
          "description": "Contains the sync check error if one occurred",
          "type": "string",
          "x-omitempty": true
        },
        "healthy": {
          "description": "True if the cluster is in sync, false if there is an issue (see error).",
          "type": "boolean",
          "x-omitempty": false
        },
        "hostname": {
          "description": "Hostname of the coordinating node, i.e. the one that received the cluster. This can be useful information if the error message contains phrases such as 'other nodes agree, but local does not', etc.",
          "type": "string"
        },
        "ignoreSchemaSync": {
          "description": "The cluster check at startup can be ignored (to recover from an out-of-sync situation).",
          "type": "boolean",
          "x-omitempty": false
        },
        "nodeCount": {
          "description": "Number of nodes that participated in the sync check",
          "type": "number",
          "format": "int"
        }
      }
    },
    "SchemaHistory": {
      "description": "This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value OR a SingleRef definition.",
      "type": "object"
    },
    "ShardStatus": {
      "description": "The status of a single shard",
      "properties": {
        "status": {
          "description": "Status of the shard",
          "type": "string"
        }
      }
    },
    "ShardStatusGetResponse": {
      "description": "Response body of shard status get request",
      "properties": {
        "name": {
          "description": "Name of the shard",
          "type": "string"
        },
        "status": {
          "description": "Status of the shard",
          "type": "string"
        },
        "vectorQueueSize": {
          "description": "Size of the vector queue of the shard",
          "type": "integer",
          "x-omitempty": false
        }
      }
    },
    "ShardStatusList": {
      "description": "The status of all the shards of a Class",
      "type": "array",
      "items": {
        "$ref": "#/definitions/ShardStatusGetResponse"
      }
    },
    "SingleRef": {
      "description": "Either set beacon (direct reference) or set class and schema (concept reference)",
      "properties": {
        "beacon": {
          "description": "If using a direct reference, specify the URI to point to the cross-ref here. Should be in the form of weaviate://localhost/\u003cuuid\u003e for the example of a local cross-ref to an object",
          "type": "string",
          "format": "uri"
        },
        "class": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired class name here",
          "type": "string",
          "format": "uri"
        },
        "classification": {
          "description": "Additional Meta information about classifications if the item was part of one",
          "$ref": "#/definitions/ReferenceMetaClassification"
        },
        "href": {
          "description": "If using a direct reference, this read-only fields provides a link to the referenced resource. If 'origin' is globally configured, an absolute URI is shown - a relative URI otherwise.",
          "type": "string",
          "format": "uri"
        },
        "schema": {
          "description": "If using a concept reference (rather than a direct reference), specify the desired properties here",
          "$ref": "#/definitions/PropertySchema"
        }
      }
    },
    "Statistics": {
      "description": "The definition of node statistics.",
      "properties": {
        "bootstrapped": {
          "type": "boolean"
        },
        "candidates": {
          "type": "object"
        },
        "dbLoaded": {
          "type": "boolean"
        },
        "initialLastAppliedIndex": {
          "type": "number",
          "format": "uint64"
        },
        "isVoter": {
          "type": "boolean"
        },
        "lastAppliedIndex": {
          "type": "number"
        },
        "leaderAddress": {
          "type": "object"
        },
        "leaderId": {
          "type": "object"
        },
        "name": {
          "description": "The name of the node.",
          "type": "string"
        },
        "open": {
          "type": "boolean"
        },
        "raft": {
          "description": "Weaviate Raft statistics.",
          "type": "object",
          "$ref": "#/definitions/RaftStatistics"
        },
        "ready": {
          "type": "boolean"
        },
        "status": {
          "description": "Node's status.",
          "type": "string",
          "default": "HEALTHY",
          "enum": [
            "HEALTHY",
            "UNHEALTHY",
            "UNAVAILABLE",
            "TIMEOUT"
          ]
        }
      }
    },
    "StopwordConfig": {
      "description": "fine-grained control over stopword list usage",
      "type": "object",
      "properties": {
        "additions": {
          "description": "Stopwords to be considered additionally (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "preset": {
          "description": "Pre-existing list of common words by language (default: 'en'). Options: ['en', 'none'].",
          "type": "string"
        },
        "removals": {
          "description": "Stopwords to be removed from consideration (default: []). Can be any array of custom strings.",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "Tenant": {
      "description": "attributes representing a single tenant within weaviate",
      "type": "object",
      "properties": {
        "activityStatus": {
          "description": "activity status of the tenant's shard. Optional for creating tenant (implicit ` + "`" + `ACTIVE` + "`" + `) and required for updating tenant. For creation, allowed values are ` + "`" + `ACTIVE` + "`" + ` - tenant is fully active and ` + "`" + `INACTIVE` + "`" + ` - tenant is inactive; no actions can be performed on tenant, tenant's files are stored locally. For updating, ` + "`" + `ACTIVE` + "`" + `, ` + "`" + `INACTIVE` + "`" + ` and also ` + "`" + `OFFLOADED` + "`" + ` - as INACTIVE, but files are stored on cloud storage. The following values are read-only and are set by the server for internal use: ` + "`" + `OFFLOADING` + "`" + ` - tenant is transitioning from ACTIVE/INACTIVE to OFFLOADED, ` + "`" + `ONLOADING` + "`" + ` - tenant is transitioning from OFFLOADED to ACTIVE/INACTIVE. We still accept deprecated names ` + "`" + `HOT` + "`" + ` (now ` + "`" + `ACTIVE` + "`" + `), ` + "`" + `COLD` + "`" + ` (now ` + "`" + `INACTIVE` + "`" + `), ` + "`" + `FROZEN` + "`" + ` (now ` + "`" + `OFFLOADED` + "`" + `), ` + "`" + `FREEZING` + "`" + ` (now ` + "`" + `OFFLOADING` + "`" + `), ` + "`" + `UNFREEZING` + "`" + ` (now ` + "`" + `ONLOADING` + "`" + `).",
          "type": "string",
          "enum": [
            "ACTIVE",
            "INACTIVE",
            "OFFLOADED",
            "OFFLOADING",
            "ONLOADING",
            "HOT",
            "COLD",
            "FROZEN",
            "FREEZING",
            "UNFREEZING"
          ]
        },
        "name": {
          "description": "The name of the tenant (required).",
          "type": "string"
        }
      }
    },
    "TenantResponse": {
      "description": "attributes representing a single tenant response within weaviate",
      "type": "object",
      "allOf": [
        {
          "$ref": "#/definitions/Tenant"
        },
        {
          "properties": {
            "belongsToNodes": {
              "description": "The list of nodes that owns that tenant data.",
              "type": "array",
              "items": {
                "type": "string"
              }
            },
            "dataVersion": {
              "description": "Experimental. The data version of the tenant is a monotonically increasing number starting from 0 which is incremented each time a tenant's data is offloaded to cloud storage.",
              "type": "integer",
              "default": 0,
              "minimum": 0,
              "x-nullable": true,
              "example": 3
            }
          }
        }
      ]
    },
    "Vector": {
      "description": "A vector representation of the object. If provided at object creation, this wil take precedence over any vectorizer setting.",
      "type": "array",
      "items": {
        "type": "number",
        "format": "float"
      }
    },
    "VectorConfig": {
      "type": "object",
      "properties": {
        "vectorIndexConfig": {
          "description": "Vector-index config, that is specific to the type of index selected in vectorIndexType",
          "type": "object"
        },
        "vectorIndexType": {
          "description": "Name of the vector index to use, eg. (HNSW)",
          "type": "string"
        },
        "vectorizer": {
          "description": "Configuration of a specific vectorizer used by this vector",
          "type": "object"
        }
      }
    },
    "VectorWeights": {
      "description": "Allow custom overrides of vector weights as math expressions. E.g. \"pancake\": \"7\" will set the weight for the word pancake to 7 in the vectorization, whereas \"w * 3\" would triple the originally calculated word. This is an open object, with OpenAPI Specification 3.0 this will be more detailed. See Weaviate docs for more info. In the future this will become a key/value (string/string) object.",
      "type": "object"
    },
    "Vectors": {
      "description": "A map of named vectors for multi-vector representations.",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/Vector"
      }
    },
    "WhereFilter": {
      "description": "Filter search results using a where filter",
      "type": "object",
      "properties": {
        "operands": {
          "description": "combine multiple where filters, requires 'And' or 'Or' operator",
          "type": "array",
          "items": {
            "$ref": "#/definitions/WhereFilter"
          }
        },
        "operator": {
          "description": "operator to use",
          "type": "string",
          "enum": [
            "And",
            "Or",
            "Equal",
            "Like",
            "NotEqual",
            "GreaterThan",
            "GreaterThanEqual",
            "LessThan",
            "LessThanEqual",
            "WithinGeoRange",
            "IsNull",
            "ContainsAny",
            "ContainsAll"
          ],
          "example": "GreaterThanEqual"
        },
        "path": {
          "description": "path to the property currently being filtered",
          "type": "array",
          "items": {
            "type": "string"
          },
          "example": [
            "inCity",
            "City",
            "name"
          ]
        },
        "valueBoolean": {
          "description": "value as boolean",
          "type": "boolean",
          "x-nullable": true,
          "example": false
        },
        "valueBooleanArray": {
          "description": "value as boolean",
          "type": "array",
          "items": {
            "type": "boolean"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            true,
            false
          ]
        },
        "valueDate": {
          "description": "value as date (as string)",
          "type": "string",
          "x-nullable": true,
          "example": "TODO"
        },
        "valueDateArray": {
          "description": "value as date (as string)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "TODO"
        },
        "valueGeoRange": {
          "description": "value as geo coordinates and distance",
          "type": "object",
          "x-nullable": true,
          "$ref": "#/definitions/WhereFilterGeoRange"
        },
        "valueInt": {
          "description": "value as integer",
          "type": "integer",
          "format": "int64",
          "x-nullable": true,
          "example": 2000
        },
        "valueIntArray": {
          "description": "value as integer",
          "type": "array",
          "items": {
            "type": "integer",
            "format": "int64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": "[100, 200]"
        },
        "valueNumber": {
          "description": "value as number/float",
          "type": "number",
          "format": "float64",
          "x-nullable": true,
          "example": 3.14
        },
        "valueNumberArray": {
          "description": "value as number/float",
          "type": "array",
          "items": {
            "type": "number",
            "format": "float64"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            3.14
          ]
        },
        "valueString": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueStringArray": {
          "description": "value as text (deprecated as of v1.19; alias for valueText)",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        },
        "valueText": {
          "description": "value as text",
          "type": "string",
          "x-nullable": true,
          "example": "my search term"
        },
        "valueTextArray": {
          "description": "value as text",
          "type": "array",
          "items": {
            "type": "string"
          },
          "x-nullable": true,
          "x-omitempty": true,
          "example": [
            "my search term"
          ]
        }
      }
    },
    "WhereFilterGeoRange": {
      "description": "filter within a distance of a georange",
      "type": "object",
      "properties": {
        "distance": {
          "type": "object",
          "properties": {
            "max": {
              "type": "number",
              "format": "float64"
            }
          }
        },
        "geoCoordinates": {
          "x-nullable": false,
          "$ref": "#/definitions/GeoCoordinates"
        }
      }
    },
    "WhereFilterGeoRangeDistance": {
      "type": "object",
      "properties": {
        "max": {
          "type": "number",
          "format": "float64"
        }
      }
    }
  },
  "parameters": {
    "CommonAfterParameterQuery": {
      "type": "string",
      "description": "A threshold UUID of the objects to retrieve after, using an UUID-based ordering. This object is not part of the set. \u003cbr/\u003e\u003cbr/\u003eMust be used with ` + "`" + `class` + "`" + `, typically in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eNote ` + "`" + `after` + "`" + ` cannot be used with ` + "`" + `offset` + "`" + ` or ` + "`" + `sort` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eFor a null value similar to offset=0, set an empty string in the request, i.e. ` + "`" + `after=` + "`" + ` or ` + "`" + `after` + "`" + `.",
      "name": "after",
      "in": "query"
    },
    "CommonClassParameterQuery": {
      "type": "string",
      "description": "The collection from which to query objects.  \u003cbr/\u003e\u003cbr/\u003eNote that if ` + "`" + `class` + "`" + ` is not provided, the response will not include any objects.",
      "name": "class",
      "in": "query"
    },
    "CommonConsistencyLevelParameterQuery": {
      "type": "string",
      "description": "Determines how many replicas must acknowledge a request before it is considered successful",
      "name": "consistency_level",
      "in": "query"
    },
    "CommonIncludeParameterQuery": {
      "type": "string",
      "description": "Include additional information, such as classification infos. Allowed values include: classification, vector, interpretation",
      "name": "include",
      "in": "query"
    },
    "CommonLimitParameterQuery": {
      "type": "integer",
      "format": "int64",
      "description": "The maximum number of items to be returned per page. The default is 25 unless set otherwise as an environment variable.",
      "name": "limit",
      "in": "query"
    },
    "CommonNodeNameParameterQuery": {
      "type": "string",
      "description": "The target node which should fulfill the request",
      "name": "node_name",
      "in": "query"
    },
    "CommonOffsetParameterQuery": {
      "type": "integer",
      "format": "int64",
      "default": 0,
      "description": "The starting index of the result window. Note ` + "`" + `offset` + "`" + ` will retrieve ` + "`" + `offset+limit` + "`" + ` results and return ` + "`" + `limit` + "`" + ` results from the object with index ` + "`" + `offset` + "`" + ` onwards. Limited by the value of ` + "`" + `QUERY_MAXIMUM_RESULTS` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eShould be used in conjunction with ` + "`" + `limit` + "`" + `. \u003cbr/\u003e\u003cbr/\u003eCannot be used with ` + "`" + `after` + "`" + `.",
      "name": "offset",
      "in": "query"
    },
    "CommonOrderParameterQuery": {
      "type": "string",
      "description": "Order parameter to tell how to order (asc or desc) data within given field. Should be used in conjunction with ` + "`" + `sort` + "`" + ` parameter. If providing multiple ` + "`" + `sort` + "`" + ` values, provide multiple ` + "`" + `order` + "`" + ` values in corresponding order, e.g.: ` + "`" + `sort=author_name,title\u0026order=desc,asc` + "`" + `.",
      "name": "order",
      "in": "query"
    },
    "CommonOutputVerbosityParameterQuery": {
      "type": "string",
      "default": "minimal",
      "description": "Controls the verbosity of the output, possible values are: \"minimal\", \"verbose\". Defaults to \"minimal\".",
      "name": "output",
      "in": "query"
    },
    "CommonSortParameterQuery": {
      "type": "string",
      "description": "Name(s) of the property to sort by - e.g. ` + "`" + `city` + "`" + `, or ` + "`" + `country,city` + "`" + `.",
      "name": "sort",
      "in": "query"
    },
    "CommonTenantParameterQuery": {
      "type": "string",
      "description": "Specifies the tenant in a request targeting a multi-tenant class",
      "name": "tenant",
      "in": "query"
    }
  },
  "securityDefinitions": {
    "oidc": {
      "description": "OIDC (OpenConnect ID - based on OAuth2)",
      "type": "oauth2",
      "flow": "implicit",
      "authorizationUrl": "http://to-be-configured-in-the-application-config"
    }
  },
  "security": [
    {},
    {
      "oidc": []
    }
  ],
  "tags": [
    {
      "name": "objects"
    },
    {
      "description": "These operations allow to execute batch requests for Objects and Objects. Mostly used for importing large datasets.",
      "name": "batch"
    },
    {
      "name": "graphql"
    },
    {
      "name": "meta"
    },
    {
      "name": "P2P"
    },
    {
      "description": "All functions related to the Contextionary.",
      "name": "contextionary-API"
    },
    {
      "description": "These operations enable manipulation of the schema in Weaviate schema.",
      "name": "schema"
    }
  ],
  "externalDocs": {
    "url": "https://github.com/weaviate/weaviate"
  }
}`))
}
