/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

function computeLoanData(params) {
	var cpRate = parseFloat(params['cpRate']);//利息
	var rateUnit = params['rateUnit'];//year or month
	var prizeRate = parseFloat(params['prizeRate']); //奖励
	var manageRate = parseFloat(params['manageRate']);//管理费
	var limitCount = parseFloat(params['limitCount']);//期限
	var limitUnit = params['limitUnit'];//期限单位  year , day 
	var bidAmount = parseFloat(params['bidAmount']);//投资金额	 
	//A 到期还本息 //B 按季度还本息 //C 月还息到期还本 //D 按月还本息
	var monthRate = rateUnit == 'month' ? cpRate : parseFloat(cpRate)/12; monthRate = monthRate * 0.01;
	var monthCount = limitUnit == 'month' ? limitCount : parseFloat(limitCount)/30; 
	var monthCount = parseFloat(monthCount);
	var earnInter = bidAmount * monthRate * monthCount; earnInter = Math.round(earnInter * 100)/100;	

	var a_earnInter = earnInter;	
	var season = Math.ceil(monthCount/3);
	season = parseFloat(season);
	var tmpYearRate = monthRate * 12 * (1 - manageRate * 0.01);
	var tmpMonthRate = tmpYearRate/12;
	var b_earnInter =  (bidAmount * tmpYearRate * 100 * (1 + season) / 800)/(1- manageRate * 0.01);	b_earnInter = Math.round(b_earnInter*100)/100;	
	var c_earnInter = earnInter;	
	var d_earnInter = bidAmount * tmpMonthRate * Math.pow((1 + tmpMonthRate),monthCount) /(Math.pow((1 + tmpMonthRate),monthCount)- 1) * monthCount - bidAmount;	
	d_earnInter = d_earnInter / (1- manageRate * 0.01);
	d_earnInter = Math.round(d_earnInter*100)/100;
	if(limitUnit == 'day') {
		b_earnInter = earnInter; 
		c_earnInter = earnInter; 
		d_earnInter = earnInter; 
	}

	var a_manageAmount = a_earnInter * manageRate * 0.01; a_manageAmount = Math.round(a_manageAmount*100)/100;
	var b_manageAmount = b_earnInter * manageRate * 0.01; b_manageAmount = Math.round(b_manageAmount*100)/100;
	var c_manageAmount = c_earnInter * manageRate * 0.01; c_manageAmount = Math.round(c_manageAmount*100)/100;
	var d_manageAmount = d_earnInter * manageRate * 0.01; d_manageAmount = Math.round(d_manageAmount*100)/100;

	var prizeAmount = bidAmount * prizeRate * 0.01; prizeAmount = Math.round(prizeAmount*100)/100;	

	var a_total = a_earnInter - a_manageAmount + prizeAmount; a_total = Math.round(a_total*100)/100;	
	var b_total = b_earnInter - b_manageAmount + prizeAmount; b_total = Math.round(b_total*100)/100;
	var c_total = c_earnInter - c_manageAmount + prizeAmount; c_total = Math.round(c_total*100)/100;
	var d_total = d_earnInter - d_manageAmount + prizeAmount; d_total = Math.round(d_total*100)/100;
		
	var a_to_month_rate = (a_total/monthCount)/bidAmount;a_to_month_rate = Math.round(a_to_month_rate*10000)/100;
	var a_to_year_rate = a_to_month_rate * 12;a_to_year_rate = Math.round(a_to_year_rate*100)/100;
	var b_to_year_rate = (tmpYearRate * 3 + 24 * prizeRate * 0.01 /(monthCount/3+1)) / 3 * 100;b_to_year_rate = Math.round(b_to_year_rate*100)/100;
	var b_to_month_rate = b_to_year_rate / 12;b_to_month_rate = Math.round(b_to_month_rate*100)/100;
	var c_to_month_rate = (c_total/monthCount)/bidAmount;c_to_month_rate = Math.round(c_to_month_rate*10000)/100;
	var c_to_year_rate = c_to_month_rate * 12;c_to_year_rate = Math.round(c_to_year_rate*100)/100;
	var d_to_year_rate  = 24.00 * prizeRate / (monthCount + 1) + (monthRate * 12) * (1- (manageRate * 0.01)) * 100;d_to_year_rate = Math.round(d_to_year_rate*100)/100; 
	var d_to_month_rate = d_to_year_rate / 12;d_to_month_rate = Math.round(d_to_month_rate*100)/100;
	if(limitUnit == 'day') {
		b_to_month_rate = a_to_month_rate; 
		b_to_year_rate = a_to_year_rate; 
		c_to_month_rate = a_to_month_rate; 
		c_to_year_rate = a_to_year_rate;
		d_to_month_rate = a_to_month_rate; 
		d_to_year_rate = a_to_year_rate;
	}	

	var a_fl_year_rate = (Math.pow((1 + a_to_month_rate * 0.01 * monthCount), 12/monthCount) - 1) * 100;a_fl_year_rate = Math.round(a_fl_year_rate*100)/100; 
	var a_fl_month_rate = a_fl_year_rate / 12;a_fl_month_rate = Math.round(a_fl_month_rate*100)/100;
	var b_fl_year_rate = (Math.pow((1 + b_to_year_rate / 400), 4) - 1) * 100; b_fl_year_rate = Math.round(b_fl_year_rate*100)/100; 
	var b_fl_month_rate = b_fl_year_rate / 12;b_fl_month_rate = Math.round(b_fl_month_rate*100)/100;
	var c_fl_year_rate = (Math.pow((1 + c_to_month_rate * 0.01 * monthCount), 12/monthCount) - 1) * 100;c_fl_year_rate = Math.round(c_fl_year_rate*100)/100; 
	var c_fl_month_rate = c_fl_year_rate / 12;c_fl_month_rate = Math.round(c_fl_month_rate*100)/100;
	var d_fl_year_rate = (Math.pow((1 + d_to_month_rate * 0.01), 12) - 1) * 100;d_fl_year_rate = Math.round(d_fl_year_rate*100)/100; 
	var d_fl_month_rate = d_fl_year_rate / 12;d_fl_month_rate = Math.round(d_fl_month_rate*100)/100; 
	if(limitUnit == 'day') {
		b_fl_year_rate = a_fl_year_rate; 
		b_fl_month_rate = a_fl_month_rate; 
		c_fl_year_rate = a_fl_year_rate; 
		c_fl_month_rate = a_fl_month_rate;
		d_fl_year_rate = a_fl_year_rate; 
		d_fl_month_rate = a_fl_month_rate;
	}
	/*
	if(isNaN(a_total)) {
		a_to_year_rate = 0;a_to_month_rate=0;b_to_year_rate = 0;b_to_month_rate=0;	
		c_to_year_rate = 0;c_to_month_rate=0;d_to_year_rate = 0;d_to_month_rate=0;	
		a_fl_year_rate = 0;a_fl_month_rate=0;b_fl_year_rate = 0;b_fl_month_rate=0;	
		c_fl_year_rate = 0;c_fl_month_rate=0;d_fl_year_rate = 0;d_fl_month_rate=0;	
		a_earnInter = 0; b_earnInter = 0;c_earnInter = 0;d_earnInter = 0;
		a_manageAmount = 0;b_manageAmount = 0;c_manageAmount = 0;d_manageAmount = 0;	
		prizeAmount = 0; a_total = 0; b_total = 0; c_total = 0; d_total = 0; 
	}
	*/
	//A 到期还本息 //B 按季度还本息 //C 月还息到期还本 //D 按月还本息
	var result = {};
	//年化利率, 月化利率
	result['a_to_year_rate'] = a_to_year_rate; result['a_to_month_rate'] = a_to_month_rate;
	result['b_to_year_rate'] = b_to_year_rate; result['b_to_month_rate'] = b_to_month_rate;
	result['c_to_year_rate'] = c_to_year_rate; result['c_to_month_rate'] = c_to_month_rate;
	result['d_to_year_rate'] = d_to_year_rate; result['d_to_month_rate'] = d_to_month_rate;
	//复利 年利率, 复利 月利率
	result['a_fl_year_rate'] = a_fl_year_rate; result['a_fl_month_rate'] = a_fl_month_rate;
	result['b_fl_year_rate'] = a_fl_year_rate; result['b_fl_month_rate'] = a_fl_month_rate;
	result['c_fl_year_rate'] = a_fl_year_rate; result['c_fl_month_rate'] = a_fl_month_rate;
	result['d_fl_year_rate'] = a_fl_year_rate; result['d_fl_month_rate'] = a_fl_month_rate;
	//利息金额
	result['a_earnInter'] = a_earnInter; result['b_earnInter'] = b_earnInter;
	result['c_earnInter'] = c_earnInter; result['d_earnInter'] = d_earnInter;
	//管理费
	result['a_manageAmount'] = a_manageAmount; result['b_manageAmount'] = b_manageAmount;
	result['c_manageAmount'] = c_manageAmount; result['d_manageAmount'] = d_manageAmount;
	//奖励金额
	result['prizeAmount'] = prizeAmount;
	//总收益
	result['a_total'] = a_total; result['b_total'] = b_total;
	result['c_total'] = c_total; result['d_total'] = d_total;
	return result;
}

