---
description: >-
  Companies are looking for someone who can add value as soon as possible and
  who will be able to grow with the organization.
---

# What companies want

## Understanding their perspective

Now that you've figured your own situation out, the fact is that you can't get hired by just thinking about why _you_ need or deserve the job. You have to think about things from the perspective of the company. Why are they interested in hiring you? What, therefore, will they look for?

## Life behind the curtain

Hiring managers are busy people. That's why they need someone new... to remove some of their workload and get their team working better or faster. They also have to deal with potentially hundreds of unqualified applicants every week, which takes up too much of their valuable time. They just want to get back to building stuff and not have to hire again anytime soon. So they are looking for someone who can **add value as soon as possible** and who will be able to **grow with the organization.**

The second characteristic, growth, is something you shouldn't have much trouble selling if you've come this far and learned web development on your own. The key is to present yourself as a growth curve, not just a static line \(i.e. you'll continue learning and improving very rapidly and not stop\). You have real career goals and you've learned incredibly fast so far to get to where you are \(right?\).

The first part, adding value immediately, is more difficult -- that's where they want to see that you've had relevant experience before and can meet their technical bar. There's a bit of a catch-22 with getting hired -- the easiest way to show you are employable is to have been employed before. It's a check mark next to you. So to cater to this; do whatever you can to show that other people have believed in you enough to use your work and skills.

Aside from those two characteristics, there is another major factor -- fit. The hiring manager wants someone they and their team can work well with. All the other stuff represents minimum hurdles for being considered. But you often make or break your chances by being someone the team members want to know better and work with all day long. Almost all hiring processes ask the full team to evaluate a late-stage candidate.

So to summarize, hiring managers are usually looking for 3 main things:

1. Capability
2. Motivation
3. Fit

You can learn a bit about the perspective of hiring managers by reading blog posts about how to hire developers. No need to go crazy, but try to get a picture of why they're hiring you:

1. [The Best Way to Hire Software Developers](http://insights.dice.com/2013/05/31/hiring-software-developers/)
2. [How to Hire Talent](http://lifeofaprogrammanager.blogspot.com/2006/06/how-to-hire-talent.html)
3. [Joel Spolsky has a lengthy diatribe on hiring developers](http://www.joelonsoftware.com/articles/FindingGreatDevelopers.html), which should give you an idea of the need and pain of hiring great engineers.
4. [Joel Spolsky's Guerrilla Guide to Interviewing 3](http://www.joelonsoftware.com/articles/GuerrillaInterviewing3.html).  Look for "people who are 1. Smart, and 2. Get things done".
5. [Beyond a Resume: What Tech Recruiters Want](http://blog.udacity.com/2013/09/beyond-resume-what-tech-recruiters-want.html)

## Internships

A good way to start getting experience and show others that you're employable is to get an internship. Just make sure it's a paid internship because no one values things they get for free. You want the people you work with to value your contributions and feel like they have a stake in helping you succeed. The good part is that internships tend to focus more on your growth potential than what you've done before, so you can start to avoid that chicken-and-egg problem described above.

The hiring process for internships is usually similar to but not quite as rigorous as full-time positions. Internships are basically just long interviews by that company to see if they want to bring you on full-time.

These should be useful links for you:

* [Thread on "How do I get a Software Internship" from MetaFilter](http://ask.metafilter.com/226621/How-do-I-get-a-software-internship)
* [InternMatch](https://www.wayup.com/s/internships/it/)

