---
description: >-
  You should have at least an informal list of the things that matter to you.
  Now ruthlessly rank them. What are your non-negotiables and what are your
  nice-to-haves?
---

# Get yourself together

## It's all about you

This lesson is all about getting yourself together because if you don't understand yourself then you won't be happy with where you end up. Take a minute to think inwards, it's worth it.

## Where are you now?

Without defining what your own needs are, you will have no way of determining the right path forward so hunker down until you've got an idea of what your key needs are right now \(from a job\). The questions below should help you think about what is actually essential for you versus nice-to-have. Ask yourself:

* Why do I _need_ a job?
* What kind of salary level do I need to sustain myself and my family?
* What kind of job security level do I need to sustain myself and my family?
* How desperate am I to get a job _right now_?

## Where do you want to be?

Once you've been honest with yourself about your needs, it's time to figure out what you _want_. What will your future needs be? What kinds of companies do you want to work at?

* Why do I _want_ a job in web development?
* What kind of career path do I want to have?
* Do I want to work in a developer-led organization \(vs sales- or business-led\)?
* Do I prefer working in a team environment or remotely?
* Do I like working long hours / weekends or 9-6?
* Is the work more important than the people?
* Do I have to care about the product I'm building?
* Do I have to care about the technologies I'm using?
* Do I prefer an "easy" work environment or one where I'm constantly pushed?
* Do I want "creature comfort" incentives like free food and beer at the office?
* Do I have to enjoy my work or can I power through a crappy job?

## Prioritizing needs and wants

You should have at least an informal list of the things that matter to you. Now ruthlessly rank them. What are your non-negotiables and what are your nice-to-haves? Every company and opportunity will fall somewhere on the spectrum defined by those questions and they are the criteria you will later use to evaluate them. This will help you stay focused when considering opportunities and not spread yourself too thin chasing things that you wouldn't really choose anyway.

Make sure you know every one of your "must-haves" and your top 5 priorities for "nice-to-haves" in a job.

## What are your assets and liabilities?

It's time to be honest with yourself... what do you bring to the table? If you're early in your career \(which you probably are\), you'll have to work hard to distinguish yourself from the flood of unqualified candidates out there. You need to strike the line between being honest with yourself and not selling yourself short. Everyone, especially those just starting out, feels unqualified. That's natural, so don't worry about it. This is about figuring out your strengths and weaknesses so you can tailor your story to play to your strengths and honestly address your weaknesses.

Some questions to ask \(which you'll probably hear again in your early interviews\):

1. How hungry am I?
2. How good am I at building backend code?
3. How good am I at putting together frontends?
4. Can I solve really technical problems like brain teasers and algorithms?
5. Have I built projects that display a good range of skills?
6. Do I know people who can recommend me?
7. Am I a good people person who builds relationships easily?
8. Do I portray an aura of confidence or act shy?
9. Do I tend to undersell myself and my capabilities?
10. Do I have a broad level of general tech knowledge?
11. Am I very familiar with a particular technical or industry vertical? \(Usually career switchers have one\)
12. Do I tend to procrastinate or do I just get shit done?
13. Do I wait to ask for help or do I go out and find the answer on my own?
14. Do I lean in to challenges or avoid them?
15. What are some really difficult problems I've solved before?

Applying without much experience means you need to fill in your weak spots and emphasize your strengths. For almost everyone, your biggest strength will be hunger and ability to learn. But companies have heard that story before, so you'll have to tie in other strengths that you can to make your story compelling.

A quick note -- there is a difference between hunger for opportunity and desperation. Hunger is about seeking reward \(which you can do when you're in a comfortable situation and optimizing opportunities\) and desperation is about avoiding failure \(which occurs when you absolutely MUST have that job\). Do whatever it takes to not sound desperate, even if you are.

