---
description: >-
  You'll want to figure out the questions you might expect to be asked (and the
  general responses you'll have for each which demonstrate your brilliance) and
  you'll want to research the company too.
---

# Preparing for an interview

## Be prepared

Interviewing is right up there with public speaking in the hierarchy of fears for most people. Not only are you performing for someone else but they're actively judging you the whole time... yikes!

Far be it from us to try and get you over that psychological hurdle but it's definitely best if you can actually treat the interviews as a chance to show off the cool stuff you've built and the interesting new skills you've learned. The best interviews are enthusiastic conversations with technical depth.

The first step before everything is to prepare. You'll want to figure out the questions you might expect to be asked \(and the general responses you'll have for each which demonstrate your brilliance\) and you'll want to research the company too. Your knowledge of the company will help you tailor your pitch to their needs and also allow you to ask intelligent questions about their product and technology when the time comes. Again, refer to the [Happy Bear article](http://web.archive.org/web/20160925155912/http://www.happybearsoftware.com/how-to-get-a-programmer-job.html) for some great tips.

## Example interview timeline

Here's an overview of the process a typical tech company might go through when hiring developers:

1. Phone screen
2. Technical interview
3. Technical challenge
4. Fit interviews
5. Job offer
6. Offer negotiation
7. Offer acceptance

### The phone screen

Congratulations! Your resume wasn't a total train-wreck and they've invited you for a phone screen \(note -- sometimes you actually do the tech challenge first\). The real purpose of this screen, which is often roughly a half hour with someone from Human Resources \(not the actual hiring manager\), is to make sure you've got a good chance of passing their technical interview and fit interviews. So consider it a light version of each of these.

You'll probably be asked about some of the technical things you've listed on your resume but not actually dive into the depths \(though some places do a brain teaser too\) and you'll probably be asked some more "softer" questions about why you chose the job and what you've done before. Companies vary widely in how they use the phone screen. The basic tactic here isn't a tactic -- be honest and enthusiastic and open. And don't be afraid to practice talking about yourself in front of the mirror.

**FINAL NOTE** -- this is not one-size-fits-all and many companies skip the light stuff and dive right into a technical screen so you've got to be prepared just in case! The Coding Horror link below is more descriptive about that case.

* [Mastering the phone screen by Monster](http://career-advice.monster.com/job-interview/interview-preparation/mastering-the-phone-interview/article.aspx)
* [7 Steps for Mastering the Telephone Interview](http://dorigan.com/how-to-interview/mastering-telephone-interview/)
* [A much more technical phone screen from Coding Horror](http://www.codinghorror.com/blog/2008/01/getting-the-interview-phone-screen-right.html)

### The technical interview

The technical interview is usually the most terrifying part of the interview process. It's where they will assess whether you've got the technical chops to make it. That means you'll not only be asked very specifically about the work you've done, but also to solve logic problems or code live or whiteboard some new features.

In fact, one point of the interview is often to push you to your limit just to see how you react to not knowing something. If you do an exercise too easily, they'll go to a much harder one. Especially as a beginner, you will hit a lot of stumbling points. The biggest asset you have is honesty and intellectual curiosity.

When solving a problem, make sure to do so in a clear and logical way, explaining out loud why you're doing each step. Talk through your roadblocks and give examples of how you'd find the solution in the "real world". Often, that answer would be to Google for some particular function. Say so! They know you're not a Ruby expert, but they need to know that you'll be able to seek out solutions to the problems you'll inevitably encounter on the job.

It's also totally okay to use a brute force \(inefficient\) solution to a coding problem. That's often the best place to start, just so you can be sure you've got the right feel for the problem. You'll usually be asked how you can make the solution better, but that's much better than trying for a brilliant solution and running out of time with no work to show for it. Again, your job isn't to be brilliant as much as to be adaptable and thoughtful in the face of challenges.

And if you don't know something, it's better to say so and work with your interviewer to figure it out. Trust me, they want you to succeed as much as you do because there's nothing tougher as an interviewer than seeing someone silently crashing on a problem and getting more and more frustrated but not asking for help or providing any window into their thoughts.

You'll need to read up on a variety of things that weren't focused on in the previous few courses, including data structures and algorithms, they're sometimes favorite targets of interviewers. They may not be great indicators of coding skill, but the world is stuck in its ways and you'll be asked those more "Computer Science-y" questions.

#### Technical interview practice resources

* [8 Queens](http://jetheis.com/blog/2013/12/01/programming-interview-question-eight-queens/) is a classic problem.
* [Coding for Interviews: Know Thy Standard Libraries](http://blog.codingforinterviews.com/reading-code-standard-libraries/) may be a bit of overkill for a junior, but never hurts if you've got the time.
* [Project Euler](http://projecteuler.net/) has more generic and challenging problems that must be solved efficiently \(they can be very computationally intensive\).
* [Code Wars](https://www.codewars.com) has programming problems and examples of best practice. Join 'The Odin Project' clan for allies.
* [Coding Bat](http://codingbat.com/) has practice questions in Java and Python.
* [HackerRank](https://www.hackerrank.com/) provides challenges, drills, and competitions on algorithms and data scructures.

#### Algorithms training

* [Udacity course on Algorithms](https://www.udacity.com/course/intro-to-algorithms--cs215) \(asynchronous\)
* [Coursera course on Algorithms](https://www.coursera.org/course/algo) \(semi-synchronous\)
* [Visualgo](https://visualgo.net/) visualizes many common algorithms to help better understand data structures and algorithms.

#### Architecture

* [Teaching Software Architecture with GitHub](http://avandeursen.com/2013/12/30/teaching-software-architecture-with-github/)

### Take-home challenges

A take-home tech challenge may occur before or after the in-person screen, depending on the company. They will give you an application or problem which will take up to a full day to complete on your own time. Examples of take-home tech challenges include building out a sample web app with tests or solving a challenging algorithmic problem using code.

They'll evaluate you on the completeness of your solution and the quality of your code. If it occurred before the technical interview, it's a good mechanism for them to test your commitment \(up to half of people never even turn in a solution\).

### Final step: "Fit"

The final step before the final decision is usually to meet the whole team and get put through the paces at their offices over the period of several hours. They'll probably test you technically but the goal is also to make sure you'd be a good person to work with. If any one member of the team doesn't think you'd be a good fit, you usually won't be hired. Advice? Don't be weird or awkward even if you are at home. :\)

It's also a chance for you to test them out. If you've gotten this far in the process, there's a reasonable likelihood that you've got a good match. You'll need to figure out if this is the kind of company you want to work for so bring a list of questions and make sure they get answered.

## Compensation

Do. Not. Provide. Compensation. Expectations.

Companies will always ask you "how much do you expect to get paid". Your answer? "I expect to get paid a fair market rate". There's nothing you can possibly gain from providing an expectation for compensation. If it's lower than what they would have offered you, you just capped what they'll offer you. If it's higher, they may just scuttle the process because you're too expensive.

Once you have an offer, you can check it against fair market rate by asking other people \(hopefully you've got some people by now who you might ask\) or going to [Glassdoor](http://glassdoor.com) \(just remember you're a brand new developer you might get below "average"\). But the real point is to not shoot yourself in the foot when they ask.

