---
description: Learn everything you need to know about applying and interviewing for a job.
---

# Applying and interviewing

## Time to find opportunities

You've moved beyond the preparation and knowledge gathering phase. Now it's time to hit the pavement and approach the actual jobs.

Organization is key here and a spreadsheet is highly recommended. Keep track of not just the jobs themselves, but also their websites, any connections you have to the company, and a log of your activity. Have a separate column for each "Must Have" criteria you identified in the earlier section \(use a binary `true`/`false`\) and each of the top 5 "Nice To Have" criteria \(use a 3- or 5-point system\) so you can quickly check off where the jobs rank.

Put any job opening you find into your spreadsheet.

## The best places to look

Start with your network, even if it's small. Reach out to your Facebook friends and friends-of-friends to see if anyone's hiring. You should start your search with the highest probability / highest quality sources first:

1. Your network \(including people you've met in the community\)
2. Direct postings that go to a human \(like when developers \[not recruiters\] send emails about job opening at their company to the local Ruby list\).  It's important to have another human being on the other end of the emails.
3. Direct postings \(like on a company website for a specific position\).  These will also usually go to a specific human being.
4. Job boards \(pretty much awful, you're in the herd now\)

Try checking out these links for job boards. The more technically-focused, the better:

* [Authentic Jobs](http://www.authenticjobs.com)
* [StackOverflow Jobs](https://stackoverflow.com/jobs)
* [CWJobs](http://cwjobs.co.uk)
* [GitHub Jobs](https://jobs.github.com/)
* [White Truffle -- Weighted towards startups right now](http://www.whitetruffle.com)
* [Dice.com](http://www.dice.com)
* [Coderwall.com](http://coderwall.com) lets you display your engineering prowess and they can come to you.
* [Join-Startups](https://underdog.io/) - open startup jobs in a dozen cities
* [Work-At-A-Startup](https://www.workatastartup.com/) - Y-Combinator Startups
* [Hubstaff-Talent](https://talent.hubstaff.com/) - for freelancers and remote

## Using recruiters

There are a lot of recruiters out there whose job it is to get you hired, but you'll need to be careful about how you work with them. For starters, they get paid based on a percentage of the salary you take, so their incentive is to get you paid as much as possible \(which is good\). Unfortunately as a junior developer your salary is much lower than a senior engineer so you will not be their priority and they won't spend much time on you \(which is bad\).

If you're approached out of the cold as a junior developer by a recruiter, chances are that they won't be going out of their way to learn your story and find you the right fit -- you're more likely to get put in the pile of resumes they send out to everyone. You probably don't yet have work experience that is salable enough for them to go out of their way to find you the right position. In that case, you may find them sending out your resume to everyone just in hopes that they get their 20-30%. Remember -- if they approached you in a spammy way \(e.g. through LinkedIn\), they probably do the same to companies so it's doubtful they'll add value to you.

As you become more senior and your work is more unique, recruiters can add a lot of value to your career by understanding the potential market for you and opening doors you may not otherwise have found \(so don't get down on them yet!\). As a junior, you're unfortunately more of a commodity, so you probably won't find value in working with recruiters yet. Rely on your own ability to hustle and sell yourself.

