---
description: >-
  With what you now know you could start putting together some basic websites,
  but we're here to help you get a lot further than that!
---

# Next steps

## You did it

That was quite a journey. Take a second and reflect on the fact that you've just learned the basics of at least three different languages and, if you had to, you could probably hack together a web page on your own already.

You should be fairly comfortable typing commands into your computer's command line and you should understand what happens when you enter a web address into your browser and it returns a functioning page. You should be able to create a basic web page and make it do some basic things with JavaScript. You should understand the purpose of backend code and how frameworks make it easier to write clean and maintainable code. Finally, you should have a clear understanding of how all this fits together in your future as a builder of web applications.

With what you know already you could start putting together some basic websites, but we're here to help you get a lot further than that. We want to bring you to the point where you can confidently build a full-featured and scalable web application, either on your own, or working as a developer in a top-tier tech company.

You've come a long way up the learning curve but there is so much more cool stuff that you'll learn to do, and now is the time to decide which path you want to take. Either Ruby with Ruby on Rails or JavaScript with Node/Express. Both paths will guide you in building skills, building up a portfolio of projects, and becoming a great developer. There is no right answer here on what is the next best path. Learning multiple languages can help you become a well rounded developer, but sticking with one could make you more of an expert in the language itself. Both paths will help you become a great developer. The important thing is to not switch halfway though, this will only set you back.

Learning how to program is **much** more than just learning a language. It's about learning how to research and solve difficult problems, building an engineering mindset, working on complex problems and codebases, communicating effectively with other developers, and **much** more. Luckily, all these skills are transferrable to other languages and domains of software and because most languages are similar in concept and structure, moving into a different language will be much easier than learning your first.

Arguments about learning the languages used in your area may sound convincing, but because a _good_ developer can transfer skills easily, what you learn isn't going to massively change outcomes of getting a job. Though, if you cannot shake that fear, do whatever you need, even if that includes researching your area to see what jobs are available locally \(don't forget about remote jobs though\). A good course is far more important than the language you learn first.

To help you make a decision, here are some perks of each technology:

## **Ruby and Ruby on Rails:**

* Opinionated 
  * You don't have to make decisions on the structure of your projects. This helps when moving into projects built by others.
  * You will learn things "The Ruby Way", which can help you write clean code in other languages as well.
* Elegant
  * Brings a lot of tools to help you develop things in a way that makes your code easy to read.
  * Often times, solutions in Ruby are much more concise than other languages.
* Rapid development
  * Rails helps you build applications very quickly, this means you can make a greater amount of interesting projects in the same time frame as others.
* Single paradigm
  * OOP is the Ruby way, many other languages are primarily OOP based.

## **JavaScript, Node and Express**

* Un-opinionated
  * There is no standard way of doing things, you are going to have to decide the structure of projects yourself, for better or worse.
* Very fast
  * Because JavaScript is JIT compiled, it can do calculations very quickly.
* Verbose
  * There is no magic involved with these technologies. You will have to understand everything to make sense of it. 
  * Helps you get closer to how the computer is actually reading your code.
* Same language on both frontend and backend
  * Keeping the language consistent can help with writing consistent code across your entire application.
  * Allows you to do some cool things, like writing code that runs on both the browser and the server for optimization purposes.

In the end, it doesn't matter which path you take, it's only important that you stick with it, and continue to hold onto the learner's mindset throughout your career. [Not convinced?](https://medium.com/@bycdiaz/choosing-the-right-language-a-short-guide-on-how-not-to-ruin-your-career-2b353be1371)

Get ready, because this is only the beginning. Now it's time to delve deeper into the areas covered by Foundations. There are some fantastic projects in the courses that follow which will challenge you to the limit, but you'll come out the other side ready to go and make your mark in the programming world.

The journey has just begun!

