---
description: >-
  Developer tools save you lots of time by helping you debug and analyze the
  effects of code in relation to web pages.
---

# Using Developer Tools

## Overview

Knowing how to use the Developer Tools inside your browser is an important skill for any web developer. The Developer Tools are useful for running JavaScript code, editing HTML and CSS styles without having to refresh the page, and viewing performance data. They also save you lots of time. Getting started couldn't be any easier. You should already be familiar with using them for debugging and working on HTML and CSS, so let's take a look at how they can benefit us when writing JavaScript.

## Opening Dev Tools

There are three ways to open the Developer Tools menu:

1. From the Browser Menu:
   * Chrome: Select the `Chrome Menu` &gt; `More Tools` &gt; `Developer Tools`
   * Firefox: Select the Firefox `Menu` &gt; `Web Developer`&gt; `Toggle Tools`  
2. Right-click anywhere on a webpage and select `Inspect`
3. Use the keyboard shortcut `F12` or `CTRL + Shift + C` \(`option + command + C` on Mac\)

## Assignment

Head to the [Chrome DevTools Documentation](https://developers.google.com/web/tools/chrome-devtools/) by Google. The following subsections cover what you'll be using the Developer Tools for 95% of the time.  Feel free to skip the elements you are already familiar with:

* Open DevTools
* CSS
  * View and change CSS
  * CSS features reference
* Console
  * Console overview
* Mobile Simulation
  * Simulate mobile devices with Device Mode
* Get Started With Viewing And Changing The DOM
* JavaScript

  * Debug JavaScript
  * Pause your code with breakpoints

...then, watch [this video](https://www.youtube.com/watch?v=JzZFccCEgGA) by The Net Ninja for more detail on using the JavaScript Console.

## Additional resources

1. Learn 14 tips and tricks in this [JavaScript 30 Video](https://www.youtube.com/watch?v=xkzDaKwinA8) by Wes Bos
2. Learn the new Firefox Dev Tools in this [Video](https://youtu.be/yznVkCuohGg) by Wes Bos

