---
description: 'Learn the basics about strings, booleans and conditionals in JavaScript.'
---

# Strings and Conditionals

## Overview

There are a few extremely common types of data that you will encounter in JavaScript, and these fundamentals lessons will give us a really strong foundation in all of them. Before we start digging deep, however, [this article](http://javascript.info/types) will give you a quick overview of the most common ones.

## Learning outcomes

Look through these now and then use them to test yourself after doing the assignment:

* What are the eight data types of javascript?
* Which data type is NOT primitive?
* What is the difference between single, double, and backtick quotes for strings?
* Which type of quote lets you embed variables/expressions into a string?
* How do you embed variables/expressions into a string?
* How do you escape characters in a string?
* What is the difference between slice/substring/substr?
* What are methods?
* What are the three logical operators and what do they stand for?
* What are the comparison operators?
* What is nesting?
* What are truthy and falsy values?
* What are the falsy values in JavaScript?
* What is the syntax for an if/else conditional?
* What is the syntax for a switch statement?
* What is the syntax for a ternary operator?
* What is the relationship between null and undefined?
* What are conditionals?

## Strings

Depending on what kind of work you're doing, you might end up working more with pieces of text rather than numbers. A **string** is simply a piece of text... and is a fundamental building block of the language.

1. Read and code along with [yet another MDN tutorial](https://developer.mozilla.org/en-US/docs/Learn/JavaScript/First_steps/Strings) on the topic.
2. Go through [this lesson](https://www.w3schools.com/js/js_string_methods.asp) to learn a bit more about what you can do with strings... be sure to do the exercises at the end!
3. Vocabulary time: a **method** is a bit of functionality that is built into the language or into specific data types. In [the previous W3Schools exercise](https://www.w3schools.com/js/js_string_methods.asp), you learned a few methods that can be used on strings, such as `indexOf` and `search`. An exhaustive list of methods that can be used on strings can be found [here](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String).

## Conditionals

Now it's time for the fun stuff... So far we haven't done much with our programming that you couldn't do with simple math skills. Sure, we've told our computer how to do the math, so that makes it quicker, but the essence of programming is teaching the computer how to make decisions in order to do more involved things. Conditionals are how we do that.

1. Step one in learning about conditionals is making sure you have a good grasp on [comparisons](http://javascript.info/comparison).
2. [This tutorial](https://www.w3schools.com/js/js_if_else.asp) is a great first glance at conditionals in JavaScript.
3. [This tutorial](http://javascript.info/logical-operators) will teach you about logical operators.
4. [This article](https://developer.mozilla.org/en-US/docs/Learn/JavaScript/Building_blocks/conditionals) reinforces the concept and provides several interesting examples of how you could use it building websites.
5. [This article](http://javascript.info/ifelse) covers the same basic concept \(read through it as a review!\) and - more importantly - offers the usual 'tasks' at the bottom of the page!
6. [This tutorial](https://www.digitalocean.com/community/tutorials/how-to-use-the-switch-statement-in-javascript) teaches you about the `switch` statement, which comes in handy when you have multiple conditions.

## Practice

To give you a good bit of practice, we have created some repl.it exercises for you to play with. We believe that it's best to practice programming on your _own_ computer, rather than in an online environment, but we'll get to that soon enough.

Be sure to do the lessons in order presented here. Pressing "run" at the top will run the code. Read all directions, watch the terminal, and read all the errors. Don't forget to use 'console.log' extensively.

To get started, create a free repl account and click "Fork" in order to have access to the exercises. Note: Feel free to browse the files on the left column in order to gain familarity with it.

* [Exercise 1](https://repl.it/@I3uckwheat/troubleshooting#troubleshooting.js)
  * In this exercise, you will be working out of the file called troubleshooting.js
* [Exercise 2](https://repl.it/@I3uckwheat/enter-a-number#script.js)
  * You will be working out of script.js 
* [Exercise 3](https://repl.it/@I3uckwheat/lets-do-some-math#math.js)
  * You will be working out of math.js  
* [Exercise 4](https://repl.it/@I3uckwheat/direction-follow#follow.js)
  * You will be working out of follow.js

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [The Net Ninja's Regular Expressions Tutorial](https://www.youtube.com/playlist?list=PL4cUxeGkcC9g6m_6Sld9Q4jzqdqHd2HiD)

