---
description: >-
  Learn the basics about objects and more detailed ways to leverage arrays in
  JavaScript.
---

# Objects and More Arrays

## Objects

Objects are a _very_ important part of the JavaScript language, and while for the most part you can accomplish simple and even intermediate tasks without worrying about them, any real project that you're going to attempt is going to feature Objects. The uses of Objects in JavaScript can get deep relatively quickly, so for the moment we're only going to cover the basics. There'll be an in-depth dive later.

1. [This JavaScript.info](http://javascript.info/object) article is the best place to get started with Objects.
2. [The MDN tutorial](https://developer.mozilla.org/en-US/docs/Learn/JavaScript/Objects/Basics) isn't bad either, so check it out if you need another take on the subject.

## More arrays

Besides being a quick and handy way to store data, arrays also have a set of functions for manipulating that data in very powerful ways. Once you begin to master these functions you will start to see ways to use them all over the place! There are really only a handful of these functions... but as you'll soon see, the possibilities of what you can do with them are near endless.

1. Start out by watching [this video](https://www.youtube.com/watch?v=HB1ZC7czKRs) from Wes Bos. To follow along, use your local Javascript30 repository. If you don't have the repo yet, clone it from [here](https://github.com/wesbos/JavaScript30).
2. Watch and code with [Part 2](https://www.youtube.com/watch?v=QNmRfyNg1lw) of Wes Bos's array series.

## Practice

You have been through a _ton_ of content, and it would not be surprising if you were feeling rather overwhelmed at this point. Let's take a little time to slow down and practice this stuff with more coding exercises. I'll warn you now: some of these get pretty difficult, but if you've done the lessons you should have covered everything you need to know to solve them. Don't be afraid to go back and review if you find that you can't remember something, that's part of the process.

## Assignment

At this point you just need a little more practice! Go back to the [JavaScript exercises](https://github.com/TheOdinProject/javascript-exercises) that were introduced in Arrays and Loops and complete the following:

* calculator
* palindromes
* fibonacci
* getTheTitles
* findTheOldest

Solutions for the exercises can be found in the 'solutions' branch of the repo.

