---
description: >-
  In this course, "Foundations" you'll take a journey through the entire
  spectrum of topics that you will eventually need to know.
---

# Motivation and mindset

## Time to build

Learning to code is incredibly rewarding but can also be difficult and frustrating. The strongest assets you can have are a desire to build, a problem-solving mind, and persistence in the face of setbacks.

The web development industry has a long history of successful developers with varying backgrounds, so people tend to care more about what you've actually **built** than how you got there.

Read [this comprehensive blog post from Happy Bear Software](http://web.archive.org/web/20160925155912/http://www.happybearsoftware.com/how-to-get-a-programmer-job.html) about the journey to getting hired as a brief introduction to what you will face ahead.

## Why read this?

There are plenty of other online curricula for beginners, but they are often taught in an extremely isolated and controlled environment and cover only a specific topic.

This curriculum takes a realistic view of what you need to know and has you set up and work in your own environment, much like what you'll be doing when you get a job.

It acknowledges that you need a wide variety of skillsets and languages to reach an employable level.

This curriculum is constantly evolving because of people like you who get further along in the curriculum and pay it forward by incrementally improving our content over time.

Once you start to feel comfortable with the tools, start hacking on open source projects. The more you contribute, the more you will learn about what you can do, and the closer you will get to being hireable. These projects will also look great on your resume!

## Conclusion

Hopefully, you've gained a better idea of what a web developer actually does and what your life might look like if you decided to take it on as a career. This has only been a teaser into the world of web development.

In this course, "Foundations" you'll take a journey through the entire spectrum of topics that you will eventually need to know. This course jumps around to a variety of topics that you may be totally unfamiliar with, providing you a small taste of each and then moving on.

The following courses will dive deep into these topics. You will build dozens of scripts, projects, and websites to cement those skills that will get you hired.

Getting all the way there is going to be challenging. In fact, you should check out the post ["Why Learning to Code is **So Damn Hard**"](http://www.vikingcodeschool.com/posts/why-learning-to-code-is-so-damn-hard) so you have a good idea of what the journey ahead is like. But what worthwhile thing is truly easy?

Yes, it's going to be challenging.

But it's also going to be fun.

And it might even be life changing, too.

_What are you waiting for?_

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Quora: How can I Become a Really Good Web Developer?](http://www.quora.com/Computer-Programming/How-can-I-become-a-really-good-Web-Developer-starting-from-now-at-age-20-before-age-25)
* [Quora: What makes a great web developer?](http://www.quora.com/What-makes-a-great-web-developer)
* [Jared the Nerd: What makes a good web developer?](http://jaredthenerd.com/2013/05/What-Makes-A-Good-Developer/)
* [FreeCodeCamp: Things I Wish Someone Had Told Me When I Was Learning How To Code](https://www.freecodecamp.org/news/things-i-wish-someone-had-told-me-when-i-was-learning-how-to-code-565fc9dcb329/)
* [TechCrunch: Don't Believe Anyone who Tells you Learning to Code is Easy](http://techcrunch.com/2014/05/24/dont-believe-anyone-who-tells-you-learning-to-code-is-easy/): it's okay if it's really frustrating.
* [Code Quizzes: Deliberate Programming Practice](https://codequizzes.wordpress.com/2013/04/28/deliberate-programming-practice/)
* [Roadmap to becoming a web developer in 2021](https://github.com/kamranahmedse/developer-roadmap)

