---
description: >-
  Learning web development will be a long and arduous journey, but you can make
  the marathon a lot more fun by pairing up with others.
---

# Join a supportive community

## Connecting with others

Working and collaborating with other people is an important part of working as a web developer. The Odin Project, which the open curriculum that this GitBook is based on, encourages you to participate in their online chat community, which we'll talk more about below. By joining the community, you can grow alongside other Odinites \(Odin Project users\) and help each other learn web development. While you're at it, you can check out their [Facebook page](https://www.facebook.com/theodinproject/), [follow them on Twitter](https://twitter.com/TheOdinProject) and catch up on [Instagram](https://www.instagram.com/theodinproject/). Use \#TheOdinProject to share your progress, updates, thoughts and to see what other learners are up to!

## Why a community is awesome for you

Learning web development will be a long and arduous journey, but you can make the marathon a lot more fun by pairing up with others. Connecting with fellow learners is a great way to bounce ideas off each other and motivate one another to keep going. Furthermore, helping others that are a few steps behind you is a great way to deepen your own understanding and make your learning stick.

When you're slogging through the [desert of despair](https://www.thinkful.com/blog/why-learning-to-code-is-so-damn-hard/), where your code doesn't work or even make sense to you anymore, you can find an oasis of knowledge and encouragement in our community. Veterans at The Odin Project love to help fill in knowledge gaps and provide new insights and perspectives on how to improve your code. We've all been there before!

Remember that project you struggled so hard to figure out and that you're so proud of finishing? Through our community, you will get to share your work and progress with those who fully appreciate how much hard work went into it.

## Why a community is awesome

We are working hard to update existing lessons and produce new content, so we would love to hear your feedback on the lessons and projects. We hope you find the lessons fun, engaging, and informative and find the projects challenging but achievable. So please let us know your thoughts!

## Before asking for help

As most of the projects are designed to push you to your limit, please remember that there is always a community to turn to! You don't need to know how to solve every problem straight away, BUT you do need to have a general idea of where you are going. This becomes really important when asking your questions because sometimes the problem is your **approach** and not your code.

If you're feeling stuck, it's a good time to pause and take a breather. Break the problem down into little pieces and then decide what is really holding you back. We call this technique [rubber duck debugging](https://en.wikipedia.org/wiki/Rubber_duck_debugging).

You should also do a [Google search](https://www.google.com/) to find relevant information for your problem. Read about [how to use Google to solve your programming questions](https://codinginflow.com/google-programming-questions). You can also look back at previous lessons for tools that you can apply to the current task.

If these methods don't yield a solution for you, then it's time to reach out to the Odin community and ask for help.

## Asking for help

So you've spent some time struggling to solve the problem on your own, and now it's time to fire up the Odin Discord and ask for help. The first thing to keep in mind is [don't ask to ask](https://dontasktoask.com/). While this is a simple idea \(with a pretty catchy motto!\), it can help you get answers to your questions much faster and will make it easier to others to feel comfortable offering you help.

In addition, when you ask your questions, you should help the community help you by putting together a great question.

When asking your question, please remember to include the context:

* What do you think the problem is?
* What exactly do you want to happen?
* What is actually happening?
* How did you get there?
* What have you tried so far?

If you can't pinpoint the problem, you can share a **screenshot**. This is especially useful for showing the output of commands in the command line. In Discord, drag and drop your screenshot image file into the chat box to upload it or simply use the PrtScn and paste keyboard shortcuts. If you don't know how to take a screenshot on your computer, this is a good time to ask Google.

If the puzzle still can't be solved, push your project to GitHub or put your code in a [repl.it](https://repl.it/) so that others can comb through and debug the code. You'll learn all about GitHub very soon.

Sometimes there might be no one around to help you with your issue. That is the ideal time to get familiar with the [Discord search function](https://support.discordapp.com/hc/en-us/articles/115000468588-Using-Search). Search for specific keywords or error messages to see if anyone else had a similar issue before and how they solved it!

### **An important read**

The article [How to be great at asking coding questions](https://medium.com/@gordon_zhu/how-to-be-great-at-asking-questions-e37be04d0603) has really great tips on how to put together an effective question. An effective question makes it easy for us to help you. The strategies outlined there invite you to think deeply about your problem. Sometimes, as a happy accident, you may even lead yourself to the answer as you reflect on the matter. But asking good questions isn't just about us helping you. Great questions make you a great teammate. A future co-worker or manager does not want to spend time poking at your code to learn about your problem. You'll be expected to bring thoughtful and fully developed questions.

## Formatting your questions

Asking your questions in a readable format helps everyone debug them better. Here are some ways to go about that:

If you're having trouble on the command line, make sure to include both your input and the error message you're getting.

In the chat rooms, code can be displayed differently from normal sentences by using **backticks** \(\`\`\), which can be found above the Tab key on US and UK keyboards. Backticks are not the same as single quotation marks \(''\), which are found to the left of the Enter key.

**For a single line of code:**

\`\#use one backtick at both ends\`

**For multiple lines of code:**

\`\`\`

`#use three backticks on a separate line ABOVE your code`

Your Code

`#use three backticks on a separate line BELOW your code`

\`\`\`

In Discord, you can also use **code highlighting** to add color to your code by specifying the language:

\`\`\`javascript

Your Colorful Code

\`\`\`

### Chat features

* Have fun with giphys: type `/giphy hi` to say hi to everyone.
* Type `/help` for more information on chat commands.
* Show your appreciation to those who help you with `@username ++`.
* Don't forget to visit all the available rooms!

## Assignment

1. First, create a free [GitHub account](https://github.com/join). As you will discover, GitHub is an integral part of the development workflow.
2. In a moment we're going to ask you to join The Odin Project's Discord community, here are some guidelines before you dive in:
   * **Ping \(@user\) With a Purpose:** Only @ another user when it is necessary. Include your question or comment in the message. Wait until they reply before pinging again.
   * **Don't 'Bomb' Chats:** Don't send multiple messages in a row, type out your whole message, then push send.
   * **Don't Exclude Anyone:** These are public chats, if someone joins in on a conversation, include them!
   * **Don't Disappear Right After Asking for Help on Code:** If you're posting a question, make sure you have time to stick around and discuss it with those trying to help!
   * **Remember the Human:** Behind every username there is a person with feelings! Be kind! If you don't have anything nice to say, don't say anything at all.
   * **If You Wouldn't Say It Out Loud Don't Type It:** Plain and simple.
   * **Read the Rules:** Upon joining, you will find yourself in the "\#Rules" channel. Please read the rules!
3. Finally, sign in to The Odin Project's [Discord server](https://discord.gg/fbFCkYabZB). Say hello! They've created an introductions-and-checkins room which is a great place to introduce yourself and we're always happy to welcome new community members. They have chat rooms for many development topics and other things. Log into the chat and start exploring!

   **Link your GitHub to your Discord profile:** So others can see what you're working on and vice versa!

   * Discord Settings &gt; Connections &gt; Click GitHub icon &gt; Allow Access &gt; Make sure "Display on profile" is toggled on.

