# How this course will work

## Introduction

In this unit, we'll learn about how the web works and start thinking about the basics of computer and web programming.

Each of the following sections and lessons represents essential baseline knowledge. Even if you have no intention of becoming a web developer yourself, this material should help you gain a useful understanding of the moving parts involved in creating and serving content on the web.

We will start by getting familiar with the internet and your own computer. Next, we'll work on setting up a development environment and learning about Git and GitHub. Then, we'll go over the basics of front end technologies like HTML, CSS, and Javascript before stepping into the back end with a brief foray that covers the basic concepts of back end technologies.

By the end of this unit, you should not only understand how the web works but also be able to identify and differentiate between all of the technologies that you will use to build your own web applications. You will be able to build a simple webpage, style it, and add minor elements of interactivity while working comfortably from the command line.

This section intentionally covers a very broad range of topics. It's silly to go diving straight into server-side programming without having a context for what it is and why it's useful \(and why you should learn it!\).

## How It Works

This curriculum works by pulling together the best content from across the internet for learning a particular topic. In each lesson, we'll introduce the topic and try to provide some useful context before pointing you to external resources made by others.

Most lessons will contain questions that you should be able to answer before moving on. Some of the lessons will ask you to complete exercises. In addition, we provide several projects throughout the curriculum to help you grow your understanding by actually building things.

## A Note About Language

Please be aware that this curriculum is written in English, and maintained by English speakers who are not able or expected to translate it for you. As you develop into a programmer, you will find that the world you are entering into is firmly rooted in the English language. This means that the syntax of your programming language, the documentation that teaches you how to use it, and the majority of the people in the community are all expecting to communicate with you in English.

If you are a non-English speaker, or English is not a primary language for you, this fact is not meant to discourage you, but to prepare you.

As another part of this preparation, we _highly_ recommend spending extra time on topics and terms that you do not understand right away. We also encourage you to seek out additional resources that teach about these topics in your own native language so you can understand them more fully.

In addition to this, you might also consider using a translation dictionary in your own language alongside of our curriculum so you can readily reference it as you go. We do not have any recommendations on these since there are such a wide variety of languages spoken throughout the world, but finding one may perhaps be a good first step in learning how to find useful tools online by searching. This is a skill you will utilize and improve as you progress in your learning to be a developer.

## What Comes Next

Once you've completed this course, you should be pretty comfortable with the building blocks of web programming but itching to dig deeper. Though we spend a fair bit of time digging into each of the major topics in this course, it's really just a taste of what comes next \(and all the cool stuff you can do with it\).

The courses that come after this one are designed to take that foundation and build it into an applied understanding of the material. Those courses will focus on taking these raw building blocks and honing them into a highly functional skillset. Once you've completed the Foundations course, you'll have built a strong foundation to take those next steps.

This curriculum is maintained by professionals. We have chosen some of the best resources available and curated a guide on how to go through them. If there are no good resources, we write our own. With that said, know **everything** in the curriculum is intentionally included and vital for you to become a successful programmer.

As you move forward, in the curriculum each portion is built on everything that came before it, so skipping things will create pockets of non-understanding in your knowledge that start to affect your ability to solve problems and understanding the task at hand.

Additional resources are the only thing that are considered optional unless explicitly stated. These are here in case you feel like you need or want to dive deeper into a topic to get a better understanding.

**DO NOT SKIP ANYTHING!**

## 

