---
description: >-
  Before you can understand how to program the web, you need a more rigorous
  understanding of the web itself than you likely have now.
---

# How does the web work?

## The minute details

These concepts provide a more holistic understanding of the ecosystem in which you will be working and will enable you to talk intelligently with other developers about your work.

## Learning outcomes

At the end of this lesson, you should be able to do the following:

**Describe what the internet is.**

* The internet is a worldwide network of linked computers. Each of these computers can communicate with each other in a specific format.

**Describe what packets are and how they are used to transfer data.**

* Packets are the information of the internet. Packets are sent from the sender to the receiver in a specific format that contains all the information needed to communicate.

**Understand the differences between a web page, web server, web browser and search engine.**

* A web page is the page you look at in your browser.
* A web server is the computer that has the code for how the webpage should look and act.
* A web browser is a program on a computer that displays web pages.
* A search engine is a web server that searches all other web servers for information. A user can then pull up the web page on their web browser and search for a site.

**Briefly explain what a client is.**

* A client is a computer or internet device that requests information from a server.

**Briefly explain what a server is.**

* A server is a computer that receives requests \(as packets\) from the client and responds with the appropriate data.

**Explain what IP addresses are.**

* IP addresses are numerical identifications that specify a destination in a network.

**Explain what DNS servers are.**

* DNS Servers are the "phone book" of the internet. They translate domain names into IP addresses.

**In your own words, explain what happens when you run a search on google.com.**

* User sends request by clicking search button. Google receives the request, looks for the contents of the request in their databases, and sends back the result as a response.

## Assignment

1. Watch this [BBC short](https://www.youtube.com/watch?v=eHp1l73ztB8) for an overview of how the internet works.
2. Read this [article](https://developer.mozilla.org/en-US/Learn/Common_questions/How_does_the_Internet_work) from Mozilla on "How does the Internet work?".
3. Watch [How the Internet Works in 5 Minutes](https://youtu.be/7_LPdttKXPc?t=46s).
4. Read up on the [differences](https://developer.mozilla.org/en-US/Learn/Common_questions/Pages_sites_servers_and_search_engines) between a web page, a web server, and a search engine.
5. Watch this [Google short](https://youtu.be/BrXPcaRlBqo) explaining what a web browser is. Then, find out what web browser you are using right [now](https://www.whatsmybrowser.org/).
6. Read about how one part of the web [interacts with another](https://developer.mozilla.org/en-US/Learn/Getting_started_with_the_web/How_the_Web_works#Clients_and_servers) and [read about](https://developer.mozilla.org/en-US/Learn/Common_questions/What_is_a_domain_name#How_does_a_DNS_request_work) or [watch](https://www.youtube.com/watch?v=72snZctFFtA&feature=youtu.be&t=45s) a DNS request in action.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental material for if you want to dive deeper into something.

* Listen to [Part 1](https://twit.tv/shows/security-now/episodes/25?autostart=false) \(starts around 8:30\) and [Part 2](https://twit.tv/shows/security-now/episodes/26?autostart=false) of Security Now Podcast's _How the web works_ series.
* Watch [A packet's journey](https://www.youtube.com/watch?v=ewrBalT_eBM&feature).
* Consider buying the book [Tubes: Behind the Scenes at the Internet](https://www.amazon.co.uk/dp/B007TB5SKA/ref=dp-kindle-redirect?_encoding=UTF8&btkr=1).
* If you're in for a bit more reading, you can check out the [Introduction to HTTP](https://launchschool.com/books/http) online book at LaunchSchool. This book also touches on some topics covered later in the curriculum, such as developer tools and security. Additionally, you can learn about HTTP tools, which you may find helpful in the future.
* Some advice on reading: We recommend that you only review the immediate links posted in our curriculum. You can always go deeper on any subject if you wish, but be careful not to overload yourself on information!  

