---
description: >-
  Web development could be a good profession for you if you like solving logical
  problems, building useful things, and experimenting with new technologies.
---

# Becoming a web developer

## What do web developers do?

In short, web developers build and maintain websites.

Web developers often work for clients who are trying to get their product or service onto the web. The work is typically very project focused and involves collaborating with a team that helps to coordinate the client's needs into the end product. The client could be a tech company, an organization, or a government. The work could involve front-end, back-end, or full-stack web development.

Web development could be a good profession for you if you like solving logical problems, building useful things, and experimenting with new technologies. Web developers are in high demand, generally have a good work/life balance, and command comfortable salaries. Google your specific location to get a better sense of your local web development job opportunities.

For more details, Wikipedia describes the breadth of the web development profession in their [entry on web design](https://en.wikipedia.org/wiki/Web_design).

## Types of web developers

Earlier, we mentioned that web development work could be in the front end, the back end, or the full stack. What exactly do these terms mean?

The **front end** is the stuff you see on the website in your browser, including the presentation of content and user interface elements like the navigation bar. Front-end developers use HTML, CSS, JavaScript, and their relevant frameworks to ensure that content is presented effectively and that users have an excellent experience.

The **back end** refers to the guts of the application, which live on the server. The back end stores and serves program data to ensure that the front end has what it needs. This process can become very complicated when a website has millions of users. Back-end developers use programming languages like Java, Python, and Ruby to work with data.

**Full-stack developers** are comfortable working with both the front and back ends. In this curriculum, we focus on teaching you full-stack development, covering all aspects of web development.

For more detail, Udacity has a great blog post on this topic: [3 Web Dev Careers Decoded: Front-End vs Back-End vs Full Stack](http://blog.udacity.com/2014/12/front-end-vs-back-end-vs-full-stack-web-developers.html)

## Types of careers

Now that you know about the different types of web developers, let's cover what we mentioned earlier about the different types of clients and employers you may work with.

Large tech companies, such as Google, Facebook, and Amazon, have very stringent hiring requirements. If you successfully meet these expectations, they offer excellent pay, benefits, and opportunities.

Startups are a bit like the wild west. For a junior developer, it can feel like a trial by fire because of the pace of development. Startups often offer slightly lower salaries and require longer hours, but they may also offer equity in the company and highly unique environments.

As a freelancer, you could command a strong hourly wage and the freedom to schedule and design your own products. However, you would be responsible for getting your own work \(which means less coding time\), managing billing from clients \(which can be difficult\), and being solely responsible. Strong people skills are necessary for this path.

As a consultant for a web consultancy, you would give up some of your freelancing wage potential but be able to focus more on the code and less on the hustle. This option also provides a good work/life balance and pay.

Finally, large, older companies still need web developers. These companies offer a good work/life balance, pay, and benefits but often move slower than a company that is highly focused on tech.

## Tools of the trade

These are some of the basic tools you will use regularly. You may not know what they are now, but you most certainly will going forward.

* **Computer**
* [**Google**](https://www.google.com/)
* **Text Editor**
* **Command Line Interface \(CLI\)**
* [**Stack Overflow**](http://stackoverflow.com/)
* [**Git**](https://git-scm.com/)
* [**GitHub**](https://github.com/)

