---
description: >-
  Git is a very popular version control system. You'll become very familiar with
  this piece of software throughout the curriculum.
---

# Git

## Getting started

Git is like a really **epic save button** for your files and directories. Officially, Git is a version control system.

A _save_ in a text editor records all of the words in a document as a single file. You are only ever given one record of the file, such as `essay.doc`, unless you make duplicate copies \(which is difficult to remember to do and keep track of\):

`essay-draft1.doc`, `essay-draft2.doc`, `essay-final.doc`

However, a _save_ in Git records differences in the files and folders AND keeps a **historical record of each save**. This feature is a game changer. As an individual developer, Git enables you to review how your project grows and to easily look at or restore file states from the past. Once connected to a network, Git allows you to push your project to GitHub for sharing and collaborating with other developers.

While Git works on your _local_ machine, GitHub is a _remote_ storage facility on the web for all your coding projects. This means that by learning Git, you will get to showcase your portfolio on GitHub! This is really important because almost all software development companies consider using Git to be an **essential skill** for modern web developers. Having a GitHub portfolio will provide proof to future potential employers as to what you are capable of.

In this lesson, we will briefly explore the history of Git, what it is, and what it's useful for.

In the next lesson, we will go over the basic workflow for using Git, which should enhance your understanding and demonstrate why Git is so useful.

Finally, you will set up a project with Git that will serve as a template for your future projects.

For now, let's learn what Git is and why it's so powerful!

## Learning outcomes:

By the end of this lesson, you should be able to do the following:

* Explain what Git and GitHub are and the differences between the two.
* Describe the differences between Git and a text editor in terms of what they save and their record keeping.
* Describe why Git is useful for an individual developer and a team of developers.

## Assignment

1. Read Chapter 1.1 through 1.4 in [this book about version control](https://git-scm.com/book/en/v2/Getting-Started-About-Version-Control) to learn the differences between local, centralized, and distributed version control systems.
2. Watch [this video](https://www.youtube.com/watch?v=8oRjP8yj2Wo) about how Git can improve the workflow of both an individual and a team of developers.
3. Watch [this video](https://www.youtube.com/watch?v=1h9_cB9mPT8&feature=youtu.be&t=13s) for some history on Git and GitHub, and make sure you know the difference between the two. Git is a technology used in the command line while GitHub is a [website](https://github.com/) you can visit.
4. [Set up Git](https://www.learnhowtocodebook.com/foundations/requirements/setting-up-git) if you haven't already done so.
5. Take a look at The Odin Project's [GitHub repository](https://github.com/TheOdinProject/curriculum) open curriculum for learning, that this GitBook is based on. While you're there, look at all the [contributors](https://github.com/TheOdinProject/curriculum/graphs/contributors) to gain an appreciation for how Git records all collaborative efforts and how GitHub visually represents this.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Git and GitHub in plain English](https://blog.red-badger.com/blog/2016/11/29/gitgithub-in-plain-english)

## Knowledge check

This section contains questions for you to check your understanding of this lesson.

**What kind of program is Git?**

* Git is a version control program.

**What are the differences between Git and a text editor in terms of what they save and their record keeping?**

* A text editor can only make and save changes to a file.
* Git tracks changes to the files and their contents over time.

**Does Git work at a local or remote level?**

* Git works on a local level. Any changes you make are saved locally with Git.

**Does GitHub work at a local or remote level?**

* GitHub works on a remote level. You must push your local changes \(using Git\) to GitHub.

**Why is Git useful for an individual developer?**

* Git is useful for creating snapshots of your work. If you realize halfway through that you've messed up, it's much easier to reset.

**Why are Git and GitHub useful for a team of developers?**

* Git and GitHub are useful for teams because they can merge code together. A developer can work on one part of the code while a second developer works on another part. They can then use Git and GitHub to easily combine their changes.

