---
description: >-
  Developer tools provide you with an incredibly powerful assortment of useful
  tools that will save you a lot of frustration and time as you develop your own
  websites.
---

# Developer Tools

## A developer's close friend

All of the most popular modern web browsers include a suite of tools designed to help with the development of websites. They are sometimes referred to as the web inspector. These tools allow you to inspect the HTML, CSS, JavaScript and much more on websites you visit and build.

## Why do you need to know how to use developer tools?

Knowing how to use your browser's developer tools is an indispensable skill for a web developer. They allow you to easily and quickly track down the cause of issues and bugs, like problems with layout or other CSS hiccups. What might have taken an hour or even a few hours to track down and fix without the use of these tools often takes a matter of minutes or even seconds with the help of developer tools.

As you will come to see in the assignments, much, much more can be done with developer tools other than debugging CSS issues. They provide you with an incredibly powerful assortment of useful tools that will save you a lot of frustration and time as you develop your own websites.

Although they offer you so many useful capabilities, learning how to use the developer tools isn't that difficult. It can feel clunky the first few times you use them, but with a little practice, you will soon find yourself comfortably using them to experiment and fix bugs with ease on your web pages.

## Learning outcomes

Make sure you can do each of the following once you have finished the assignments:

* You can open the developer tools in your browser.
* You can select a specific HTML element on your page with your browser's developer tools.
* You can use developer tools to experiment with the CSS on specific elements of a web page.

## Assignment

1. Watch [this 10-minute video](https://www.youtube.com/watch?v=wcFnnxfA70g) that goes over the most useful features of the Chrome DevTools in some detail.
2. Watch this [awesome tutorial](https://www.youtube.com/watch?v=Z3HGJsNLQ1E) from LearnCode.academy on how to use developer tools effectively when working with your CSS.  It talks a bit about Bootstrap, which you may not know about yet.  Don't worry about it at this point; just check out the stuff he's doing to CSS in the DevTools.  In particular, editing CSS _in the browser_ in real time is a serious productivity booster compared to using your text editor and continuously refreshing to see the changes.
3. Skim through the [official Chrome DevTools docs](https://developers.google.com/web/tools/chrome-devtools/) [\(or Firefox's!\)](https://developer.mozilla.org/en-US/docs/Tools). Chrome and Firefox are constantly enhancing and updating their developer tools.  The basic functionality is going to be the same of course, but it's not unusual for things to move around or change appearance as the tools evolve.  These docs should be your up-to-date resource.  If your version of DevTools doesn't look like the videos above, reference these docs to find out where everything went.

