---
description: >-
  A frontend developer works between a designer on one end and a backend
  developer on the other, translating the design into code and plugging the data
  from the back-end into the right spots.
---

# Frontend

## Getting started

The "front-end languages" live in the browser. After you type an address into the address bar at the top and hit the enter/return key, your browser will receive at least an HTML file from the web server. That file will likely tell the browser to request a CSS file and a JavaScript file as well \(probably many more than one, but we'll keep it simple\).

Each of these languages performs a separate but very important function and they work harmoniously together to determine how the web page is STRUCTURED \(HTML\), how it LOOKS \(CSS\), and how it FUNCTIONS \(JavaScript\). And keep in mind that your _browser_ handles figuring out how to make these files into a functioning web page \(not the server\).

Front-end web development is NOT design \(you won't be playing around in Photoshop or anything\), but a front-end developer _does_ apply the work of designers to the web page by translating their well-designed layouts into real code. The front-end developer stands between the designer on one end and the back-end developer on the other, translating the design into code and plugging the data from the back-end developer into the right spots. They must also handle all the possible interactions that the user may need to make with the page.

On the front end, you will need to be highly conscious of who your user is and how they will be interacting with your web page, because you are building their gateway to your page or product. This may mean gaining a strong understanding of accessibility and things like responsive development down the line, but first you need to build up your toolkit and pick up the fundamentals of the front-end languages.

In the following lessons, you'll get a healthy understanding of each of the three front-end languages. To get warmed up, we'll start at the high level.

## Learning outcomes

Look through these now and then use them to test yourself after doing the assignment:

* What is the role of HTML in a web page?
* What is the role of CSS in a web page?
* What is the role of JavaScript in a web page?

## Assignment

1. Read a brief intro to front-end development from this [interview with Nick Schaden](https://web.archive.org/web/20200601022721/https://generalassemb.ly/blog/what-is-front-end-web-development/).
2. Read about the [role of HTML](https://webapps-for-beginners.rubymonstas.org/html.html) from this Ruby Monstas page.
3. Get a high-level overview of how all three languages work together in MDN's [Getting started with the web](https://developer.mozilla.org/en-US/Learn/Getting_started_with_the_web). Learners should only read: [Dealing with files](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/Dealing_with_files), [HTML basics](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/HTML_basics), [CSS basics](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/CSS_basics) and [JavaScript basics](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/JavaScript_basics). There is no need to implement the website; simply read about the process at this point.
4. Get an overview of what you can do with these documentation pages: [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Element), [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS/Reference#Keyword_index), and [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference). You will not understand most of what is there just yet, but bookmark the pages for later reference.
5. Bookmark [DevDocs.io](https://devdocs.io/). Read the "Welcome" message. Massive API documentation collection that even works offline. Essential collection of reference material for everything covered and more. \(Maintained by [FreeCodeCamp](https://www.freecodecamp.org/)\)

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* Watch [this awesome video](https://www.youtube.com/watch?v=gT0Lh1eYk78) explaining the big picture of the three core web technologies: HTML, CSS and JavaScript.
* [This video](https://www.youtube.com/watch?v=BANChTkxYYY&list=PLwqG3V3cExWpCgHOcLEKg6z-InpjHr7MB) is another great introduction to how the various front-end technologies interact.
* [Skills of a Successful Front-End Web Developer](https://web.archive.org/web/20151110193658/https://www.drupal.org/node/1245650) from Drupal \(a CMS based on PHP\).

